/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.asf;

import android.content.Context;
import android.view.Display;
import android.view.WindowManager;
import com.amplifyframework.auth.cognito.asf.DataCollector;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/amplifyframework/auth/cognito/asf/DeviceDataCollector;", "Lcom/amplifyframework/auth/cognito/asf/DataCollector;", "deviceId", "", "(Ljava/lang/String;)V", "language", "thirdPartyDeviceAgent", "timezone", "Ljava/util/TimeZone;", "timezoneOffset", "getTimezoneOffset", "()Ljava/lang/String;", "collect", "", "context", "Landroid/content/Context;", "getDisplay", "Landroid/view/Display;", "Companion", "aws-auth-cognito_release"})
public final class DeviceDataCollector
implements DataCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String deviceId;
    @NotNull
    private final String thirdPartyDeviceAgent;
    @NotNull
    private final String language;
    @NotNull
    private final TimeZone timezone;
    @NotNull
    private static final String PLATFORM_VALUE = "ANDROID";
    @NotNull
    public static final String DEVICE_AGENT = "DeviceId";
    @NotNull
    public static final String THIRD_PARTY_DEVICE_AGENT = "ThirdPartyDeviceId";
    @NotNull
    public static final String PLATFORM_KEY = "Platform";
    @NotNull
    public static final String TIMEZONE = "ClientTimezone";
    @NotNull
    public static final String DEVICE_HEIGHT = "ScreenHeightPixels";
    @NotNull
    public static final String DEVICE_WIDTH = "ScreenWidthPixels";
    @NotNull
    public static final String DEVICE_LANGUAGE = "DeviceLanguage";

    public DeviceDataCollector(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.deviceId = deviceId;
        this.thirdPartyDeviceAgent = "android_id";
        String string = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.language = string;
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault(...)");
        this.timezone = timeZone;
    }

    private final String getTimezoneOffset() {
        long rawTimezoneOffset = this.timezone.getRawOffset();
        long hours = TimeUnit.MILLISECONDS.toHours(rawTimezoneOffset);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(rawTimezoneOffset) - TimeUnit.HOURS.toMinutes(hours);
        String string = hours < 0L ? "-" : "";
        Locale locale = Locale.US;
        String string2 = "%02d:%02d";
        Object[] objectArray = new Object[]{Math.abs(hours), minutes};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string + string3;
    }

    private final Display getDisplay(Context context) {
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"getDefaultDisplay(...)");
        return display;
    }

    @Override
    @NotNull
    public Map<String, String> collect(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Display display = this.getDisplay(context);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TIMEZONE, (Object)this.getTimezoneOffset()), TuplesKt.to((Object)PLATFORM_KEY, (Object)PLATFORM_VALUE), TuplesKt.to((Object)THIRD_PARTY_DEVICE_AGENT, (Object)this.thirdPartyDeviceAgent), TuplesKt.to((Object)DEVICE_AGENT, (Object)this.deviceId), TuplesKt.to((Object)DEVICE_LANGUAGE, (Object)this.language), TuplesKt.to((Object)DEVICE_HEIGHT, (Object)String.valueOf(display.getHeight())), TuplesKt.to((Object)DEVICE_WIDTH, (Object)String.valueOf(display.getWidth()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amplifyframework/auth/cognito/asf/DeviceDataCollector$Companion;", "", "()V", "DEVICE_AGENT", "", "DEVICE_HEIGHT", "DEVICE_LANGUAGE", "DEVICE_WIDTH", "PLATFORM_KEY", "PLATFORM_VALUE", "THIRD_PARTY_DEVICE_AGENT", "TIMEZONE", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

