/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.asf;

import android.util.Base64;
import android.util.Log;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amplifyframework/auth/cognito/asf/SignatureGenerator;", "", "()V", "Companion", "aws-auth-cognito_release"})
public final class SignatureGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = SignatureGenerator.class.getSimpleName();
    @NotNull
    private static final String HMAC_SHA_256 = "HmacSHA256";

    @JvmStatic
    @NotNull
    public static final String getSignature(@NotNull String data, @NotNull String secret, @NotNull String version) {
        return Companion.getSignature(data, secret, version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/amplifyframework/auth/cognito/asf/SignatureGenerator$Companion;", "", "()V", "HMAC_SHA_256", "", "TAG", "kotlin.jvm.PlatformType", "getSignature", "data", "secret", "version", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getSignature(@NotNull String data, @NotNull String secret, @NotNull String version) {
            String string;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            try {
                Mac mac = Mac.getInstance(SignatureGenerator.HMAC_SHA_256);
                String string2 = secret;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                SecretKeySpec secretKey = new SecretKeySpec(byArray, SignatureGenerator.HMAC_SHA_256);
                mac.init(secretKey);
                string2 = version;
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                mac.update(byArray2);
                Object object = data;
                byte[] byArray3 = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                byte[] signature = mac.doFinal(byArray3);
                byte[] byArray4 = Base64.encode((byte[])signature, (int)2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"encode(...)");
                object = byArray4;
                string = new String((byte[])object, Charsets.UTF_8);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Exception while completing context data signature", (Throwable)e);
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

