/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.asf;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.amplifyframework.auth.cognito.asf.ContextDataAggregator;
import com.amplifyframework.auth.cognito.asf.SignatureGenerator;
import java.util.Map;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00132\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/amplifyframework/auth/cognito/asf/UserContextDataProvider;", "", "context", "Landroid/content/Context;", "poolId", "", "clientId", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "aggregator", "Lcom/amplifyframework/auth/cognito/asf/ContextDataAggregator;", "timestamp", "getEncodedContextData", "username", "deviceId", "getEncodedResponse", "jsonResponse", "Lorg/json/JSONObject;", "getJsonPayload", "contextData", "", "userPoolId", "getJsonResponse", "payload", "signature", "Companion", "aws-auth-cognito_release"})
public final class UserContextDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String poolId;
    @NotNull
    private final String clientId;
    @NotNull
    private final String timestamp;
    private ContextDataAggregator aggregator;
    private static final String TAG = UserContextDataProvider.class.getSimpleName();
    @NotNull
    private static final String VERSION_VALUE = "ANDROID20171114";
    @NotNull
    private static final String CONTEXT_DATA = "contextData";
    @NotNull
    private static final String USERNAME = "username";
    @NotNull
    private static final String USER_POOL_ID = "userPoolId";
    @NotNull
    private static final String TIMESTAMP_MILLI_SEC = "timestamp";
    @NotNull
    private static final String DATA_PAYLOAD = "payload";
    @NotNull
    private static final String VERSION_KEY = "version";
    @NotNull
    private static final String SIGNATURE = "signature";

    public UserContextDataProvider(@NotNull Context context, @NotNull String poolId, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)poolId, (String)"poolId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.context = context;
        this.poolId = poolId;
        this.clientId = clientId;
        this.timestamp = String.valueOf(System.currentTimeMillis());
    }

    private final JSONObject getJsonPayload(Map<String, String> contextData, String username, String userPoolId) throws JSONException {
        JSONObject payload = new JSONObject();
        payload.put(CONTEXT_DATA, (Object)new JSONObject(contextData));
        payload.put(USERNAME, (Object)username);
        payload.put(USER_POOL_ID, (Object)userPoolId);
        payload.put(TIMESTAMP_MILLI_SEC, (Object)this.timestamp);
        return payload;
    }

    private final JSONObject getJsonResponse(String payload, String signature) throws JSONException {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put(DATA_PAYLOAD, (Object)payload);
        jsonResponse.put(SIGNATURE, (Object)signature);
        jsonResponse.put(VERSION_KEY, (Object)VERSION_VALUE);
        return jsonResponse;
    }

    private final String getEncodedResponse(JSONObject jsonResponse) {
        String string = jsonResponse.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        String string3 = Base64.encodeToString((byte[])bytes, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(...)");
        return string3;
    }

    @Nullable
    public final String getEncodedContextData(@NotNull String username, @NotNull String deviceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)username, (String)USERNAME);
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        try {
            this.aggregator = (ContextDataAggregator)LazyKt.lazy((Function0)((Function0)new Function0<ContextDataAggregator>(deviceId){
                final /* synthetic */ String $deviceId;
                {
                    this.$deviceId = $deviceId;
                    super(0);
                }

                @NotNull
                public final ContextDataAggregator invoke() {
                    return new ContextDataAggregator(this.$deviceId);
                }
            })).getValue();
            ContextDataAggregator contextDataAggregator = this.aggregator;
            if (contextDataAggregator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aggregator");
                contextDataAggregator = null;
            }
            Map<String, String> contextData = contextDataAggregator.getAggregatedData(this.context);
            JSONObject payload = this.getJsonPayload(contextData, username, this.poolId);
            String string2 = payload.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String payloadString = string2;
            String signature = SignatureGenerator.Companion.getSignature(payloadString, this.clientId, VERSION_VALUE);
            JSONObject jsonResponse = this.getJsonResponse(payloadString, signature);
            string = this.getEncodedResponse(jsonResponse);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception in creating JSON from context data");
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amplifyframework/auth/cognito/asf/UserContextDataProvider$Companion;", "", "()V", "CONTEXT_DATA", "", "DATA_PAYLOAD", "SIGNATURE", "TAG", "kotlin.jvm.PlatformType", "TIMESTAMP_MILLI_SEC", "USERNAME", "USER_POOL_ID", "VERSION_KEY", "VERSION_VALUE", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

