/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.data;

import android.content.Context;
import com.amplifyframework.auth.cognito.AuthConfiguration;
import com.amplifyframework.auth.cognito.data.KeyValueRepositoryFactory;
import com.amplifyframework.core.store.KeyValueRepository;
import com.amplifyframework.statemachine.codegen.data.AmplifyCredential;
import com.amplifyframework.statemachine.codegen.data.AuthCredentialStore;
import com.amplifyframework.statemachine.codegen.data.DeviceMetadata;
import com.amplifyframework.statemachine.codegen.data.IdentityPoolConfiguration;
import com.amplifyframework.statemachine.codegen.data.UserPoolConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0019H\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u001cH\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/amplifyframework/auth/cognito/data/AWSCognitoAuthCredentialStore;", "Lcom/amplifyframework/statemachine/codegen/data/AuthCredentialStore;", "context", "Landroid/content/Context;", "authConfiguration", "Lcom/amplifyframework/auth/cognito/AuthConfiguration;", "isPersistenceEnabled", "", "keyValueRepoFactory", "Lcom/amplifyframework/auth/cognito/data/KeyValueRepositoryFactory;", "(Landroid/content/Context;Lcom/amplifyframework/auth/cognito/AuthConfiguration;ZLcom/amplifyframework/auth/cognito/data/KeyValueRepositoryFactory;)V", "getContext", "()Landroid/content/Context;", "keyValue", "Lcom/amplifyframework/core/store/KeyValueRepository;", "deleteASFDevice", "", "deleteCredential", "deleteDeviceKeyCredential", "username", "", "deserializeASFDevice", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential$ASFDevice;", "encodedASFDevice", "deserializeCredential", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;", "encodedCredential", "deserializeMetadata", "Lcom/amplifyframework/statemachine/codegen/data/DeviceMetadata;", "encodedDeviceMetadata", "generateKey", "keySuffix", "retrieveASFDevice", "retrieveCredential", "retrieveDeviceMetadata", "saveASFDevice", "device", "saveCredential", "credential", "saveDeviceMetadata", "deviceMetadata", "serializeASFDevice", "serializeCredential", "serializeMetaData", "Companion", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nAWSCognitoAuthCredentialStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWSCognitoAuthCredentialStore.kt\ncom/amplifyframework/auth/cognito/data/AWSCognitoAuthCredentialStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,139:1\n1#2:140\n96#3:141\n96#3:142\n96#3:143\n113#4:144\n113#4:145\n113#4:146\n*S KotlinDebug\n*F\n+ 1 AWSCognitoAuthCredentialStore.kt\ncom/amplifyframework/auth/cognito/data/AWSCognitoAuthCredentialStore\n*L\n99#1:141\n108#1:142\n117#1:143\n127#1:144\n131#1:145\n135#1:146\n*E\n"})
public final class AWSCognitoAuthCredentialStore
implements AuthCredentialStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final AuthConfiguration authConfiguration;
    @NotNull
    private KeyValueRepository keyValue;
    @NotNull
    public static final String awsKeyValueStoreIdentifier = "com.amplify.credentialStore";
    @NotNull
    private static final String Key_Session = "session";
    @NotNull
    private static final String Key_DeviceMetadata = "deviceMetadata";
    @NotNull
    private static final String Key_ASFDevice = "asfDevice";

    public AWSCognitoAuthCredentialStore(@NotNull Context context, @NotNull AuthConfiguration authConfiguration, boolean isPersistenceEnabled, @NotNull KeyValueRepositoryFactory keyValueRepoFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)authConfiguration, (String)"authConfiguration");
        Intrinsics.checkNotNullParameter((Object)keyValueRepoFactory, (String)"keyValueRepoFactory");
        this.context = context;
        this.authConfiguration = authConfiguration;
        this.keyValue = keyValueRepoFactory.create(this.context, awsKeyValueStoreIdentifier, isPersistenceEnabled);
    }

    public /* synthetic */ AWSCognitoAuthCredentialStore(Context context, AuthConfiguration authConfiguration, boolean bl, KeyValueRepositoryFactory keyValueRepositoryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            keyValueRepositoryFactory = new KeyValueRepositoryFactory();
        }
        this(context, authConfiguration, bl, keyValueRepositoryFactory);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void saveCredential(@NotNull AmplifyCredential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        this.keyValue.put(this.generateKey(Key_Session), this.serializeCredential(credential));
    }

    @Override
    public void saveDeviceMetadata(@NotNull String username, @NotNull DeviceMetadata deviceMetadata) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)deviceMetadata, (String)Key_DeviceMetadata);
        this.keyValue.put(this.generateKey(username + ".deviceMetadata"), this.serializeMetaData(deviceMetadata));
    }

    @Override
    public void saveASFDevice(@NotNull AmplifyCredential.ASFDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.keyValue.put(this.generateKey(Key_ASFDevice), this.serializeASFDevice(device));
    }

    @Override
    @NotNull
    public AmplifyCredential retrieveCredential() {
        return this.deserializeCredential(this.keyValue.get(this.generateKey(Key_Session)));
    }

    @Override
    @NotNull
    public DeviceMetadata retrieveDeviceMetadata(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return this.deserializeMetadata(this.keyValue.get(this.generateKey(username + ".deviceMetadata")));
    }

    @Override
    @NotNull
    public AmplifyCredential.ASFDevice retrieveASFDevice() {
        return this.deserializeASFDevice(this.keyValue.get(this.generateKey(Key_ASFDevice)));
    }

    @Override
    public void deleteCredential() {
        this.keyValue.remove(this.generateKey(Key_Session));
    }

    @Override
    public void deleteDeviceKeyCredential(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.keyValue.remove(this.generateKey(username + ".deviceMetadata"));
    }

    @Override
    public void deleteASFDevice() {
        this.keyValue.remove(this.generateKey(Key_ASFDevice));
    }

    private final String generateKey(String keySuffix) {
        Object prefix;
        block1: {
            Object it;
            prefix = null;
            prefix = "amplify";
            UserPoolConfiguration userPoolConfiguration = this.authConfiguration.getUserPool();
            if (userPoolConfiguration != null) {
                it = userPoolConfiguration;
                boolean bl = false;
                prefix = prefix + "." + ((UserPoolConfiguration)it).getPoolId();
            }
            IdentityPoolConfiguration identityPoolConfiguration = this.authConfiguration.getIdentityPool();
            if (identityPoolConfiguration == null) break block1;
            it = identityPoolConfiguration;
            boolean bl = false;
            prefix = prefix + "." + ((IdentityPoolConfiguration)it).getPoolId();
        }
        return prefix + "." + keySuffix;
    }

    private final AmplifyCredential deserializeCredential(String encodedCredential) {
        AmplifyCredential amplifyCredential;
        try {
            AmplifyCredential credentials;
            AmplifyCredential amplifyCredential2;
            AmplifyCredential amplifyCredential3;
            String string = encodedCredential;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                Object object = this_$iv.decodeFromString((DeserializationStrategy)AmplifyCredential.Companion.serializer(), it);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.amplifyframework.statemachine.codegen.data.AmplifyCredential");
                amplifyCredential3 = (AmplifyCredential)object;
            } else {
                amplifyCredential3 = null;
            }
            if ((amplifyCredential2 = (credentials = amplifyCredential3)) == null) {
                amplifyCredential2 = AmplifyCredential.Empty.INSTANCE;
            }
            amplifyCredential = amplifyCredential2;
        }
        catch (Exception e) {
            amplifyCredential = AmplifyCredential.Empty.INSTANCE;
        }
        return amplifyCredential;
    }

    private final DeviceMetadata deserializeMetadata(String encodedDeviceMetadata) {
        DeviceMetadata deviceMetadata;
        try {
            DeviceMetadata deviceMetadata2;
            DeviceMetadata deviceMetadata3;
            DeviceMetadata deviceMetadata4;
            String string = encodedDeviceMetadata;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                Object object = this_$iv.decodeFromString((DeserializationStrategy)DeviceMetadata.Companion.serializer(), it);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.amplifyframework.statemachine.codegen.data.DeviceMetadata");
                deviceMetadata4 = (DeviceMetadata)object;
            } else {
                deviceMetadata4 = null;
            }
            if ((deviceMetadata3 = (deviceMetadata2 = deviceMetadata4)) == null) {
                deviceMetadata3 = DeviceMetadata.Empty.INSTANCE;
            }
            deviceMetadata = deviceMetadata3;
        }
        catch (Exception e) {
            deviceMetadata = DeviceMetadata.Empty.INSTANCE;
        }
        return deviceMetadata;
    }

    private final AmplifyCredential.ASFDevice deserializeASFDevice(String encodedASFDevice) {
        AmplifyCredential.ASFDevice aSFDevice;
        try {
            AmplifyCredential.ASFDevice asfDevice;
            AmplifyCredential.ASFDevice aSFDevice2;
            AmplifyCredential.ASFDevice aSFDevice3;
            String string = encodedASFDevice;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                Object object = this_$iv.decodeFromString((DeserializationStrategy)AmplifyCredential.ASFDevice.Companion.serializer(), it);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.amplifyframework.statemachine.codegen.data.AmplifyCredential.ASFDevice");
                aSFDevice3 = (AmplifyCredential.ASFDevice)object;
            } else {
                aSFDevice3 = null;
            }
            if ((aSFDevice2 = (asfDevice = aSFDevice3)) == null) {
                aSFDevice2 = new AmplifyCredential.ASFDevice(null);
            }
            aSFDevice = aSFDevice2;
        }
        catch (Exception e) {
            aSFDevice = new AmplifyCredential.ASFDevice(null);
        }
        return aSFDevice;
    }

    private final String serializeCredential(AmplifyCredential credential) {
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)AmplifyCredential.Companion.serializer(), (Object)credential);
    }

    private final String serializeMetaData(DeviceMetadata deviceMetadata) {
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)DeviceMetadata.Companion.serializer(), (Object)deviceMetadata);
    }

    private final String serializeASFDevice(AmplifyCredential.ASFDevice device) {
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)AmplifyCredential.ASFDevice.Companion.serializer(), (Object)device);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/amplifyframework/auth/cognito/data/AWSCognitoAuthCredentialStore$Companion;", "", "()V", "Key_ASFDevice", "", "Key_DeviceMetadata", "Key_Session", "awsKeyValueStoreIdentifier", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

