/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.data;

import android.content.Context;
import android.content.SharedPreferences;
import com.amplifyframework.auth.AuthProvider;
import com.amplifyframework.auth.cognito.AuthConfiguration;
import com.amplifyframework.auth.cognito.data.KeyValueRepositoryFactory;
import com.amplifyframework.auth.cognito.helpers.CodegenExtensionsKt;
import com.amplifyframework.auth.cognito.helpers.SessionHelper;
import com.amplifyframework.core.store.KeyValueRepository;
import com.amplifyframework.statemachine.codegen.data.AWSCredentials;
import com.amplifyframework.statemachine.codegen.data.AmplifyCredential;
import com.amplifyframework.statemachine.codegen.data.AuthCredentialStore;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import com.amplifyframework.statemachine.codegen.data.DeviceMetadata;
import com.amplifyframework.statemachine.codegen.data.FederatedToken;
import com.amplifyframework.statemachine.codegen.data.IdentityPoolConfiguration;
import com.amplifyframework.statemachine.codegen.data.SignInMethod;
import com.amplifyframework.statemachine.codegen.data.SignedInData;
import com.amplifyframework.statemachine.codegen.data.UserPoolConfiguration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 @2\u00020\u0001:\u0001@B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u001bH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190$H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u001e\u0010+\u001a\u0004\u0018\u00010,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190$H\u0002J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020\u0019H\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u00105\u001a\u0004\u0018\u00010\u0019J\n\u00106\u001a\u0004\u0018\u000107H\u0002J\n\u00108\u001a\u0004\u0018\u000109H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020(H\u0016J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020/H\u0016J\u0018\u0010>\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010?\u001a\u000201H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/amplifyframework/auth/cognito/data/AWSCognitoLegacyCredentialStore;", "Lcom/amplifyframework/statemachine/codegen/data/AuthCredentialStore;", "context", "Landroid/content/Context;", "authConfiguration", "Lcom/amplifyframework/auth/cognito/AuthConfiguration;", "keyValueRepoFactory", "Lcom/amplifyframework/auth/cognito/data/KeyValueRepositoryFactory;", "(Landroid/content/Context;Lcom/amplifyframework/auth/cognito/AuthConfiguration;Lcom/amplifyframework/auth/cognito/data/KeyValueRepositoryFactory;)V", "getContext", "()Landroid/content/Context;", "deviceKeyValue", "Lcom/amplifyframework/core/store/KeyValueRepository;", "idAndCredentialsKeyValue", "getIdAndCredentialsKeyValue", "()Lcom/amplifyframework/core/store/KeyValueRepository;", "idAndCredentialsKeyValue$delegate", "Lkotlin/Lazy;", "mobileClientKeyValue", "getMobileClientKeyValue", "mobileClientKeyValue$delegate", "tokensKeyValue", "getTokensKeyValue", "tokensKeyValue$delegate", "userDeviceDetailsCacheKey", "", "deleteASFDevice", "", "deleteAWSCredentials", "deleteCognitoUserPoolTokens", "deleteCredential", "deleteDeviceKeyCredential", "username", "deleteIdentityId", "getIdentityPoolId", "getTokenKeys", "", "namespace", "key", "retrieveASFDevice", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential$ASFDevice;", "retrieveAWSCredentials", "Lcom/amplifyframework/statemachine/codegen/data/AWSCredentials;", "retrieveCognitoUserPoolTokens", "Lcom/amplifyframework/statemachine/codegen/data/CognitoUserPoolTokens;", "keys", "retrieveCredential", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;", "retrieveDeviceMetadata", "Lcom/amplifyframework/statemachine/codegen/data/DeviceMetadata;", "retrieveFederateToIdentityPoolToken", "Lcom/amplifyframework/statemachine/codegen/data/FederatedToken;", "retrieveIdentityId", "retrieveLastAuthUserId", "retrieveSignedInData", "Lcom/amplifyframework/statemachine/codegen/data/SignedInData;", "retrieveUserPoolSignInMethod", "Lcom/amplifyframework/statemachine/codegen/data/SignInMethod;", "saveASFDevice", "device", "saveCredential", "credential", "saveDeviceMetadata", "deviceMetadata", "Companion", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nAWSCognitoLegacyCredentialStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWSCognitoLegacyCredentialStore.kt\ncom/amplifyframework/auth/cognito/data/AWSCognitoLegacyCredentialStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,365:1\n1#2:366\n*E\n"})
public final class AWSCognitoLegacyCredentialStore
implements AuthCredentialStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final AuthConfiguration authConfiguration;
    @NotNull
    private final KeyValueRepositoryFactory keyValueRepoFactory;
    @NotNull
    private final String userDeviceDetailsCacheKey;
    @NotNull
    private final Lazy idAndCredentialsKeyValue$delegate;
    @NotNull
    private final Lazy mobileClientKeyValue$delegate;
    @NotNull
    private final Lazy tokensKeyValue$delegate;
    private KeyValueRepository deviceKeyValue;
    @NotNull
    public static final String AWS_KEY_VALUE_STORE_NAMESPACE_IDENTIFIER = "com.amazonaws.android.auth";
    @NotNull
    public static final String AWS_MOBILE_CLIENT_PROVIDER = "com.amazonaws.mobile.client";
    @NotNull
    public static final String APP_TOKENS_INFO_CACHE = "CognitoIdentityProviderCache";
    @NotNull
    public static final String APP_DEVICE_INFO_CACHE = "CognitoIdentityProviderDeviceCache";
    @NotNull
    public static final String LOCAL_STORAGE_PATH = "AWS.Cognito.ContextData";
    @NotNull
    private static final String DEVICE_KEY = "DeviceKey";
    @NotNull
    private static final String DEVICE_GROUP_KEY = "DeviceGroupKey";
    @NotNull
    private static final String DEVICE_SECRET_KEY = "DeviceSecret";
    @NotNull
    private static final String LOCAL_STORAGE_DEVICE_ID_KEY = "CognitoDeviceId";
    @NotNull
    private static final String ID_KEY = "identityId";
    @NotNull
    private static final String AK_KEY = "accessKey";
    @NotNull
    private static final String SK_KEY = "secretKey";
    @NotNull
    private static final String ST_KEY = "sessionToken";
    @NotNull
    private static final String EXP_KEY = "expirationDate";
    @NotNull
    private static final String APP_LAST_AUTH_USER = "LastAuthUser";
    @NotNull
    private static final String APP_LOCAL_CACHE_KEY_PREFIX = "CognitoIdentityProvider";
    @NotNull
    private static final String TOKEN_TYPE_ID = "idToken";
    @NotNull
    private static final String TOKEN_TYPE_ACCESS = "accessToken";
    @NotNull
    private static final String TOKEN_TYPE_REFRESH = "refreshToken";
    @NotNull
    private static final String TOKEN_EXPIRATION = "tokenExpiration";
    @NotNull
    public static final String PROVIDER_KEY = "provider";
    @NotNull
    public static final String SIGN_IN_MODE_KEY = "signInMode";
    @NotNull
    public static final String TOKEN_KEY = "token";

    public AWSCognitoLegacyCredentialStore(@NotNull Context context, @NotNull AuthConfiguration authConfiguration, @NotNull KeyValueRepositoryFactory keyValueRepoFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)authConfiguration, (String)"authConfiguration");
        Intrinsics.checkNotNullParameter((Object)keyValueRepoFactory, (String)"keyValueRepoFactory");
        this.context = context;
        this.authConfiguration = authConfiguration;
        this.keyValueRepoFactory = keyValueRepoFactory;
        UserPoolConfiguration userPoolConfiguration = this.authConfiguration.getUserPool();
        this.userDeviceDetailsCacheKey = "CognitoIdentityProviderDeviceCache." + (userPoolConfiguration != null ? userPoolConfiguration.getPoolId() : null) + ".%s";
        this.idAndCredentialsKeyValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyValueRepository>(this){
            final /* synthetic */ AWSCognitoLegacyCredentialStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KeyValueRepository invoke() {
                return KeyValueRepositoryFactory.create$default(AWSCognitoLegacyCredentialStore.access$getKeyValueRepoFactory$p(this.this$0), this.this$0.getContext(), "com.amazonaws.android.auth", false, 4, null);
            }
        }));
        this.mobileClientKeyValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyValueRepository>(this){
            final /* synthetic */ AWSCognitoLegacyCredentialStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KeyValueRepository invoke() {
                return KeyValueRepositoryFactory.create$default(AWSCognitoLegacyCredentialStore.access$getKeyValueRepoFactory$p(this.this$0), this.this$0.getContext(), "com.amazonaws.mobile.client", false, 4, null);
            }
        }));
        this.tokensKeyValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KeyValueRepository>(this){
            final /* synthetic */ AWSCognitoLegacyCredentialStore this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KeyValueRepository invoke() {
                return KeyValueRepositoryFactory.create$default(AWSCognitoLegacyCredentialStore.access$getKeyValueRepoFactory$p(this.this$0), this.this$0.getContext(), "CognitoIdentityProviderCache", false, 4, null);
            }
        }));
    }

    public /* synthetic */ AWSCognitoLegacyCredentialStore(Context context, AuthConfiguration authConfiguration, KeyValueRepositoryFactory keyValueRepositoryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keyValueRepositoryFactory = new KeyValueRepositoryFactory();
        }
        this(context, authConfiguration, keyValueRepositoryFactory);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final KeyValueRepository getIdAndCredentialsKeyValue() {
        Lazy lazy = this.idAndCredentialsKeyValue$delegate;
        return (KeyValueRepository)lazy.getValue();
    }

    private final KeyValueRepository getMobileClientKeyValue() {
        Lazy lazy = this.mobileClientKeyValue$delegate;
        return (KeyValueRepository)lazy.getValue();
    }

    private final KeyValueRepository getTokensKeyValue() {
        Lazy lazy = this.tokensKeyValue$delegate;
        return (KeyValueRepository)lazy.getValue();
    }

    @Override
    public void saveCredential(@NotNull AmplifyCredential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
    }

    @Override
    public void saveDeviceMetadata(@NotNull String username, @NotNull DeviceMetadata deviceMetadata) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)deviceMetadata, (String)"deviceMetadata");
    }

    @Override
    public void saveASFDevice(@NotNull AmplifyCredential.ASFDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
    }

    @Nullable
    public final synchronized String retrieveLastAuthUserId() {
        String string;
        Map<String, String> keys = this.getTokenKeys();
        String string2 = keys.get(APP_LAST_AUTH_USER);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = this.getTokensKeyValue().get(it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public synchronized AmplifyCredential retrieveCredential() {
        AmplifyCredential amplifyCredential;
        SignedInData signedInData = this.retrieveSignedInData();
        AWSCredentials awsCredentials = this.retrieveAWSCredentials();
        String identityId = this.retrieveIdentityId();
        if (awsCredentials != null && identityId != null) {
            FederatedToken federateToIdentityPoolToken = this.retrieveFederateToIdentityPoolToken();
            amplifyCredential = signedInData != null ? new AmplifyCredential.UserAndIdentityPool(signedInData, identityId, awsCredentials) : (federateToIdentityPoolToken != null ? new AmplifyCredential.IdentityPoolFederated(federateToIdentityPoolToken, identityId, awsCredentials) : new AmplifyCredential.IdentityPool(identityId, awsCredentials));
        } else {
            amplifyCredential = signedInData != null ? (AmplifyCredential)new AmplifyCredential.UserPool(signedInData) : (AmplifyCredential)AmplifyCredential.Empty.INSTANCE;
        }
        return amplifyCredential;
    }

    @Override
    @NotNull
    public synchronized AmplifyCredential.ASFDevice retrieveASFDevice() {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = this.context.getSharedPreferences(LOCAL_STORAGE_PATH, 0);
        String deviceId = sharedPreferences2 != null ? sharedPreferences2.getString(LOCAL_STORAGE_DEVICE_ID_KEY, null) : null;
        return new AmplifyCredential.ASFDevice(deviceId);
    }

    @Override
    public void deleteCredential() {
        this.deleteAWSCredentials();
        this.deleteIdentityId();
        this.deleteCognitoUserPoolTokens();
    }

    @Override
    public void deleteDeviceKeyCredential(@NotNull String username) {
        KeyValueRepository keyValueRepository;
        KeyValueRepository keyValueRepository2;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Map<String, String> keys = this.getTokenKeys();
        String string = keys.get(APP_LAST_AUTH_USER);
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.getTokensKeyValue().remove(it);
        }
        if ((keyValueRepository2 = this.deviceKeyValue) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceKeyValue");
            keyValueRepository2 = null;
        }
        KeyValueRepository $this$deleteDeviceKeyCredential_u24lambda_u242 = keyValueRepository = keyValueRepository2;
        boolean bl = false;
        $this$deleteDeviceKeyCredential_u24lambda_u242.remove(DEVICE_KEY);
        $this$deleteDeviceKeyCredential_u24lambda_u242.remove(DEVICE_GROUP_KEY);
        $this$deleteDeviceKeyCredential_u24lambda_u242.remove(DEVICE_SECRET_KEY);
    }

    @Override
    public void deleteASFDevice() {
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(LOCAL_STORAGE_PATH, 0);
        sharedPreferences.edit().remove(LOCAL_STORAGE_DEVICE_ID_KEY).apply();
    }

    private final void deleteCognitoUserPoolTokens() {
        block3: {
            String it;
            Map<String, String> keys = this.getTokenKeys();
            String string = keys.get(TOKEN_TYPE_ID);
            if (string != null) {
                it = string;
                boolean bl = false;
                this.getTokensKeyValue().remove(it);
            }
            String string2 = keys.get(TOKEN_TYPE_ACCESS);
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.getTokensKeyValue().remove(it);
            }
            String string3 = keys.get(TOKEN_TYPE_REFRESH);
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                this.getTokensKeyValue().remove(it);
            }
            String string4 = keys.get(TOKEN_EXPIRATION);
            if (string4 == null) break block3;
            it = string4;
            boolean bl = false;
            this.getTokensKeyValue().remove(it);
        }
    }

    private final void deleteIdentityId() {
        this.getIdAndCredentialsKeyValue().remove(this.namespace(ID_KEY));
    }

    private final void deleteAWSCredentials() {
        KeyValueRepository keyValueRepository;
        KeyValueRepository $this$deleteAWSCredentials_u24lambda_u247 = keyValueRepository = this.getIdAndCredentialsKeyValue();
        boolean bl = false;
        $this$deleteAWSCredentials_u24lambda_u247.remove(this.namespace(AK_KEY));
        $this$deleteAWSCredentials_u24lambda_u247.remove(this.namespace(SK_KEY));
        $this$deleteAWSCredentials_u24lambda_u247.remove(this.namespace(ST_KEY));
        $this$deleteAWSCredentials_u24lambda_u247.remove(this.namespace(EXP_KEY));
    }

    private final AWSCredentials retrieveAWSCredentials() {
        Long l;
        String accessKey = this.getIdAndCredentialsKeyValue().get(this.namespace(AK_KEY));
        String secretKey = this.getIdAndCredentialsKeyValue().get(this.namespace(SK_KEY));
        String sessionToken = this.getIdAndCredentialsKeyValue().get(this.namespace(ST_KEY));
        Object object = this.getIdAndCredentialsKeyValue().get(this.namespace(EXP_KEY));
        if (object != null && (object = StringsKt.toLongOrNull((String)object)) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            l = Instant.ofEpochSecond(it).isAfter(Instant.now().plus(365L, ChronoUnit.DAYS)) ? it / (long)1000 : it;
        } else {
            l = null;
        }
        Long expiration = l;
        return accessKey == null && secretKey == null && sessionToken == null ? null : new AWSCredentials(accessKey, secretKey, sessionToken, expiration);
    }

    private final String retrieveIdentityId() {
        return this.getIdAndCredentialsKeyValue().get(this.namespace(ID_KEY));
    }

    private final SignedInData retrieveSignedInData() {
        String string;
        String string2;
        Map<String, String> keys = this.getTokenKeys();
        CognitoUserPoolTokens cognitoUserPoolTokens = this.retrieveCognitoUserPoolTokens(keys);
        if (cognitoUserPoolTokens == null) {
            return null;
        }
        CognitoUserPoolTokens cognitoUserPoolTokens2 = cognitoUserPoolTokens;
        SignInMethod signInMethod = this.retrieveUserPoolSignInMethod();
        if (signInMethod == null) {
            return null;
        }
        SignInMethod signInMethod2 = signInMethod;
        try {
            String string3;
            block13: {
                block12: {
                    string3 = cognitoUserPoolTokens2.getAccessToken();
                    if (string3 == null) break block12;
                    String it = string3;
                    boolean bl = false;
                    String string4 = SessionHelper.INSTANCE.getUserSub(it);
                    string3 = string4;
                    if (string4 != null) break block13;
                }
                string3 = "";
            }
            string2 = string3;
        }
        catch (Exception e) {
            string2 = "";
        }
        String tokenUserId = string2;
        try {
            String string5;
            block15: {
                block14: {
                    string5 = cognitoUserPoolTokens2.getAccessToken();
                    if (string5 == null) break block14;
                    String it = string5;
                    boolean bl = false;
                    String string6 = SessionHelper.INSTANCE.getUsername(it);
                    string5 = string6;
                    if (string6 != null) break block15;
                }
                string5 = "";
            }
            string = string5;
        }
        catch (Exception e) {
            string = "";
        }
        String tokenUsername = string;
        return new SignedInData(tokenUserId, tokenUsername, new Date(0L), signInMethod2, cognitoUserPoolTokens2);
    }

    @Override
    @NotNull
    public synchronized DeviceMetadata retrieveDeviceMetadata(@NotNull String username) {
        DeviceMetadata deviceMetadata;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        String string = this.userDeviceDetailsCacheKey;
        Object[] objectArray = new Object[]{username};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String deviceDetailsCacheKey = string2;
        this.deviceKeyValue = KeyValueRepositoryFactory.create$default(this.keyValueRepoFactory, this.context, deviceDetailsCacheKey, false, 4, null);
        KeyValueRepository keyValueRepository = this.deviceKeyValue;
        if (keyValueRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceKeyValue");
            keyValueRepository = null;
        }
        String deviceKey = keyValueRepository.get(DEVICE_KEY);
        KeyValueRepository keyValueRepository2 = this.deviceKeyValue;
        if (keyValueRepository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceKeyValue");
            keyValueRepository2 = null;
        }
        String deviceGroupKey = keyValueRepository2.get(DEVICE_GROUP_KEY);
        KeyValueRepository keyValueRepository3 = this.deviceKeyValue;
        if (keyValueRepository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceKeyValue");
            keyValueRepository3 = null;
        }
        String deviceSecretKey = keyValueRepository3.get(DEVICE_SECRET_KEY);
        CharSequence charSequence = deviceKey;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)deviceGroupKey) == null || charSequence.length() == 0)) {
            deviceMetadata = DeviceMetadata.Empty.INSTANCE;
        } else {
            String string3;
            String string4 = deviceKey;
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = deviceGroupKey) == null) {
                string3 = "";
            }
            deviceMetadata = new DeviceMetadata.Metadata(string4, string3, deviceSecretKey);
        }
        return deviceMetadata;
    }

    /*
     * Unable to fully structure code
     */
    private final CognitoUserPoolTokens retrieveCognitoUserPoolTokens(Map<String, String> keys) {
        v0 = keys.get("idToken");
        if (v0 != null) {
            it = v0;
            $i$a$-let-AWSCognitoLegacyCredentialStore$retrieveCognitoUserPoolTokens$idToken$1 = false;
            v1 = this.getTokensKeyValue().get(it);
        } else {
            v1 = null;
        }
        idToken = v1;
        v2 = keys.get("accessToken");
        if (v2 != null) {
            it = v2;
            $i$a$-let-AWSCognitoLegacyCredentialStore$retrieveCognitoUserPoolTokens$accessToken$1 = false;
            v3 = this.getTokensKeyValue().get(it);
        } else {
            v3 = null;
        }
        accessToken = v3;
        v4 = keys.get("refreshToken");
        if (v4 != null) {
            it = v4;
            $i$a$-let-AWSCognitoLegacyCredentialStore$retrieveCognitoUserPoolTokens$refreshToken$1 = false;
            v5 = this.getTokensKeyValue().get(it);
        } else {
            v5 = refreshToken = null;
        }
        if ((v6 = keys.get("tokenExpiration")) == null) ** GOTO lbl-1000
        it = v6;
        $i$a$-let-AWSCognitoLegacyCredentialStore$retrieveCognitoUserPoolTokens$expiration$1 = false;
        v7 = this.getTokensKeyValue().get(it);
        v6 = v7;
        if (v7 != null) {
            v8 = StringsKt.toLongOrNull((String)v6);
        } else lbl-1000:
        // 2 sources

        {
            v8 = null;
        }
        expiration = v8;
        return idToken == null && accessToken == null && refreshToken == null ? null : new CognitoUserPoolTokens(idToken, accessToken, refreshToken, expiration);
    }

    private final Map<String, String> getTokenKeys() {
        UserPoolConfiguration userPoolConfiguration = this.authConfiguration.getUserPool();
        String appClient = userPoolConfiguration != null ? userPoolConfiguration.getAppClient() : null;
        Locale locale = Locale.US;
        String string = "%s.%s.%s";
        Object object = new Object[]{APP_LOCAL_CACHE_KEY_PREFIX, appClient, APP_LAST_AUTH_USER};
        String string2 = String.format(locale, string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String userIdTokenKey = string2;
        String userId = this.getTokensKeyValue().get(userIdTokenKey);
        object = Locale.US;
        Object object2 = "%s.%s.%s.%s";
        Object object3 = new Object[]{APP_LOCAL_CACHE_KEY_PREFIX, appClient, userId, TOKEN_TYPE_ID};
        String string3 = String.format((Locale)object, (String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String cachedIdTokenKey = string3;
        object2 = Locale.US;
        object3 = "%s.%s.%s.%s";
        Object object4 = new Object[]{APP_LOCAL_CACHE_KEY_PREFIX, appClient, userId, TOKEN_TYPE_ACCESS};
        String string4 = String.format((Locale)object2, (String)object3, Arrays.copyOf(object4, ((Object[])object4).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String cachedAccessTokenKey = string4;
        object3 = Locale.US;
        object4 = "%s.%s.%s.%s";
        Object object5 = new Object[]{APP_LOCAL_CACHE_KEY_PREFIX, appClient, userId, TOKEN_TYPE_REFRESH};
        String string5 = String.format((Locale)object3, (String)object4, Arrays.copyOf(object5, ((Object[])object5).length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        String cachedRefreshTokenKey = string5;
        object4 = Locale.US;
        object5 = "%s.%s.%s.%s";
        Object[] objectArray = new Object[]{APP_LOCAL_CACHE_KEY_PREFIX, appClient, userId, TOKEN_EXPIRATION};
        String string6 = String.format((Locale)object4, (String)object5, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        String cachedTokenExpirationKey = string6;
        object3 = new Pair[]{TuplesKt.to((Object)APP_LAST_AUTH_USER, (Object)userIdTokenKey), TuplesKt.to((Object)TOKEN_TYPE_ID, (Object)cachedIdTokenKey), TuplesKt.to((Object)TOKEN_TYPE_ACCESS, (Object)cachedAccessTokenKey), TuplesKt.to((Object)TOKEN_TYPE_REFRESH, (Object)cachedRefreshTokenKey), TuplesKt.to((Object)TOKEN_EXPIRATION, (Object)cachedTokenExpirationKey)};
        return MapsKt.mapOf((Pair[])object3);
    }

    private final String namespace(String key) {
        return this.getIdentityPoolId() + "." + key;
    }

    private final String getIdentityPoolId() {
        IdentityPoolConfiguration identityPoolConfiguration = this.authConfiguration.getIdentityPool();
        return identityPoolConfiguration != null ? identityPoolConfiguration.getPoolId() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SignInMethod retrieveUserPoolSignInMethod() {
        SignInMethod signInMethod;
        String string = this.getMobileClientKeyValue().get(SIGN_IN_MODE_KEY);
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 49: {
                    if (!string.equals("1")) break;
                    n = 1;
                    break;
                }
                case 50: {
                    if (!string.equals("2")) break;
                    n = 2;
                    break;
                }
                case 51: {
                    if (!string.equals("3")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    signInMethod = this.retrieveFederateToIdentityPoolToken() != null ? null : new SignInMethod.ApiBased(SignInMethod.ApiBased.AuthType.UNKNOWN);
                    return signInMethod;
                }
                case 2: {
                    signInMethod = new SignInMethod.HostedUI(null, 1, null);
                    return signInMethod;
                }
                case 3: {
                    return null;
                }
            }
        }
        signInMethod = new SignInMethod.ApiBased(SignInMethod.ApiBased.AuthType.USER_SRP_AUTH);
        return signInMethod;
    }

    private final FederatedToken retrieveFederateToIdentityPoolToken() {
        String string = this.getMobileClientKeyValue().get(PROVIDER_KEY);
        if (string == null) {
            return null;
        }
        String provider = string;
        String string2 = this.getMobileClientKeyValue().get(TOKEN_KEY);
        if (string2 == null) {
            return null;
        }
        String token = string2;
        Object[] objectArray = new String[4];
        AuthProvider authProvider = AuthProvider.amazon();
        Intrinsics.checkNotNullExpressionValue((Object)authProvider, (String)"amazon(...)");
        objectArray[0] = CodegenExtensionsKt.getIdentityProviderName(authProvider);
        AuthProvider authProvider2 = AuthProvider.facebook();
        Intrinsics.checkNotNullExpressionValue((Object)authProvider2, (String)"facebook(...)");
        objectArray[1] = CodegenExtensionsKt.getIdentityProviderName(authProvider2);
        AuthProvider authProvider3 = AuthProvider.apple();
        Intrinsics.checkNotNullExpressionValue((Object)authProvider3, (String)"apple(...)");
        objectArray[2] = CodegenExtensionsKt.getIdentityProviderName(authProvider3);
        AuthProvider authProvider4 = AuthProvider.google();
        Intrinsics.checkNotNullExpressionValue((Object)authProvider4, (String)"google(...)");
        objectArray[3] = CodegenExtensionsKt.getIdentityProviderName(authProvider4);
        List federatedIdentityPoolProviders = CollectionsKt.listOf((Object[])objectArray);
        return federatedIdentityPoolProviders.contains(provider) ? new FederatedToken(provider, token) : null;
    }

    public static final /* synthetic */ KeyValueRepositoryFactory access$getKeyValueRepoFactory$p(AWSCognitoLegacyCredentialStore $this) {
        return $this.keyValueRepoFactory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/amplifyframework/auth/cognito/data/AWSCognitoLegacyCredentialStore$Companion;", "", "()V", "AK_KEY", "", "APP_DEVICE_INFO_CACHE", "APP_LAST_AUTH_USER", "APP_LOCAL_CACHE_KEY_PREFIX", "APP_TOKENS_INFO_CACHE", "AWS_KEY_VALUE_STORE_NAMESPACE_IDENTIFIER", "AWS_MOBILE_CLIENT_PROVIDER", "DEVICE_GROUP_KEY", "DEVICE_KEY", "DEVICE_SECRET_KEY", "EXP_KEY", "ID_KEY", "LOCAL_STORAGE_DEVICE_ID_KEY", "LOCAL_STORAGE_PATH", "PROVIDER_KEY", "SIGN_IN_MODE_KEY", "SK_KEY", "ST_KEY", "TOKEN_EXPIRATION", "TOKEN_KEY", "TOKEN_TYPE_ACCESS", "TOKEN_TYPE_ID", "TOKEN_TYPE_REFRESH", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

