/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.data;

import android.security.keystore.KeyGenParameterSpec;
import com.amplifyframework.statemachine.codegen.errors.CredentialStoreError;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/amplifyframework/auth/cognito/data/LegacyKeyProvider;", "", "()V", "AES_KEY_ALGORITHM", "", "ANDROID_KEY_STORE_NAME", "CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS", "", "deleteKey", "", "keyAlias", "generateKey", "Lkotlin/Result;", "Ljava/security/Key;", "generateKey-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "retrieveKey", "retrieveKey-IoAF18A", "aws-auth-cognito_release"})
public final class LegacyKeyProvider {
    @NotNull
    public static final LegacyKeyProvider INSTANCE = new LegacyKeyProvider();
    @NotNull
    private static final String AES_KEY_ALGORITHM = "AES";
    private static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    @NotNull
    private static final String ANDROID_KEY_STORE_NAME = "AndroidKeyStore";

    private LegacyKeyProvider() {
    }

    @NotNull
    public final Object generateKey-IoAF18A(@NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
        keyStore.load(null);
        if (keyStore.containsAlias(keyAlias)) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CredentialStoreError("Key already exists for the keyAlias: " + keyAlias + " in AndroidKeyStore", null, 2, null)));
        }
        String[] stringArray = new String[]{"GCM"};
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyAlias, 3).setBlockModes(stringArray);
        stringArray = new String[]{"NoPadding"};
        KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).setKeySize(256).setRandomizedEncryptionRequired(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"build(...)");
        KeyGenParameterSpec parameterSpec = keyGenParameterSpec;
        KeyGenerator generator = KeyGenerator.getInstance(AES_KEY_ALGORITHM, ANDROID_KEY_STORE_NAME);
        generator.init((AlgorithmParameterSpec)parameterSpec);
        return Result.constructor-impl((Object)generator.generateKey());
    }

    @NotNull
    public final Object retrieveKey-IoAF18A(@NotNull String keyAlias) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
        keyStore.load(null);
        if (!keyStore.containsAlias(keyAlias)) {
            String message = "Key does not exists for the keyAlias: " + keyAlias + " in AndroidKeyStore";
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CredentialStoreError(message, null, 2, null)));
        }
        Key key = keyStore.getKey(keyAlias, null);
        if (key != null) {
            object = Result.constructor-impl((Object)key);
        } else {
            String message = "Key is null even though the keyAlias: " + keyAlias + " is present in AndroidKeyStore";
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CredentialStoreError(message, null, 2, null)));
        }
        return object;
    }

    public final void deleteKey(@NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
        keyStore.load(null);
        keyStore.deleteEntry(keyAlias);
    }
}

