/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.amplifyframework.auth.cognito.data.LegacyKeyProvider;
import com.amplifyframework.core.store.KeyValueRepository;
import com.amplifyframework.statemachine.codegen.errors.CredentialStoreError;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0005H\u0002J\u001a\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010!\u001a\u00020\u0005H\u0016J&\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b-\u0010\u001dR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lcom/amplifyframework/auth/cognito/data/LegacyKeyValueRepository;", "Lcom/amplifyframework/core/store/KeyValueRepository;", "context", "Landroid/content/Context;", "sharedPreferencesName", "", "isPersistenceEnabled", "", "(Landroid/content/Context;Ljava/lang/String;Z)V", "cache", "", "cacheFactory", "secureRandom", "Ljava/security/SecureRandom;", "sharedPreferencesForData", "Landroid/content/SharedPreferences;", "decrypt", "decryptionKey", "Ljava/security/Key;", "ivSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "encryptedData", "encrypt", "encryptionKey", "data", "generateEncryptionKey", "Lkotlin/Result;", "encryptionKeyAlias", "generateEncryptionKey-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "generateInitializationVector", "", "get", "dataKey", "getCacheForKey", "key", "getDataKeyUsedInPersistentStore", "getEncryptionKeyAlias", "getInitializationVector", "keyOfDataInSharedPreferences", "put", "", "value", "remove", "retrieveEncryptionKey", "retrieveEncryptionKey-IoAF18A", "Companion", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nLegacyKeyValueRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyKeyValueRepository.kt\ncom/amplifyframework/auth/cognito/data/LegacyKeyValueRepository\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n372#2,7:301\n1#3:308\n*S KotlinDebug\n*F\n+ 1 LegacyKeyValueRepository.kt\ncom/amplifyframework/auth/cognito/data/LegacyKeyValueRepository\n*L\n87#1:301,7\n*E\n"})
public final class LegacyKeyValueRepository
implements KeyValueRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sharedPreferencesName;
    private boolean isPersistenceEnabled;
    @NotNull
    private final SecureRandom secureRandom;
    @NotNull
    private SharedPreferences sharedPreferencesForData;
    @NotNull
    private final Map<String, Map<String, String>> cacheFactory;
    @NotNull
    private final Map<String, String> cache;
    @NotNull
    private static final String CIPHER_AES_GCM_NOPADDING = "AES/GCM/NoPadding";
    private static final int CIPHER_AES_GCM_NOPADDING_IV_LENGTH_IN_BYTES = 12;
    private static final int CIPHER_AES_GCM_NOPADDING_TAG_LENGTH_LENGTH_IN_BITS = 128;
    @NotNull
    private static final String CHARSET_NAME = "UTF-8";
    @NotNull
    private static final String SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX = ".encrypted";
    @NotNull
    private static final String SHARED_PREFERENCES_IV_SUFFIX = ".iv";
    @NotNull
    private static final String SHARED_PREFERENCES_STORE_VERSION_SUFFIX = ".keyvaluestoreversion";
    @NotNull
    private static final String AWS_KEY_VALUE_STORE_VERSION_1_KEY_STORE_ALIAS_FOR_AES_SUFFIX = ".aesKeyStoreAlias";
    private static final int AWS_KEY_VALUE_STORE_VERSION = 1;

    public LegacyKeyValueRepository(@NotNull Context context, @NotNull String sharedPreferencesName, boolean isPersistenceEnabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesName, (String)"sharedPreferencesName");
        this.sharedPreferencesName = sharedPreferencesName;
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.secureRandom = new SecureRandom();
        this.cacheFactory = new LinkedHashMap();
        this.cache = this.getCacheForKey(this.sharedPreferencesName);
        SharedPreferences sharedPreferences = context.getSharedPreferences(this.sharedPreferencesName, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.sharedPreferencesForData = sharedPreferences;
    }

    public /* synthetic */ LegacyKeyValueRepository(Context context, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(context, string, bl);
    }

    private final Map<String, String> getCacheForKey(String key) {
        Map map;
        Map<String, Map<String, String>> $this$getOrPut$iv = this.cacheFactory;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }

    public void put(@NotNull String dataKey, @Nullable String value) {
        Object it;
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        String string = value;
        if (string != null) {
            String string2;
            String it2 = string2 = string;
            boolean bl = false;
            this.cache.put(dataKey, it2);
        }
        if (!this.isPersistenceEnabled) {
            return;
        }
        if (value == null) {
            this.remove(dataKey);
            return;
        }
        String dataKeyInPersistentStore = this.getDataKeyUsedInPersistentStore(dataKey);
        String encryptionKeyAlias = this.getEncryptionKeyAlias();
        Object object = this.retrieveEncryptionKey-IoAF18A(encryptionKeyAlias);
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            throwable = throwable2;
            it = throwable;
            boolean bl = false;
            this.generateEncryptionKey-IoAF18A(encryptionKeyAlias);
        }
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
        if (throwable3 != null) {
            throwable = throwable3;
            it = throwable;
            boolean bl = false;
            return;
        }
        Object encryptionKey = object;
        try {
            byte[] iv = this.generateInitializationVector();
            it = encryptionKey;
            ResultKt.throwOnFailure((Object)it);
            String base64EncodedEncryptedString = this.encrypt((Key)it, new GCMParameterSpec(128, iv), value);
            String string3 = Base64.encodeToString((byte[])iv, (int)0);
            if (string3 == null) {
                throw new Exception("Error in Base64 encoding the IV for dataKey = " + dataKey);
            }
            String base64EncodedIV = string3;
            this.sharedPreferencesForData.edit().putString(dataKeyInPersistentStore, base64EncodedEncryptedString).putString(dataKeyInPersistentStore + SHARED_PREFERENCES_IV_SUFFIX, base64EncodedIV).putInt(dataKeyInPersistentStore + SHARED_PREFERENCES_STORE_VERSION_SUFFIX, 1).apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public synchronized String get(@NotNull String dataKey) {
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        if (!this.isPersistenceEnabled) {
            return this.cache.get(dataKey);
        }
        String dataKeyInPersistentStore = this.getDataKeyUsedInPersistentStore(dataKey);
        String encryptionKeyAlias = this.getEncryptionKeyAlias();
        Object object = this.retrieveEncryptionKey-IoAF18A(encryptionKeyAlias);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            return null;
        }
        Object decryptionKey = object;
        if (!this.sharedPreferencesForData.contains(dataKeyInPersistentStore)) {
            return null;
        }
        try {
            Object object2;
            String decryptedDataInString;
            Integer keyValueStoreVersion;
            String string = this.sharedPreferencesForData.getString(dataKeyInPersistentStore + SHARED_PREFERENCES_STORE_VERSION_SUFFIX, "-1");
            Integer n = keyValueStoreVersion = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            int n2 = 1;
            if (n == null || n != n2) {
                return null;
            }
            String encryptedData = this.sharedPreferencesForData.getString(dataKeyInPersistentStore, null);
            Object object3 = decryptionKey;
            ResultKt.throwOnFailure((Object)object3);
            String string2 = decryptedDataInString = this.decrypt((Key)object3, this.getInitializationVector(dataKeyInPersistentStore), encryptedData);
            if (string2 != null) {
                Object it = object3 = string2;
                boolean bl = false;
                this.cache.put(dataKey, (String)it);
                object2 = object3;
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (Exception ex) {
            this.remove(dataKey);
            object = null;
        }
        return object;
    }

    private final AlgorithmParameterSpec getInitializationVector(String keyOfDataInSharedPreferences) throws Exception {
        String keyOfIV = keyOfDataInSharedPreferences + SHARED_PREFERENCES_IV_SUFFIX;
        if (!this.sharedPreferencesForData.contains(keyOfIV)) {
            throw new Exception("Initialization vector for " + keyOfDataInSharedPreferences + " is missing from the SharedPreferences.");
        }
        String string = this.sharedPreferencesForData.getString(keyOfIV, null);
        if (string == null) {
            throw new Exception("Cannot read the initialization vector for " + keyOfDataInSharedPreferences + " from SharedPreferences.");
        }
        String initializationVectorInString = string;
        byte[] byArray = Base64.decode((String)initializationVectorInString, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] base64DecodedIV = byArray;
        if (base64DecodedIV.length == 0) {
            throw new Exception("Cannot base64 decode the initialization vector for " + keyOfDataInSharedPreferences + " read from SharedPreferences.");
        }
        return new GCMParameterSpec(128, base64DecodedIV);
    }

    private final String decrypt(Key decryptionKey, AlgorithmParameterSpec ivSpec, String encryptedData) {
        String string;
        try {
            byte[] byArray = Base64.decode((String)encryptedData, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] encryptedDecodedData = byArray;
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            cipher.init(2, decryptionKey, ivSpec);
            byte[] decryptedData = cipher.doFinal(encryptedDecodedData);
            Intrinsics.checkNotNull((Object)decryptedData);
            byte[] byArray2 = decryptedData;
            Charset charset = Charset.forName(CHARSET_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            Charset charset2 = charset;
            string = new String(byArray2, charset2);
        }
        catch (Exception ex) {
            string = null;
        }
        return string;
    }

    private final byte[] generateInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    private final String getEncryptionKeyAlias() {
        return this.sharedPreferencesName + AWS_KEY_VALUE_STORE_VERSION_1_KEY_STORE_ALIAS_FOR_AES_SUFFIX;
    }

    public synchronized void remove(@NotNull String dataKey) {
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        this.cache.remove(dataKey);
        if (this.isPersistenceEnabled) {
            String keyUsedInPersistentStore = this.getDataKeyUsedInPersistentStore(dataKey);
            this.sharedPreferencesForData.edit().remove(keyUsedInPersistentStore).remove(keyUsedInPersistentStore + SHARED_PREFERENCES_IV_SUFFIX).remove(keyUsedInPersistentStore + SHARED_PREFERENCES_STORE_VERSION_SUFFIX).apply();
        }
    }

    private final String getDataKeyUsedInPersistentStore(String key) {
        return key + SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX;
    }

    private final synchronized Object retrieveEncryptionKey-IoAF18A(String encryptionKeyAlias) {
        Object object;
        block0: {
            Throwable throwable;
            object = LegacyKeyProvider.INSTANCE.retrieveKey-IoAF18A(encryptionKeyAlias);
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block0;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            LegacyKeyProvider.INSTANCE.deleteKey(encryptionKeyAlias);
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new CredentialStoreError("Key cannot be retrieved. Deleting the encryption key identified by the keyAlias: " + encryptionKeyAlias, null, 2, null)));
        }
        return object;
    }

    private final synchronized Object generateEncryptionKey-IoAF18A(String encryptionKeyAlias) {
        return LegacyKeyProvider.INSTANCE.generateKey-IoAF18A(encryptionKeyAlias);
    }

    private final String encrypt(Key encryptionKey, AlgorithmParameterSpec ivSpec, String data) {
        String string;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            cipher.init(1, encryptionKey, ivSpec);
            Charset charset = Charset.forName(CHARSET_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = data.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] encryptedData = cipher.doFinal(byArray);
            string = Base64.encodeToString((byte[])encryptedData, (int)0);
        }
        catch (Exception ex) {
            Log.e((String)"Error in encrypting data. ", (String)ex.toString());
            string = null;
        }
        return string;
    }

    public void removeAll() {
        KeyValueRepository.DefaultImpls.removeAll((KeyValueRepository)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amplifyframework/auth/cognito/data/LegacyKeyValueRepository$Companion;", "", "()V", "AWS_KEY_VALUE_STORE_VERSION", "", "AWS_KEY_VALUE_STORE_VERSION_1_KEY_STORE_ALIAS_FOR_AES_SUFFIX", "", "CHARSET_NAME", "CIPHER_AES_GCM_NOPADDING", "CIPHER_AES_GCM_NOPADDING_IV_LENGTH_IN_BYTES", "CIPHER_AES_GCM_NOPADDING_TAG_LENGTH_LENGTH_IN_BITS", "SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX", "SHARED_PREFERENCES_IV_SUFFIX", "SHARED_PREFERENCES_STORE_VERSION_SUFFIX", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

