/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import android.util.Base64;
import com.amplifyframework.auth.cognito.exceptions.service.InvalidParameterException;
import com.amplifyframework.auth.exceptions.UnknownException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0010\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/AuthHelper;", "", "()V", "Companion", "aws-auth-cognito_release"})
public class AuthHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HMAC_SHA_256 = "HmacSHA256";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004J&\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/AuthHelper$Companion;", "", "()V", "HMAC_SHA_256", "", "getHMAC_SHA_256", "()Ljava/lang/String;", "getActiveUsername", "username", "alternateUsername", "userIDForSRP", "getSecretHash", "userId", "clientId", "clientSecret", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHMAC_SHA_256() {
            return HMAC_SHA_256;
        }

        @Nullable
        public final String getSecretHash(@Nullable String userId, @Nullable String clientId, @Nullable String clientSecret) {
            CharSequence charSequence;
            if (userId == null) {
                throw new InvalidParameterException(null, new Exception("user ID cannot be null"), 1, null);
            }
            if (clientId == null) {
                throw new InvalidParameterException(null, new Exception("client ID cannot be null"), 1, null);
            }
            CharSequence charSequence2 = clientSecret;
            if (charSequence2 == null || charSequence2.length() == 0) {
                charSequence = null;
            } else {
                try {
                    Mac mac = Mac.getInstance(this.getHMAC_SHA_256());
                    String string = clientSecret;
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    SecretKeySpec keySpec = new SecretKeySpec(byArray, this.getHMAC_SHA_256());
                    mac.init(keySpec);
                    string = userId;
                    byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                    mac.update(byArray2);
                    Object object = clientId;
                    byte[] byArray3 = ((String)object).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                    byte[] raw = mac.doFinal(byArray3);
                    byte[] byArray4 = Base64.encode((byte[])raw, (int)2);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"encode(...)");
                    object = byArray4;
                    charSequence2 = new String((byte[])object, Charsets.UTF_8);
                }
                catch (Exception e) {
                    throw new UnknownException(null, (Throwable)new Exception("errors in HMAC calculation"), 1, null);
                }
                charSequence = charSequence2;
            }
            return charSequence;
        }

        @NotNull
        public final String getActiveUsername(@NotNull String username, @Nullable String alternateUsername, @Nullable String userIDForSRP) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            String string = alternateUsername;
            if (string == null && (string = userIDForSRP) == null) {
                string = username;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

