/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import android.util.Base64;
import com.amplifyframework.auth.cognito.helpers.SRPHelper;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/CognitoDeviceHelper;", "", "()V", "SALT_LENGTH_BITS", "", "generateVerificationParameters", "", "", "deviceKey", "deviceGroup", "aws-auth-cognito_release"})
public final class CognitoDeviceHelper {
    @NotNull
    public static final CognitoDeviceHelper INSTANCE = new CognitoDeviceHelper();
    public static final int SALT_LENGTH_BITS = 128;

    private CognitoDeviceHelper() {
    }

    @NotNull
    public final Map<String, String> generateVerificationParameters(@NotNull String deviceKey, @NotNull String deviceGroup) {
        Map params;
        Intrinsics.checkNotNullParameter((Object)deviceKey, (String)"deviceKey");
        Intrinsics.checkNotNullParameter((Object)deviceGroup, (String)"deviceGroup");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String deviceSecret = string;
        BigInteger salt = new BigInteger(128, new SecureRandom());
        SRPHelper srpHelper = new SRPHelper(deviceSecret);
        srpHelper.setUserPoolParams(deviceKey, deviceGroup);
        BigInteger verifier = srpHelper.computePasswordVerifier$aws_auth_cognito_release(salt);
        Map map = params = (Map)new LinkedHashMap();
        String string2 = "salt";
        String string3 = Base64.encodeToString((byte[])salt.toByteArray(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(...)");
        String string4 = string3;
        map.put(string2, string4);
        map = params;
        string2 = "verifier";
        String string5 = Base64.encodeToString((byte[])verifier.toByteArray(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeToString(...)");
        string4 = string5;
        map.put(string2, string4);
        params.put("secret", deviceSecret);
        return params;
    }
}

