/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import com.amplifyframework.auth.cognito.exceptions.service.InvalidGrantException;
import com.amplifyframework.auth.cognito.exceptions.service.ParseTokenException;
import com.amplifyframework.auth.cognito.helpers.FetchTokenResponse;
import com.amplifyframework.auth.cognito.helpers.HostedUIHttpHelper;
import com.amplifyframework.auth.exceptions.ServiceException;
import com.amplifyframework.auth.exceptions.SessionExpiredException;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/HostedUIHttpHelper;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "fetchTokens", "Lcom/amplifyframework/statemachine/codegen/data/CognitoUserPoolTokens;", "url", "Ljava/net/URL;", "headerParams", "", "", "bodyParams", "parseTokenResponse", "responseString", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nHostedUIHttpHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostedUIHttpHelper.kt\ncom/amplifyframework/auth/cognito/helpers/HostedUIHttpHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,126:1\n125#2:127\n152#2,3:128\n125#2:131\n152#2,3:132\n1#3:135\n96#4:136\n*S KotlinDebug\n*F\n+ 1 HostedUIHttpHelper.kt\ncom/amplifyframework/auth/cognito/helpers/HostedUIHttpHelper\n*L\n51#1:127\n51#1:128,3\n54#1:131\n54#1:132,3\n87#1:136\n*E\n"})
public final class HostedUIHttpHelper {
    @NotNull
    public static final HostedUIHttpHelper INSTANCE = new HostedUIHttpHelper();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);

    private HostedUIHttpHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final CognitoUserPoolTokens fetchTokens(@NotNull URL url, @NotNull Map<String, String> headerParams, @NotNull Map<String, String> bodyParams) throws Exception {
        int n;
        Closeable dos22;
        void $this$mapTo$iv$iv;
        HttpsURLConnection httpsURLConnection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headerParams, (String)"headerParams");
        Intrinsics.checkNotNullParameter(bodyParams, (String)"bodyParams");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection $this$fetchTokens_u24lambda_u243 = httpsURLConnection = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$fetchTokens_u24lambda_u243.setRequestMethod("POST");
        $this$fetchTokens_u24lambda_u243.setDoOutput(true);
        Map<String, String> $this$map$iv = headerParams;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            $this$fetchTokens_u24lambda_u243.addRequestProperty((String)it.getKey(), (String)it.getValue());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Closeable closeable = new DataOutputStream($this$fetchTokens_u24lambda_u243.getOutputStream());
        Object object2 = null;
        try {
            dos22 = (DataOutputStream)closeable;
            n = 0;
            Map<String, String> $this$map$iv2 = bodyParams;
            boolean $i$f$map2 = false;
            Map<String, String> map = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry<String, String> item$iv$iv2;
                Map.Entry<String, String> entry = item$iv$iv2 = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(URLEncoder.encode((String)it.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)it.getValue(), "UTF-8"));
            }
            String requestBody = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            dos22.writeBytes(requestBody);
            dos22 = Unit.INSTANCE;
        }
        catch (Throwable dos22) {
            object2 = dos22;
            throw dos22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        HttpsURLConnection connection = httpsURLConnection;
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 500) {
            InputStream responseStream = responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
            Intrinsics.checkNotNull((Object)responseStream);
            closeable = responseStream;
            object2 = Charsets.UTF_8;
            dos22 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            n = 8192;
            closeable = dos22 instanceof BufferedReader ? (BufferedReader)dos22 : new BufferedReader((Reader)dos22, n);
            object2 = null;
            try {
                BufferedReader p0 = (BufferedReader)closeable;
                boolean bl4 = false;
                object = TextStreamsKt.readText((Reader)p0);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            Object responseString = object;
            return this.parseTokenResponse((String)responseString);
        }
        String string = connection.getResponseMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResponseMessage(...)");
        throw new ServiceException(string, "Sorry, we don\u2019t have a recovery suggestion for this error.", null, 4, null);
    }

    private final CognitoUserPoolTokens parseTokenResponse(String responseString) {
        if (((CharSequence)responseString).length() == 0) {
            throw new ParseTokenException();
        }
        try {
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            FetchTokenResponse response2 = (FetchTokenResponse)this_$iv.decodeFromString((DeserializationStrategy)FetchTokenResponse.Companion.serializer(), responseString);
            String string = response2.getError();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)"invalid_grant")) {
                    throw new SessionExpiredException(it, null, (Throwable)((Object)new InvalidGrantException(it, response2.getErrorDescription())), 2, null);
                }
                throw new ServiceException(it, "Sorry, we don\u2019t have a recovery suggestion for this error.", null, 4, null);
            }
            return new CognitoUserPoolTokens(response2.getIdToken(), response2.getAccessToken(), response2.getRefreshToken(), response2.getExpiration());
        }
        catch (Exception e) {
            if (!(e instanceof SessionExpiredException) && !(e instanceof ServiceException)) {
                String string = e.getMessage();
                if (string == null) {
                    string = "An unknown service error has occurred";
                }
                throw new ServiceException(string, "Sorry, we don\u2019t have a recovery suggestion for this error.", (Throwable)e);
            }
            throw e;
        }
    }
}

