/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import android.util.Base64;
import com.amplifyframework.auth.exceptions.UnknownException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/JWTParser;", "", "()V", "HEADER", "", "JWT_PARTS", "PAYLOAD", "SIGNATURE", "getClaim", "", "jwt", "claim", "getHeader", "Lorg/json/JSONObject;", "getPayload", "getSignature", "hasClaim", "", "key", "validateJWT", "", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nJWTParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWTParser.kt\ncom/amplifyframework/auth/cognito/helpers/JWTParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n37#2,2:133\n37#2,2:135\n37#2,2:137\n37#2,2:140\n1#3:139\n*S KotlinDebug\n*F\n+ 1 JWTParser.kt\ncom/amplifyframework/auth/cognito/helpers/JWTParser\n*L\n42#1:133,2\n59#1:135,2\n78#1:137,2\n126#1:140,2\n*E\n"})
public final class JWTParser {
    @NotNull
    public static final JWTParser INSTANCE = new JWTParser();
    private static final int HEADER = 0;
    private static final int PAYLOAD = 1;
    private static final int SIGNATURE = 2;
    private static final int JWT_PARTS = 3;

    private JWTParser() {
    }

    @NotNull
    public final JSONObject getHeader(@NotNull String jwt) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        try {
            this.validateJWT(jwt);
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            byte[] sectionDecoded = Base64.decode((String)thisCollection$iv.toArray(new String[0])[0], (int)8);
            Intrinsics.checkNotNull((Object)sectionDecoded);
            String jwtSection = new String(sectionDecoded, Charsets.UTF_8);
            jSONObject = new JSONObject(jwtSection);
        }
        catch (Exception e) {
            String string = e.getLocalizedMessage();
            if (string == null) {
                string = "";
            }
            throw new UnknownException(string + ", error in parsing JSON", null, 2, null);
        }
        return jSONObject;
    }

    @NotNull
    public final JSONObject getPayload(@NotNull String jwt) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        try {
            this.validateJWT(jwt);
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String payload = thisCollection$iv.toArray(new String[0])[1];
            byte[] sectionDecoded = Base64.decode((String)payload, (int)8);
            Intrinsics.checkNotNull((Object)sectionDecoded);
            String jwtSection = new String(sectionDecoded, Charsets.UTF_8);
            jSONObject = new JSONObject(jwtSection);
        }
        catch (Exception e) {
            String string = e.getLocalizedMessage();
            if (string == null) {
                string = "";
            }
            throw new UnknownException(string + ", error in parsing JSON", null, 2, null);
        }
        return jSONObject;
    }

    @NotNull
    public final String getSignature(@NotNull String jwt) {
        String string;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        try {
            this.validateJWT(jwt);
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            byte[] sectionDecoded = Base64.decode((String)thisCollection$iv.toArray(new String[0])[2], (int)8);
            Intrinsics.checkNotNull((Object)sectionDecoded);
            string = new String(sectionDecoded, Charsets.UTF_8);
        }
        catch (Exception e) {
            String string2 = e.getLocalizedMessage();
            if (string2 == null) {
                string2 = "";
            }
            throw new UnknownException(string2 + ", error in parsing JSON", null, 2, null);
        }
        return string;
    }

    @Nullable
    public final String getClaim(@NotNull String jwt, @Nullable String claim) {
        String string;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        if (((CharSequence)jwt).length() == 0) {
            return jwt;
        }
        try {
            Object object;
            JSONObject payload = this.getPayload(jwt);
            String string2 = claim;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                object = payload.get(claim);
            } else {
                object = null;
            }
            Object claimValue = object;
            string = String.valueOf(claimValue);
        }
        catch (Exception e) {
            String string3 = e.getLocalizedMessage();
            if (string3 == null) {
                string3 = "";
            }
            throw new UnknownException(string3 + ", Invalid token", null, 2, null);
        }
        return string;
    }

    public final boolean hasClaim(@NotNull String jwt, @Nullable String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        try {
            bl = this.getPayload(jwt).has(key);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final void validateJWT(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        String[] stringArray = new String[]{"."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] jwtParts = thisCollection$iv.toArray(new String[0]);
        if (jwtParts.length != 3) {
            throw new UnknownException("Not a JSON web token. Error in parsing JSON", null, 2, null);
        }
    }
}

