/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import android.util.Base64;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/PkceHelper;", "", "()V", "encodeBase64", "", "str", "generateHash", "data", "generateRandom", "aws-auth-cognito_release"})
public final class PkceHelper {
    @NotNull
    public static final PkceHelper INSTANCE = new PkceHelper();

    private PkceHelper() {
    }

    @NotNull
    public final String generateRandom() {
        byte[] randBytes = new byte[32];
        new SecureRandom().nextBytes(randBytes);
        String string = Base64.encodeToString((byte[])randBytes, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @NotNull
    public final String generateHash(@NotNull String data) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Charset charset = Charset.forName("US-ASCII");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = data.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(bytes, 0, bytes.length);
        byte[] digestBytes = digest.digest();
        String string = Base64.encodeToString((byte[])digestBytes, (int)11);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String encodeBase64(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str;
        Charset charset = Charset.forName("ISO-8859-1");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] data = byArray;
        String string2 = Base64.encodeToString((byte[])data, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }
}

