/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J%\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b-J\u0006\u0010.\u001a\u00020\u0003J\u001e\u0010/\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u0010\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0007J\u0018\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0016\u00104\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/SRPHelper;", "", "password", "", "(Ljava/lang/String;)V", "DERIVED_KEY_INFO", "DERIVED_KEY_SIZE", "", "HEX_N", "N", "Ljava/math/BigInteger;", "dateString", "getDateString", "()Ljava/lang/String;", "setDateString", "digest", "Ljava/security/MessageDigest;", "g", "kotlin.jvm.PlatformType", "k", "privateA", "publicA", "random", "Ljava/security/SecureRandom;", "userId", "userPoolName", "computePasswordAuthenticationKey", "", "ikm", "salt", "computePasswordAuthenticationKey$aws_auth_cognito_release", "computePasswordVerifier", "computePasswordVerifier$aws_auth_cognito_release", "computeS", "uValue", "xValue", "srpB", "computeS$aws_auth_cognito_release", "computeU", "computeU$aws_auth_cognito_release", "computeX", "computeX$aws_auth_cognito_release", "generateM1Signature", "key", "secretBlock", "generateM1Signature$aws_auth_cognito_release", "getPublicA", "getSignature", "modN", "value", "setAValues", "", "setUserPoolParams", "Companion", "aws-auth-cognito_release"})
public final class SRPHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String password;
    private final BigInteger g;
    @NotNull
    private final String HEX_N;
    @NotNull
    private final BigInteger N;
    @NotNull
    private final SecureRandom random;
    @NotNull
    private final String DERIVED_KEY_INFO;
    private final int DERIVED_KEY_SIZE;
    @NotNull
    private final BigInteger k;
    @NotNull
    private BigInteger privateA;
    @NotNull
    private BigInteger publicA;
    @NotNull
    private String dateString;
    @NotNull
    private final MessageDigest digest;
    @NotNull
    private String userId;
    @NotNull
    private String userPoolName;
    private static final int EPHEMERAL_KEY_LENGTH = 1024;
    @NotNull
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public SRPHelper(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.password = password;
        this.g = BigInteger.valueOf(2L);
        this.HEX_N = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF";
        this.N = new BigInteger(this.HEX_N, 16);
        this.random = new SecureRandom();
        this.DERIVED_KEY_INFO = "Caldera Derived Key";
        this.DERIVED_KEY_SIZE = 16;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        this.digest = messageDigest;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)new BigInteger(EPHEMERAL_KEY_LENGTH, this.random).mod(this.N), (String)"mod(...)");
            this.privateA = this.privateA;
            Intrinsics.checkNotNullExpressionValue((Object)this.g.modPow(this.privateA, this.N), (String)"modPow(...)");
            this.publicA = this.publicA;
        } while (Intrinsics.areEqual((Object)this.publicA.mod(this.N), (Object)BigInteger.ZERO));
        this.digest.reset();
        this.digest.update(this.N.toByteArray());
        this.k = new BigInteger(1, this.digest.digest(this.g.toByteArray()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = simpleDateFormat.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        this.dateString = string;
        this.userId = "";
        this.userPoolName = "";
    }

    @NotNull
    public final String getDateString() {
        return this.dateString;
    }

    public final void setDateString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dateString = string;
    }

    public final void setUserPoolParams(@NotNull String userId, @NotNull String userPoolName) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)userPoolName, (String)"userPoolName");
        this.userId = userId;
        this.userPoolName = userPoolName;
        if (StringsKt.contains$default((CharSequence)userPoolName, (CharSequence)"_", (boolean)false, (int)2, null)) {
            CharSequence charSequence = userPoolName;
            Regex regex = new Regex("_");
            int n = 2;
            this.userPoolName = (String)regex.split(charSequence, n).get(1);
        }
    }

    @TestOnly
    @NotNull
    public final BigInteger modN(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BigInteger bigInteger = value.mod(this.N);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"mod(...)");
        return bigInteger;
    }

    @TestOnly
    public final void setAValues(@NotNull BigInteger privateA, @NotNull BigInteger publicA) {
        Intrinsics.checkNotNullParameter((Object)privateA, (String)"privateA");
        Intrinsics.checkNotNullParameter((Object)publicA, (String)"publicA");
        this.privateA = privateA;
        this.publicA = publicA;
    }

    @NotNull
    public final String getPublicA() {
        String string = this.publicA.toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final BigInteger computeU$aws_auth_cognito_release(@NotNull BigInteger srpB) {
        Intrinsics.checkNotNullParameter((Object)srpB, (String)"srpB");
        this.digest.reset();
        this.digest.update(this.publicA.toByteArray());
        return new BigInteger(1, this.digest.digest(srpB.toByteArray()));
    }

    @NotNull
    public final BigInteger computeX$aws_auth_cognito_release(@NotNull BigInteger salt) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.digest.reset();
        String string = this.userPoolName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.digest.update(byArray);
        string = this.userId;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        this.digest.update(byArray2);
        string = ":";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        this.digest.update(byArray3);
        String string2 = this.password;
        byte[] byArray4 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        byte[] userIdPasswordHash = this.digest.digest(byArray4);
        this.digest.reset();
        this.digest.update(salt.toByteArray());
        return new BigInteger(1, this.digest.digest(userIdPasswordHash));
    }

    @NotNull
    public final BigInteger computePasswordVerifier$aws_auth_cognito_release(@NotNull BigInteger salt) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        BigInteger xValue = this.computeX$aws_auth_cognito_release(salt);
        BigInteger bigInteger = this.g.modPow(xValue, this.N);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modPow(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger computeS$aws_auth_cognito_release(@NotNull BigInteger uValue, @NotNull BigInteger xValue, @NotNull BigInteger srpB) {
        Intrinsics.checkNotNullParameter((Object)uValue, (String)"uValue");
        Intrinsics.checkNotNullParameter((Object)xValue, (String)"xValue");
        Intrinsics.checkNotNullParameter((Object)srpB, (String)"srpB");
        BigInteger bigInteger = srpB.subtract(this.k.multiply(this.g.modPow(xValue, this.N))).modPow(this.privateA.add(uValue.multiply(xValue)), this.N).mod(this.N);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"mod(...)");
        return bigInteger;
    }

    @NotNull
    public final byte[] computePasswordAuthenticationKey$aws_auth_cognito_release(@NotNull BigInteger ikm, @NotNull BigInteger salt) {
        Intrinsics.checkNotNullParameter((Object)ikm, (String)"ikm");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Mac mac = Mac.getInstance(HMAC_SHA_256);
        SecretKeySpec keySpec = new SecretKeySpec(salt.toByteArray(), HMAC_SHA_256);
        mac.init(keySpec);
        byte[] prk = mac.doFinal(ikm.toByteArray());
        mac.reset();
        keySpec = new SecretKeySpec(prk, HMAC_SHA_256);
        mac.init(keySpec);
        String string = this.DERIVED_KEY_INFO;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        mac.update(byArray);
        boolean bl = true;
        String string2 = String.valueOf((char)(bl ? 1 : 0));
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] hkdf = mac.doFinal(byArray2);
        Intrinsics.checkNotNull((Object)hkdf);
        byte[] byArray3 = Arrays.copyOf(hkdf, this.DERIVED_KEY_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        return byArray3;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] generateM1Signature$aws_auth_cognito_release(@NotNull byte[] key, @NotNull String secretBlock) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)secretBlock, (String)"secretBlock");
        Mac mac = Mac.getInstance(HMAC_SHA_256);
        SecretKeySpec keySpec = new SecretKeySpec(key, HMAC_SHA_256);
        mac.init(keySpec);
        String string = this.userPoolName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        mac.update(byArray);
        string = this.userId;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        mac.update(byArray2);
        mac.update(Base64.decode((String)secretBlock, (int)2));
        String string2 = this.dateString;
        byte[] byArray3 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        byte[] byArray4 = mac.doFinal(byArray3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"doFinal(...)");
        return byArray4;
    }

    @NotNull
    public final String getSignature(@NotNull String salt, @NotNull String srpB, @NotNull String secretBlock) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)srpB, (String)"srpB");
        Intrinsics.checkNotNullParameter((Object)secretBlock, (String)"secretBlock");
        BigInteger bigIntSRPB = new BigInteger(srpB, 16);
        BigInteger bigIntSalt = new BigInteger(salt, 16);
        if (Intrinsics.areEqual((Object)bigIntSRPB.mod(this.N), (Object)BigInteger.ZERO)) {
            throw new Exception("Bad server public value 'B'");
        }
        BigInteger uValue = this.computeU$aws_auth_cognito_release(bigIntSRPB);
        if (Intrinsics.areEqual((Object)uValue.mod(this.N), (Object)BigInteger.ZERO)) {
            throw new Exception("Hash of A and B cannot be zero");
        }
        BigInteger xValue = this.computeX$aws_auth_cognito_release(bigIntSalt);
        BigInteger sValue = this.computeS$aws_auth_cognito_release(uValue, xValue, bigIntSRPB);
        byte[] key = this.computePasswordAuthenticationKey$aws_auth_cognito_release(sValue, uValue);
        byte[] m1Signature = this.generateM1Signature$aws_auth_cognito_release(key, secretBlock);
        String string = Base64.encodeToString((byte[])m1Signature, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/SRPHelper$Companion;", "", "()V", "EPHEMERAL_KEY_LENGTH", "", "HMAC_SHA_256", "", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

