/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import com.amplifyframework.auth.cognito.helpers.JWTParser;
import com.amplifyframework.statemachine.codegen.data.AWSCredentials;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/SessionHelper;", "", "()V", "getExpiration", "Ljava/time/Instant;", "token", "", "getExpiration$aws_auth_cognito_release", "getUserSub", "getUsername", "isValidSession", "", "awsCredentials", "Lcom/amplifyframework/statemachine/codegen/data/AWSCredentials;", "isValidTokens", "userPoolTokens", "Lcom/amplifyframework/statemachine/codegen/data/CognitoUserPoolTokens;", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nSessionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHelper.kt\ncom/amplifyframework/auth/cognito/helpers/SessionHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class SessionHelper {
    @NotNull
    public static final SessionHelper INSTANCE = new SessionHelper();

    private SessionHelper() {
    }

    @Nullable
    public final Instant getExpiration$aws_auth_cognito_release(@NotNull String token) {
        Instant instant;
        String claim;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = claim = JWTParser.INSTANCE.getClaim(token, "exp");
        if (string != null) {
            String it = string;
            boolean bl = false;
            instant = Instant.ofEpochSecond(Long.parseLong(claim));
        } else {
            instant = null;
        }
        return instant;
    }

    @Nullable
    public final String getUsername(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return JWTParser.INSTANCE.getClaim(token, "username");
    }

    @Nullable
    public final String getUserSub(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return JWTParser.INSTANCE.getClaim(token, "sub");
    }

    public final boolean isValidTokens(@NotNull CognitoUserPoolTokens userPoolTokens) {
        Intrinsics.checkNotNullParameter((Object)userPoolTokens, (String)"userPoolTokens");
        Instant currentTimeStamp = Instant.now();
        return userPoolTokens.getIdToken() == null ? false : (userPoolTokens.getAccessToken() == null ? false : currentTimeStamp.compareTo(this.getExpiration$aws_auth_cognito_release(userPoolTokens.getIdToken())) < 0 && currentTimeStamp.compareTo(this.getExpiration$aws_auth_cognito_release(userPoolTokens.getAccessToken())) < 0);
    }

    public final boolean isValidSession(@NotNull AWSCredentials awsCredentials) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)awsCredentials, (String)"awsCredentials");
        Instant currentTimeStamp = Instant.now();
        Long l = awsCredentials.getExpiration();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.ofEpochSecond(it);
        } else {
            instant = null;
        }
        Instant credentialsExpirationInSecond = instant;
        return currentTimeStamp.compareTo(credentialsExpirationInSecond) < 0 && currentTimeStamp.plus(365L, ChronoUnit.DAYS).compareTo(credentialsExpirationInSecond) > 0;
    }
}

