/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.helpers;

import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType;
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType;
import aws.smithy.kotlin.runtime.time.Instant;
import com.amplifyframework.auth.AuthCodeDeliveryDetails;
import com.amplifyframework.auth.AuthException;
import com.amplifyframework.auth.MFAType;
import com.amplifyframework.auth.TOTPSetupDetails;
import com.amplifyframework.auth.cognito.helpers.SessionHelper;
import com.amplifyframework.auth.exceptions.UnknownException;
import com.amplifyframework.auth.result.AuthSignInResult;
import com.amplifyframework.auth.result.step.AuthNextSignInStep;
import com.amplifyframework.auth.result.step.AuthSignInStep;
import com.amplifyframework.core.Consumer;
import com.amplifyframework.statemachine.StateMachineEvent;
import com.amplifyframework.statemachine.codegen.data.AuthChallenge;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import com.amplifyframework.statemachine.codegen.data.DeviceMetadata;
import com.amplifyframework.statemachine.codegen.data.SignInMethod;
import com.amplifyframework.statemachine.codegen.data.SignInTOTPSetupData;
import com.amplifyframework.statemachine.codegen.data.SignedInData;
import com.amplifyframework.statemachine.codegen.events.AuthenticationEvent;
import com.amplifyframework.statemachine.codegen.events.SignInEvent;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0006JH\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/amplifyframework/auth/cognito/helpers/SignInChallengeHelper;", "", "()V", "evaluateNextStep", "Lcom/amplifyframework/statemachine/StateMachineEvent;", "username", "", "challengeNameType", "Laws/sdk/kotlin/services/cognitoidentityprovider/model/ChallengeNameType;", "session", "challengeParameters", "", "authenticationResult", "Laws/sdk/kotlin/services/cognitoidentityprovider/model/AuthenticationResultType;", "signInMethod", "Lcom/amplifyframework/statemachine/codegen/data/SignInMethod;", "getAllowedMFATypes", "", "Lcom/amplifyframework/auth/MFAType;", "allowedMFAType", "getNextStep", "", "challenge", "Lcom/amplifyframework/statemachine/codegen/data/AuthChallenge;", "onSuccess", "Lcom/amplifyframework/core/Consumer;", "Lcom/amplifyframework/auth/result/AuthSignInResult;", "onError", "Lcom/amplifyframework/auth/AuthException;", "signInTOTPSetupData", "Lcom/amplifyframework/statemachine/codegen/data/SignInTOTPSetupData;", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nSignInChallengeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignInChallengeHelper.kt\ncom/amplifyframework/auth/cognito/helpers/SignInChallengeHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1#2:225\n1855#3,2:226\n*S KotlinDebug\n*F\n+ 1 SignInChallengeHelper.kt\ncom/amplifyframework/auth/cognito/helpers/SignInChallengeHelper\n*L\n214#1:226,2\n*E\n"})
public final class SignInChallengeHelper {
    @NotNull
    public static final SignInChallengeHelper INSTANCE = new SignInChallengeHelper();

    private SignInChallengeHelper() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final StateMachineEvent evaluateNextStep(@NotNull String username, @Nullable ChallengeNameType challengeNameType, @Nullable String session, @Nullable Map<String, String> challengeParameters, @Nullable AuthenticationResultType authenticationResult, @NotNull SignInMethod signInMethod) {
        block14: {
            block16: {
                block15: {
                    block11: {
                        block13: {
                            block12: {
                                Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                                Intrinsics.checkNotNullParameter((Object)signInMethod, (String)"signInMethod");
                                if (authenticationResult == null) break block11;
                                it = authenticationResult;
                                $i$a$-let-SignInChallengeHelper$evaluateNextStep$1 = false;
                                v0 = it.getAccessToken();
                                if (v0 == null) break block12;
                                token = v0;
                                $i$a$-let-SignInChallengeHelper$evaluateNextStep$1$userId$1 = false;
                                v1 = SessionHelper.INSTANCE.getUserSub(token);
                                v0 = v1;
                                if (v1 != null) break block13;
                            }
                            v0 = "";
                        }
                        userId = v0;
                        expiresIn = Instant.Companion.now().plus-LRDsOJo(DurationKt.toDuration((int)it.getExpiresIn(), (DurationUnit)DurationUnit.SECONDS)).getEpochSeconds();
                        tokens = new CognitoUserPoolTokens(it.getIdToken(), it.getAccessToken(), it.getRefreshToken(), expiresIn);
                        signedInData = new SignedInData(userId, username, new Date(), signInMethod, tokens);
                        v2 = it.getNewDeviceMetadata();
                        if (v2 != null) {
                            metadata = v2;
                            $i$a$-let-SignInChallengeHelper$evaluateNextStep$1$1 = false;
                            v3 = metadata.getDeviceKey();
                            if (v3 == null) {
                                v3 = "";
                            }
                            if ((v4 = metadata.getDeviceGroupKey()) == null) {
                                v4 = "";
                            }
                            v5 = new SignInEvent(new SignInEvent.EventType.ConfirmDevice(new DeviceMetadata.Metadata(v3, v4, null, 4, null), signedInData), null, 2, null);
                        } else {
                            v5 = new AuthenticationEvent(new AuthenticationEvent.EventType.SignInCompleted(signedInData, DeviceMetadata.Empty.INSTANCE), null, 2, null);
                        }
                        break block14;
                    }
                    if (!(challengeNameType instanceof ChallengeNameType.SmsMfa) && !(challengeNameType instanceof ChallengeNameType.CustomChallenge) && !(challengeNameType instanceof ChallengeNameType.NewPasswordRequired) && !(challengeNameType instanceof ChallengeNameType.SoftwareTokenMfa) && !(challengeNameType instanceof ChallengeNameType.SelectMfaType)) break block15;
                    challenge = new AuthChallenge(challengeNameType.getValue(), username, session, challengeParameters);
                    v5 = new SignInEvent(new SignInEvent.EventType.ReceivedChallenge(challenge), null, 2, null);
                    break block14;
                }
                if (!(challengeNameType instanceof ChallengeNameType.MfaSetup)) break block16;
                if (challengeParameters == null || (it = challengeParameters.get("MFAS_CAN_SETUP")) == null) ** GOTO lbl-1000
                it = it;
                $i$a$-let-SignInChallengeHelper$evaluateNextStep$allowedMFASetupTypes$1 = false;
                var9_10 = SignInChallengeHelper.INSTANCE.getAllowedMFATypes(it);
                if (var9_10 != null) {
                    v6 = var9_10;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = allowedMFASetupTypes = SetsKt.emptySet();
                }
                if (allowedMFASetupTypes.contains(MFAType.TOTP)) {
                    setupTOTPData = new SignInTOTPSetupData("", session, username);
                    v7 = new SignInEvent(new SignInEvent.EventType.InitiateTOTPSetup(setupTOTPData), null, 2, null);
                } else {
                    v7 = new SignInEvent(new SignInEvent.EventType.ThrowError(new Exception("Cannot initiate MFA setup from available Types: " + allowedMFASetupTypes)), null, 2, null);
                }
                v5 = v7;
                break block14;
            }
            v5 = challengeNameType instanceof ChallengeNameType.DeviceSrpAuth != false ? (StateMachineEvent)new SignInEvent(new SignInEvent.EventType.InitiateSignInWithDeviceSRP(username, MapsKt.emptyMap()), null, 2, null) : (StateMachineEvent)new SignInEvent(new SignInEvent.EventType.ThrowError(new Exception("Response did not contain sign in info.")), null, 2, null);
        }
        return v5;
    }

    public static /* synthetic */ StateMachineEvent evaluateNextStep$default(SignInChallengeHelper signInChallengeHelper, String string, ChallengeNameType challengeNameType, String string2, Map map, AuthenticationResultType authenticationResultType, SignInMethod signInMethod, int n, Object object) {
        if ((n & 0x20) != 0) {
            signInMethod = new SignInMethod.ApiBased(SignInMethod.ApiBased.AuthType.USER_SRP_AUTH);
        }
        return signInChallengeHelper.evaluateNextStep(string, challengeNameType, string2, map, authenticationResultType, signInMethod);
    }

    /*
     * WARNING - void declaration
     */
    public final void getNextStep(@NotNull AuthChallenge challenge, @NotNull Consumer<AuthSignInResult> onSuccess, @NotNull Consumer<AuthException> onError, @Nullable SignInTOTPSetupData signInTOTPSetupData, @Nullable Set<? extends MFAType> allowedMFAType) {
        ChallengeNameType challengeNameType;
        Map challengeParams;
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Map map = challenge.getParameters();
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = challengeParams = MapsKt.emptyMap();
        }
        if ((challengeNameType = ChallengeNameType.Companion.fromValue(challenge.getChallengeName())) instanceof ChallengeNameType.SmsMfa) {
            AuthCodeDeliveryDetails deliveryDetails = new AuthCodeDeliveryDetails((String)MapsKt.getValue((Map)challengeParams, (Object)"CODE_DELIVERY_DESTINATION"), AuthCodeDeliveryDetails.DeliveryMedium.fromString((String)((String)MapsKt.getValue((Map)challengeParams, (Object)"CODE_DELIVERY_DELIVERY_MEDIUM"))));
            AuthSignInResult authSignInResult = new AuthSignInResult(false, new AuthNextSignInStep(AuthSignInStep.CONFIRM_SIGN_IN_WITH_SMS_MFA_CODE, MapsKt.emptyMap(), deliveryDetails, null, null));
            onSuccess.accept((Object)authSignInResult);
        } else if (challengeNameType instanceof ChallengeNameType.NewPasswordRequired) {
            AuthSignInResult authSignInResult = new AuthSignInResult(false, new AuthNextSignInStep(AuthSignInStep.CONFIRM_SIGN_IN_WITH_NEW_PASSWORD, challengeParams, null, null, null));
            onSuccess.accept((Object)authSignInResult);
        } else if (challengeNameType instanceof ChallengeNameType.CustomChallenge) {
            AuthSignInResult authSignInResult = new AuthSignInResult(false, new AuthNextSignInStep(AuthSignInStep.CONFIRM_SIGN_IN_WITH_CUSTOM_CHALLENGE, challengeParams, null, null, null));
            onSuccess.accept((Object)authSignInResult);
        } else if (challengeNameType instanceof ChallengeNameType.SoftwareTokenMfa) {
            AuthSignInResult authSignInResult = new AuthSignInResult(false, new AuthNextSignInStep(AuthSignInStep.CONFIRM_SIGN_IN_WITH_TOTP_CODE, MapsKt.emptyMap(), null, null, null));
            onSuccess.accept((Object)authSignInResult);
        } else if (challengeNameType instanceof ChallengeNameType.MfaSetup) {
            Unit unit;
            SignInTOTPSetupData signInTOTPSetupData2 = signInTOTPSetupData;
            if (signInTOTPSetupData2 != null) {
                SignInTOTPSetupData it = signInTOTPSetupData2;
                boolean bl2 = false;
                AuthSignInResult authSignInResult = new AuthSignInResult(false, new AuthNextSignInStep(AuthSignInStep.CONTINUE_SIGN_IN_WITH_TOTP_SETUP, challengeParams, null, new TOTPSetupDetails(it.getSecretCode(), it.getUsername()), allowedMFAType));
                onSuccess.accept((Object)authSignInResult);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                onError.accept((Object)new UnknownException(null, (Throwable)new Exception("Challenge type not supported."), 1, null));
            }
        } else if (challengeNameType instanceof ChallengeNameType.SelectMfaType) {
            Set<MFAType> set;
            boolean bl = false;
            AuthSignInStep authSignInStep = AuthSignInStep.CONTINUE_SIGN_IN_WITH_MFA_SELECTION;
            Map map2 = MapsKt.emptyMap();
            AuthCodeDeliveryDetails authCodeDeliveryDetails = null;
            TOTPSetupDetails tOTPSetupDetails = null;
            String string = (String)challengeParams.get("MFAS_CAN_CHOOSE");
            if (string != null) {
                void it;
                String bl2 = string;
                TOTPSetupDetails tOTPSetupDetails2 = tOTPSetupDetails;
                AuthCodeDeliveryDetails authCodeDeliveryDetails2 = authCodeDeliveryDetails;
                Map map3 = map2;
                AuthSignInStep authSignInStep2 = authSignInStep;
                boolean bl3 = bl;
                boolean bl4 = false;
                Set<MFAType> set2 = INSTANCE.getAllowedMFATypes((String)it);
                bl = bl3;
                authSignInStep = authSignInStep2;
                map2 = map3;
                authCodeDeliveryDetails = authCodeDeliveryDetails2;
                tOTPSetupDetails = tOTPSetupDetails2;
                set = set2;
            } else {
                set = null;
            }
            Set<MFAType> set3 = set;
            TOTPSetupDetails tOTPSetupDetails3 = tOTPSetupDetails;
            AuthCodeDeliveryDetails authCodeDeliveryDetails3 = authCodeDeliveryDetails;
            Map map4 = map2;
            AuthSignInStep authSignInStep3 = authSignInStep;
            AuthNextSignInStep authNextSignInStep = new AuthNextSignInStep(authSignInStep3, map4, authCodeDeliveryDetails3, tOTPSetupDetails3, set3);
            boolean bl5 = bl;
            AuthSignInResult authSignInResult = new AuthSignInResult(bl5, authNextSignInStep);
            onSuccess.accept((Object)authSignInResult);
        } else {
            onError.accept((Object)new UnknownException(null, (Throwable)new Exception("Challenge type not supported."), 1, null));
        }
    }

    public static /* synthetic */ void getNextStep$default(SignInChallengeHelper signInChallengeHelper, AuthChallenge authChallenge, Consumer consumer, Consumer consumer2, SignInTOTPSetupData signInTOTPSetupData, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            signInTOTPSetupData = null;
        }
        if ((n & 0x10) != 0) {
            set = null;
        }
        signInChallengeHelper.getNextStep(authChallenge, (Consumer<AuthSignInResult>)consumer, (Consumer<AuthException>)consumer2, signInTOTPSetupData, set);
    }

    @NotNull
    public final Set<MFAType> getAllowedMFATypes(@NotNull String allowedMFAType) {
        Intrinsics.checkNotNullParameter((Object)allowedMFAType, (String)"allowedMFAType");
        Set result = new LinkedHashSet();
        String[] stringArray = (String[])allowedMFAType;
        Regex regex = new Regex("\\[|\\]|\"");
        String string = "";
        CharSequence charSequence = regex.replace((CharSequence)stringArray, string);
        stringArray = new String[]{","};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string2 = it;
            if (Intrinsics.areEqual((Object)string2, (Object)"SMS_MFA")) {
                result.add(MFAType.SMS);
                continue;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"SOFTWARE_TOKEN_MFA")) {
                result.add(MFAType.TOTP);
                continue;
            }
            throw new UnknownException(null, (Throwable)new Exception("MFA type not supported."), 1, null);
        }
        return result;
    }
}

