/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.options.AuthSignOutOptions;

public final class AWSCognitoAuthSignOutOptions
extends AuthSignOutOptions {
    private final String browserPackage;

    protected AWSCognitoAuthSignOutOptions(boolean globalSignOut, String browserPackage) {
        super(globalSignOut);
        this.browserPackage = browserPackage;
    }

    @Nullable
    public String getBrowserPackage() {
        return this.browserPackage;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.isGlobalSignOut(), this.getBrowserPackage()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthSignOutOptions authSignOutOptions = (AWSCognitoAuthSignOutOptions)((Object)obj);
        return ObjectsCompat.equals((Object)this.isGlobalSignOut(), (Object)authSignOutOptions.isGlobalSignOut()) && ObjectsCompat.equals((Object)this.getBrowserPackage(), (Object)authSignOutOptions.getBrowserPackage());
    }

    public String toString() {
        return "AWSCognitoAuthSignOutOptions{isGlobalSignOut=" + this.isGlobalSignOut() + ", browserPackage=" + this.getBrowserPackage() + '}';
    }

    public static final class CognitoBuilder
    extends AuthSignOutOptions.Builder<CognitoBuilder> {
        private String browserPackage;

        public CognitoBuilder getThis() {
            return this;
        }

        public CognitoBuilder browserPackage(@NonNull String browserPackage) {
            this.browserPackage = browserPackage;
            return this;
        }

        @NonNull
        public AWSCognitoAuthSignOutOptions build() {
            return new AWSCognitoAuthSignOutOptions(super.isGlobalSignOut(), this.browserPackage);
        }
    }
}

