/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.options.AuthWebUISignInOptions;
import com.amplifyframework.util.Immutable;
import java.util.List;

public final class AWSCognitoAuthWebUISignInOptions
extends AuthWebUISignInOptions {
    private final String idpIdentifier;
    private final String browserPackage;

    protected AWSCognitoAuthWebUISignInOptions(List<String> scopes, String idpIdentifier, String browserPackage) {
        super(scopes);
        this.idpIdentifier = idpIdentifier;
        this.browserPackage = browserPackage;
    }

    @Nullable
    public String getIdpIdentifier() {
        return this.idpIdentifier;
    }

    @Nullable
    public String getBrowserPackage() {
        return this.browserPackage;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getScopes(), this.getIdpIdentifier(), this.getBrowserPackage()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthWebUISignInOptions webUISignInOptions = (AWSCognitoAuthWebUISignInOptions)((Object)obj);
        return ObjectsCompat.equals((Object)this.getScopes(), (Object)webUISignInOptions.getScopes()) && ObjectsCompat.equals((Object)this.getIdpIdentifier(), (Object)webUISignInOptions.getIdpIdentifier()) && ObjectsCompat.equals((Object)this.getBrowserPackage(), (Object)webUISignInOptions.getBrowserPackage());
    }

    public String toString() {
        return "AWSCognitoAuthWebUISignInOptions{scopes=" + this.getScopes() + ", idpIdentifier=" + this.getIdpIdentifier() + ", browserPackage=" + this.getBrowserPackage() + '}';
    }

    public static final class CognitoBuilder
    extends AuthWebUISignInOptions.Builder<CognitoBuilder> {
        private String idpIdentifier;
        private String browserPackage;

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder idpIdentifier(@NonNull String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
            return this.getThis();
        }

        public CognitoBuilder browserPackage(@NonNull String browserPackage) {
            this.browserPackage = browserPackage;
            return this;
        }

        @NonNull
        public AWSCognitoAuthWebUISignInOptions build() {
            return new AWSCognitoAuthWebUISignInOptions(Immutable.of((List)super.getScopes()), this.idpIdentifier, this.browserPackage);
        }
    }
}

