/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.statemachine;

import com.amplifyframework.statemachine.AnyResolver;
import com.amplifyframework.statemachine.State;
import com.amplifyframework.statemachine.StateMachineEvent;
import com.amplifyframework.statemachine.StateMachineResolver;
import com.amplifyframework.statemachine.StateResolution;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u0016B#\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0016\u0010\u000b\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/amplifyframework/statemachine/LoggingStateMachineResolver;", "StateType", "Lcom/amplifyframework/statemachine/State;", "ResolverType", "Lcom/amplifyframework/statemachine/StateMachineResolver;", "resolver", "logger", "Ljava/util/logging/Logger;", "level", "Ljava/util/logging/Level;", "(Lcom/amplifyframework/statemachine/StateMachineResolver;Ljava/util/logging/Logger;Ljava/util/logging/Level;)V", "defaultState", "getDefaultState", "()Lcom/amplifyframework/statemachine/State;", "Lcom/amplifyframework/statemachine/State;", "Lcom/amplifyframework/statemachine/StateMachineResolver;", "resolve", "Lcom/amplifyframework/statemachine/StateResolution;", "oldState", "event", "Lcom/amplifyframework/statemachine/StateMachineEvent;", "(Lcom/amplifyframework/statemachine/State;Lcom/amplifyframework/statemachine/StateMachineEvent;)Lcom/amplifyframework/statemachine/StateResolution;", "Companion", "aws-auth-cognito_release"})
public final class LoggingStateMachineResolver<StateType extends State, ResolverType extends StateMachineResolver<StateType>>
implements StateMachineResolver<StateType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolverType resolver;
    @NotNull
    private final Level level;
    @NotNull
    private Logger logger;
    @NotNull
    private final StateType defaultState;

    public LoggingStateMachineResolver(@NotNull ResolverType resolver, @Nullable Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.resolver = resolver;
        this.level = level;
        Logger logger2 = logger;
        if (logger2 == null) {
            logger2 = Companion.makeDefaultLogger();
        }
        this.logger = logger2;
        this.defaultState = this.resolver.getDefaultState();
    }

    public /* synthetic */ LoggingStateMachineResolver(StateMachineResolver stateMachineResolver, Logger logger, Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = null;
        }
        if ((n & 4) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        this(stateMachineResolver, logger, level);
    }

    @Override
    @NotNull
    public StateType getDefaultState() {
        return this.defaultState;
    }

    @Override
    @NotNull
    public StateResolution<StateType> resolve(@NotNull StateType oldState, @NotNull StateMachineEvent event) {
        Intrinsics.checkNotNullParameter(oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StateResolution<StateType> resolution = this.resolver.resolve(oldState, event);
        this.logger.log(this.level, oldState.toString());
        this.logger.log(this.level, event.getType());
        this.logger.log(this.level, resolution.getNewState().toString());
        return resolution;
    }

    @Override
    @NotNull
    public LoggingStateMachineResolver<StateType, StateMachineResolver<StateType>> logging(@Nullable Logger logger, @NotNull Level level) {
        return StateMachineResolver.DefaultImpls.logging(this, logger, level);
    }

    @Override
    @NotNull
    public AnyResolver<StateType, ?> eraseToAnyResolver() {
        return StateMachineResolver.DefaultImpls.eraseToAnyResolver(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/amplifyframework/statemachine/LoggingStateMachineResolver$Companion;", "", "()V", "makeDefaultLogger", "Ljava/util/logging/Logger;", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger makeDefaultLogger() {
            Logger logger = Logger.getLogger(this.toString());
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
            Intrinsics.checkNotNull((Object)logger);
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

