/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.statemachine;

import com.amplifyframework.statemachine.Action;
import com.amplifyframework.statemachine.AnyResolver;
import com.amplifyframework.statemachine.ConcurrentEffectExecutor;
import com.amplifyframework.statemachine.EffectExecutor;
import com.amplifyframework.statemachine.Environment;
import com.amplifyframework.statemachine.EventDispatcher;
import com.amplifyframework.statemachine.State;
import com.amplifyframework.statemachine.StateChangeListenerToken;
import com.amplifyframework.statemachine.StateMachineEvent;
import com.amplifyframework.statemachine.StateMachineResolver;
import com.amplifyframework.statemachine.StateResolution;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005B?\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ:\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\"\u0018\u00010'j\u0004\u0018\u0001`(H\u0002J\u000e\u0010)\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001bJ\u0016\u0010*\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\u001a\u0010.\u001a\u00020\"2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!J8\u00100\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\"\u0018\u00010'j\u0004\u0018\u0001`(J5\u00101\u001a\u0002022\u001e\u00103\u001a\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!042\u0006\u00105\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010;\u001a\u00020\"2\u0006\u00108\u001a\u000209H\u0016R\u0010\u0010\u000f\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/amplifyframework/statemachine/StateMachine;", "StateType", "Lcom/amplifyframework/statemachine/State;", "EnvironmentType", "Lcom/amplifyframework/statemachine/Environment;", "Lcom/amplifyframework/statemachine/EventDispatcher;", "resolver", "Lcom/amplifyframework/statemachine/StateMachineResolver;", "environment", "executor", "Lcom/amplifyframework/statemachine/EffectExecutor;", "concurrentQueue", "Lkotlinx/coroutines/CoroutineDispatcher;", "initialState", "(Lcom/amplifyframework/statemachine/StateMachineResolver;Lcom/amplifyframework/statemachine/Environment;Lcom/amplifyframework/statemachine/EffectExecutor;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/amplifyframework/statemachine/State;)V", "currentState", "Lcom/amplifyframework/statemachine/State;", "dispatcherQueue", "getEnvironment", "()Lcom/amplifyframework/statemachine/Environment;", "Lcom/amplifyframework/statemachine/Environment;", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "operationQueue", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "pendingCancellations", "", "Lcom/amplifyframework/statemachine/StateChangeListenerToken;", "Lcom/amplifyframework/statemachine/AnyResolver;", "stateMachineScope", "Lkotlin/coroutines/CoroutineContext;", "subscribers", "", "Lkotlin/Function1;", "", "addSubscription", "token", "listener", "onSubscribe", "Lkotlin/Function0;", "Lcom/amplifyframework/statemachine/OnSubscribedCallback;", "cancel", "execute", "actions", "", "Lcom/amplifyframework/statemachine/Action;", "getCurrentState", "completion", "listen", "notifySubscribers", "", "subscriber", "", "newState", "(Ljava/util/Map$Entry;Lcom/amplifyframework/statemachine/State;)Z", "process", "event", "Lcom/amplifyframework/statemachine/StateMachineEvent;", "removeSubscription", "send", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachine.kt\ncom/amplifyframework/statemachine/StateMachine\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,204:1\n44#2,4:205\n526#3:209\n511#3,6:210\n215#4,2:216\n*S KotlinDebug\n*F\n+ 1 StateMachine.kt\ncom/amplifyframework/statemachine/StateMachine\n*L\n66#1:205,4\n191#1:209\n191#1:210,6\n192#1:216,2\n*E\n"})
public class StateMachine<StateType extends State, EnvironmentType extends Environment>
implements EventDispatcher {
    @NotNull
    private final EnvironmentType environment;
    @NotNull
    private final AnyResolver<StateType, ?> resolver;
    @NotNull
    private final EffectExecutor executor;
    @NotNull
    private StateType currentState;
    @NotNull
    private final CoroutineDispatcher dispatcherQueue;
    @NotNull
    private final ExecutorCoroutineDispatcher operationQueue;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;
    @NotNull
    private final CoroutineContext stateMachineScope;
    @NotNull
    private final Map<StateChangeListenerToken, Function1<StateType, Unit>> subscribers;
    @NotNull
    private final Set<StateChangeListenerToken> pendingCancellations;

    public StateMachine(@NotNull StateMachineResolver<StateType> resolver, @NotNull EnvironmentType environment, @Nullable EffectExecutor executor, @Nullable CoroutineDispatcher concurrentQueue, @Nullable StateType initialState) {
        CoroutineDispatcher resolvedQueue;
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        this.environment = environment;
        this.resolver = resolver.eraseToAnyResolver();
        StateType StateType = initialState;
        if (StateType == null) {
            StateType = resolver.getDefaultState();
        }
        this.currentState = StateType;
        this.operationQueue = ThreadPoolDispatcherKt.newFixedThreadPoolContext((int)1, (String)"Single threaded dispatcher");
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.exceptionHandler = new CoroutineExceptionHandler(key){

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                System.out.println((Object)("CoroutineExceptionHandler got " + exception2));
            }
        };
        this.stateMachineScope = JobKt.Job$default(null, (int)1, null).plus((CoroutineContext)this.operationQueue);
        CoroutineDispatcher coroutineDispatcher = concurrentQueue;
        if (coroutineDispatcher == null) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        this.dispatcherQueue = resolvedQueue = coroutineDispatcher;
        EffectExecutor effectExecutor = executor;
        if (effectExecutor == null) {
            effectExecutor = new ConcurrentEffectExecutor(resolvedQueue);
        }
        this.executor = effectExecutor;
        this.subscribers = new LinkedHashMap();
        this.pendingCancellations = new LinkedHashSet();
    }

    public /* synthetic */ StateMachine(StateMachineResolver stateMachineResolver, Environment environment, EffectExecutor effectExecutor, CoroutineDispatcher coroutineDispatcher, State state, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            effectExecutor = null;
        }
        if ((n & 8) != 0) {
            coroutineDispatcher = null;
        }
        if ((n & 0x10) != 0) {
            state = null;
        }
        this(stateMachineResolver, environment, effectExecutor, coroutineDispatcher, state);
    }

    @NotNull
    public final EnvironmentType getEnvironment() {
        return this.environment;
    }

    public final void listen(@NotNull StateChangeListenerToken token, @NotNull Function1<? super StateType, Unit> listener, @Nullable Function0<Unit> onSubscribe) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)this.stateMachineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, token, listener, onSubscribe, null){
            int label;
            final /* synthetic */ StateMachine<StateType, EnvironmentType> this$0;
            final /* synthetic */ StateChangeListenerToken $token;
            final /* synthetic */ Function1<StateType, Unit> $listener;
            final /* synthetic */ Function0<Unit> $onSubscribe;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                this.$listener = $listener;
                this.$onSubscribe = $onSubscribe;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StateMachine.access$addSubscription(this.this$0, this.$token, this.$listener, this.$onSubscribe);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void cancel(@NotNull StateChangeListenerToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.pendingCancellations.add(token);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)this.stateMachineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, token, null){
            int label;
            final /* synthetic */ StateMachine<StateType, EnvironmentType> this$0;
            final /* synthetic */ StateChangeListenerToken $token;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StateMachine.access$removeSubscription(this.this$0, this.$token);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void getCurrentState(@NotNull Function1<? super StateType, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)this.stateMachineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(completion, this, null){
            int label;
            final /* synthetic */ Function1<StateType, Unit> $completion;
            final /* synthetic */ StateMachine<StateType, EnvironmentType> this$0;
            {
                this.$completion = $completion;
                this.this$0 = $receiver;
                super(2, $completion2);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$completion.invoke((Object)StateMachine.access$getCurrentState$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void addSubscription(StateChangeListenerToken token, Function1<? super StateType, Unit> listener, Function0<Unit> onSubscribe) {
        if (this.pendingCancellations.contains(token)) {
            return;
        }
        StateType currentState = this.currentState;
        this.subscribers.put(token, listener);
        Function0<Unit> function0 = onSubscribe;
        if (function0 != null) {
            function0.invoke();
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)this.dispatcherQueue), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener, currentState, null){
            int label;
            final /* synthetic */ Function1<StateType, Unit> $listener;
            final /* synthetic */ StateType $currentState;
            {
                this.$listener = $listener;
                this.$currentState = $currentState;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$listener.invoke(this.$currentState);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void removeSubscription(StateChangeListenerToken token) {
        this.pendingCancellations.remove(token);
        this.subscribers.remove(token);
    }

    @Override
    public void send(@NotNull StateMachineEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)this.stateMachineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ StateMachine<StateType, EnvironmentType> this$0;
            final /* synthetic */ StateMachineEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        StateMachine.access$process(this.this$0, this.$event);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean notifySubscribers(Map.Entry<StateChangeListenerToken, ? extends Function1<? super StateType, Unit>> subscriber, StateType newState) {
        StateChangeListenerToken token = subscriber.getKey();
        if (this.pendingCancellations.contains(token)) {
            return false;
        }
        subscriber.getValue().invoke(newState);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void process(StateMachineEvent event) {
        StateResolution<StateType> resolution = this.resolver.resolve(this.currentState, event);
        if (!Intrinsics.areEqual(this.currentState, resolution.getNewState())) {
            Map subscribersToRemove;
            void $this$filterTo$iv$iv;
            this.currentState = resolution.getNewState();
            Map<StateChangeListenerToken, Function1<StateType, Unit>> $this$filter$iv = this.subscribers;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!(!this.notifySubscribers(it, resolution.getNewState()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = subscribersToRemove = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                this.subscribers.remove(it.getKey());
            }
        }
        this.execute(resolution.getActions());
    }

    private final void execute(List<? extends Action> actions) {
        this.executor.execute(actions, this, (Environment)this.environment);
    }

    public static final /* synthetic */ void access$addSubscription(StateMachine $this, StateChangeListenerToken token, Function1 listener, Function0 onSubscribe) {
        $this.addSubscription(token, listener, (Function0<Unit>)onSubscribe);
    }

    public static final /* synthetic */ void access$removeSubscription(StateMachine $this, StateChangeListenerToken token) {
        $this.removeSubscription(token);
    }

    public static final /* synthetic */ State access$getCurrentState$p(StateMachine $this) {
        return $this.currentState;
    }

    public static final /* synthetic */ void access$process(StateMachine $this, StateMachineEvent event) {
        $this.process(event);
    }
}

