/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager {
    private static String KEY_INGESTION_ENDPOINT = "ingestionEndpoint";
    private static ConfigManager instance = null;
    private String ingestionEndpoint = "https://api2.amplitude.com/";

    public String getIngestionEndpoint() {
        return this.ingestionEndpoint;
    }

    private ConfigManager() {
    }

    public void refresh(RefreshListener listener) {
        try {
            URL obj = new URL("https://regionconfig.amplitude.com/");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONObject json = new JSONObject(response.toString());
                if (json.has(KEY_INGESTION_ENDPOINT)) {
                    this.ingestionEndpoint = "https://" + json.getString(KEY_INGESTION_ENDPOINT);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (JSONException jSONException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        listener.onFinished();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    static interface RefreshListener {
        public void onFinished();
    }
}

