/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude.eventexplorer;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.amplitude.R;
import com.amplitude.api.Amplitude;

public class EventExplorerInfoActivity
extends Activity {
    private ImageView closeImageView;
    private Button deviceIdCopyButton;
    private Button userIdCopyButton;
    private TextView deviceIdTextView;
    private TextView userIdTextView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.amp_activity_eventexplorer_info);
        this.closeImageView = (ImageView)this.findViewById(R.id.amp_eeInfo_iv_close);
        this.closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EventExplorerInfoActivity.this.onBackPressed();
            }
        });
        this.deviceIdTextView = (TextView)this.findViewById(R.id.amp_eeInfo_tv_deviceId);
        this.userIdTextView = (TextView)this.findViewById(R.id.amp_eeInfo_tv_userId);
        Intent intent = this.getIntent();
        String instanceName = intent.getExtras().getString("instanceName");
        final String deviceId = Amplitude.getInstance(instanceName).getDeviceId();
        final String userId = Amplitude.getInstance(instanceName).getUserId();
        this.deviceIdTextView.setText((CharSequence)(deviceId != null ? deviceId : this.getString(R.string.amp_label_not_avail)));
        this.userIdTextView.setText((CharSequence)(userId != null ? userId : this.getString(R.string.amp_label_not_avail)));
        this.deviceIdCopyButton = (Button)this.findViewById(R.id.amp_eeInfo_btn_copyDeviceId);
        this.deviceIdCopyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EventExplorerInfoActivity.this.copyText(view.getContext(), deviceId);
            }
        });
        this.userIdCopyButton = (Button)this.findViewById(R.id.amp_eeInfo_btn_copyUserId);
        this.userIdCopyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EventExplorerInfoActivity.this.copyText(view.getContext(), userId);
            }
        });
    }

    private void copyText(Context context, String text) {
        if (text != null) {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"copied text", (CharSequence)text);
            clipboard.setPrimaryClip(clip);
            Toast toast = Toast.makeText((Context)context, (CharSequence)this.getString(R.string.amp_label_copied), (int)0);
            toast.show();
        }
    }
}

