/*
 * Decompiled with CFR 0.152.
 */
package com.amplitude;

import com.amplitude.AmplitudeCallbacks;
import com.amplitude.Plan;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    public String eventType;
    public String userId;
    public String deviceId;
    public long timestamp = System.currentTimeMillis();
    public double locationLat;
    public double locationLng;
    public String appVersion;
    public String versionName;
    public String platform;
    public String osName;
    public String deviceBrand;
    public String deviceManufacturer;
    public String deviceModel;
    public String carrier;
    public String country;
    public String region;
    public String city;
    public String dma;
    public String idfa;
    public String idfv;
    public String adid;
    public String androidId;
    public String language;
    public String ip;
    public JSONObject eventProperties;
    public JSONObject userProperties;
    public Double price;
    public int quantity;
    public Double revenue;
    public String productId;
    public String revenueType;
    public int eventId;
    public long sessionId = -1L;
    public String insertId = UUID.randomUUID().toString();
    public JSONObject groups;
    public JSONObject groupProperties;
    public Plan plan;
    protected AmplitudeCallbacks callback;

    public Event(String eventType, String userId) {
        this(eventType, userId, null);
    }

    public Event(String eventType, String userId, String deviceId) {
        this.eventType = eventType;
        if (userId == null && deviceId == null) {
            throw new IllegalArgumentException("Event must have one defined userId and/or deviceId");
        }
        this.userId = userId;
        this.deviceId = deviceId;
    }

    public JSONObject toJsonObject() {
        JSONObject event = new JSONObject();
        try {
            boolean shouldLogRevenueProps;
            event.put("event_type", (Object)this.eventType);
            event.put("user_id", this.replaceWithJSONNull(this.userId));
            event.put("device_id", this.replaceWithJSONNull(this.deviceId));
            event.put("time", this.timestamp);
            event.put("location_lat", this.locationLat);
            event.put("location_lng", this.locationLng);
            event.put("app_version", (Object)this.appVersion);
            event.put("version_name", this.replaceWithJSONNull(this.versionName));
            event.put("library", (Object)"amplitude-java/1.8.0");
            event.put("platform", this.replaceWithJSONNull(this.platform));
            event.put("os_name", this.replaceWithJSONNull(this.osName));
            event.put("device_brand", this.replaceWithJSONNull(this.deviceBrand));
            event.put("device_manufacturer", this.replaceWithJSONNull(this.deviceManufacturer));
            event.put("device_model", this.replaceWithJSONNull(this.deviceModel));
            event.put("carrier", this.replaceWithJSONNull(this.carrier));
            event.put("country", this.replaceWithJSONNull(this.country));
            event.put("region", this.replaceWithJSONNull(this.region));
            event.put("city", this.replaceWithJSONNull(this.city));
            event.put("dma", this.replaceWithJSONNull(this.dma));
            event.put("idfa", this.replaceWithJSONNull(this.idfa));
            event.put("idfv", this.replaceWithJSONNull(this.idfv));
            event.put("adid", this.replaceWithJSONNull(this.adid));
            event.put("android_id", this.replaceWithJSONNull(this.androidId));
            event.put("language", this.replaceWithJSONNull(this.language));
            event.put("ip", this.replaceWithJSONNull(this.ip));
            event.put("event_properties", (Object)(this.eventProperties == null ? new JSONObject() : this.truncate(this.eventProperties)));
            event.put("user_properties", (Object)(this.userProperties == null ? new JSONObject() : this.truncate(this.userProperties)));
            boolean bl = shouldLogRevenueProps = this.revenue != null || this.price != null;
            if (shouldLogRevenueProps) {
                int eventQuantity = this.quantity > 0 ? this.quantity : 1;
                event.put("price", (Object)this.price);
                event.put("quantity", eventQuantity);
                event.put("revenue", (Object)this.revenue);
                event.put("productId", (Object)this.productId);
                event.put("revenueType", (Object)this.revenueType);
            }
            event.put("event_id", this.replaceWithJSONNull(this.eventId));
            event.put("session_id", this.sessionId);
            event.put("insert_id", (Object)this.insertId);
            event.put("groups", (Object)(this.groups == null ? new JSONObject() : this.truncate(this.groups)));
            event.put("group_properties", (Object)(this.groupProperties == null ? new JSONObject() : this.truncate(this.groupProperties)));
            if (this.plan != null) {
                event.put("plan", (Object)this.plan.toJSONObject());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return event;
    }

    protected Object replaceWithJSONNull(Object obj) {
        return obj == null ? JSONObject.NULL : obj;
    }

    protected JSONObject truncate(JSONObject object) {
        if (object == null) {
            return new JSONObject();
        }
        if (object.length() > 1024) {
            throw new IllegalArgumentException("Too many properties (more than 1024) in JSON");
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = object.get(key);
                if (value.getClass().equals(String.class)) {
                    object.put(key, (Object)this.truncate((String)value));
                    continue;
                }
                if (value.getClass().equals(JSONObject.class)) {
                    object.put(key, (Object)this.truncate((JSONObject)value));
                    continue;
                }
                if (!value.getClass().equals(JSONArray.class)) continue;
                object.put(key, (Object)this.truncate((JSONArray)value));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("JSON parsing error. Too long (>1000 chars) or invalid JSON");
            }
        }
        return object;
    }

    protected JSONArray truncate(JSONArray array) throws JSONException {
        if (array == null) {
            return new JSONArray();
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value.getClass().equals(String.class)) {
                array.put(i, (Object)this.truncate((String)value));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                array.put(i, (Object)this.truncate((JSONObject)value));
                continue;
            }
            if (!value.getClass().equals(JSONArray.class)) continue;
            array.put(i, (Object)this.truncate((JSONArray)value));
        }
        return array;
    }

    protected String truncate(String value) {
        return value.length() <= 1000 ? value : value.substring(0, 1000);
    }
}

