/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.verify.batch.guided;

import com.anaplan.engineering.azuki.core.parser.ScenarioParser;
import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.verify.batch.api.CompletedScenario;
import com.anaplan.engineering.azuki.verify.batch.api.OrchestratableScenarioBatch;
import com.anaplan.engineering.azuki.verify.batch.api.ScenarioResultContext;
import com.anaplan.engineering.azuki.verify.batch.api.ScenarioStatus;
import com.anaplan.engineering.azuki.verify.batch.guided.DurationBasedBatchState;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedBatchState;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedScenario;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedScenarioBatch;
import com.anaplan.engineering.azuki.verify.batch.guided.ProgressReportGenerator;
import com.anaplan.engineering.azuki.verify.batch.guided.RepsBasedBatchState;
import com.anaplan.engineering.azuki.verify.batch.guided.RunConfiguration;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J$\u0010\u001f\u001a\u00020\u001d2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0006H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenarioBatch;", "S", "Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;", "RC", "Lcom/anaplan/engineering/azuki/verify/batch/api/ScenarioResultContext;", "Lcom/anaplan/engineering/azuki/verify/batch/api/OrchestratableScenarioBatch;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenario;", "()V", "batchState", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "progressReportGenerator", "Lcom/anaplan/engineering/azuki/verify/batch/guided/ProgressReportGenerator;", "runConfiguration", "Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "getRunConfiguration$azuki_batch_guided", "()Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "runConfiguration$delegate", "Lkotlin/Lazy;", "scenarioParser", "Lcom/anaplan/engineering/azuki/core/parser/ScenarioParser;", "getScenarioParser", "()Lcom/anaplan/engineering/azuki/core/parser/ScenarioParser;", "scenarioParser$delegate", "arbitraryUid", "", "beforeBatch", "", "checkAllBaseScenariosCanBeParsed", "complete", "completed", "Lcom/anaplan/engineering/azuki/verify/batch/api/CompletedScenario;", "runDir", "Ljava/io/File;", "createProgressReport", "fileName", "generateFromBase", "scenarioFile", "getScenarioStatus", "Lcom/anaplan/engineering/azuki/verify/batch/api/ScenarioStatus;", "scenario", "nextScenario", "", "pcComplete", "", "azuki-batch-guided"})
@SourceDebugExtension(value={"SMAP\nGuidedScenarioBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuidedScenarioBatch.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenarioBatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n1855#2,2:96\n*S KotlinDebug\n*F\n+ 1 GuidedScenarioBatch.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenarioBatch\n*L\n44#1:92\n44#1:93,3\n52#1:96,2\n*E\n"})
public final class GuidedScenarioBatch<S extends BuildableScenario<?>, RC extends ScenarioResultContext>
implements OrchestratableScenarioBatch<GuidedScenario, RC> {
    @NotNull
    private final Lazy scenarioParser$delegate = LazyKt.lazy((Function0)scenarioParser.2.INSTANCE);
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @NotNull
    private final Lazy runConfiguration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RunConfiguration>(this){
        final /* synthetic */ GuidedScenarioBatch<S, RC> this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final RunConfiguration invoke() {
            File configurationFile = new File(System.getProperty("com.anaplan.engineering.azuki.verify.config"));
            ObjectMapper objectMapper = GuidedScenarioBatch.access$getObjectMapper$p(this.this$0);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"access$getObjectMapper$p(...)");
            ObjectMapper $this$readValue$iv = objectMapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            return (RunConfiguration)$this$readValue$iv.readValue(configurationFile, (TypeReference)new TypeReference<RunConfiguration>(){});
        }
    }));
    @NotNull
    private final GuidedBatchState<RC> batchState = this.getRunConfiguration$azuki_batch_guided().getDuration() == null ? (GuidedBatchState)new RepsBasedBatchState(this.getRunConfiguration$azuki_batch_guided()) : (GuidedBatchState)new DurationBasedBatchState(this.getRunConfiguration$azuki_batch_guided());
    @NotNull
    private final ProgressReportGenerator<RC> progressReportGenerator = new ProgressReportGenerator<RC>(this.batchState);

    private final ScenarioParser<S> getScenarioParser() {
        Lazy lazy = this.scenarioParser$delegate;
        return (ScenarioParser)lazy.getValue();
    }

    @NotNull
    public final RunConfiguration getRunConfiguration$azuki_batch_guided() {
        Lazy lazy = this.runConfiguration$delegate;
        return (RunConfiguration)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<GuidedScenario> nextScenario() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.batchState.nextBaseScenarios();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.generateFromBase((File)it));
        }
        return (List)destination$iv$iv;
    }

    public void beforeBatch() {
        this.checkAllBaseScenariosCanBeParsed();
    }

    private final void checkAllBaseScenariosCanBeParsed() {
        Iterable $this$forEach$iv = this.batchState.getBaseScenarios();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            try {
                this.getScenarioParser().parse(FilesKt.readText$default((File)it, null, (int)1, null), "");
            }
            catch (ScriptException e) {
                throw new IllegalStateException("Scenario in file " + it.getAbsolutePath() + " is invalid", e);
            }
        }
    }

    private final GuidedScenario generateFromBase(File scenarioFile) {
        return new GuidedScenario(FilesKt.getNameWithoutExtension((File)scenarioFile) + "_" + this.arbitraryUid(), FilesKt.readText$default((File)scenarioFile, null, (int)1, null), scenarioFile);
    }

    private final String arbitraryUid() {
        long timePart = System.currentTimeMillis() / (long)1000 % (long)100000;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uuidPart = StringsKt.take((String)string, (int)6);
        String string2 = "%05d_%s";
        Object[] objectArray = new Object[]{timePart, uuidPart};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return string3;
    }

    public void complete(@NotNull CompletedScenario<GuidedScenario, RC> completed, @NotNull File runDir) {
        Intrinsics.checkNotNullParameter(completed, (String)"completed");
        Intrinsics.checkNotNullParameter((Object)runDir, (String)"runDir");
        this.batchState.complete(completed);
    }

    @NotNull
    public File createProgressReport(@NotNull File runDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)runDir, (String)"runDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.progressReportGenerator.generate(runDir, fileName);
    }

    public int pcComplete() {
        return this.batchState.pcComplete();
    }

    @NotNull
    public ScenarioStatus getScenarioStatus(@NotNull GuidedScenario scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        return ScenarioStatus.Ready;
    }

    public void afterBatch() {
        OrchestratableScenarioBatch.DefaultImpls.afterBatch((OrchestratableScenarioBatch)this);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(GuidedScenarioBatch $this) {
        return $this.objectMapper;
    }
}

