/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.verify.batch.guided;

import com.anaplan.engineering.azuki.runner.ExitCode;
import com.anaplan.engineering.azuki.verify.batch.api.CompletedScenario;
import com.anaplan.engineering.azuki.verify.batch.api.ScenarioResultContext;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedBatchState;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedScenario;
import com.anaplan.engineering.azuki.verify.batch.guided.RunConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/anaplan/engineering/azuki/verify/batch/guided/RepsBasedBatchState;", "RC", "Lcom/anaplan/engineering/azuki/verify/batch/api/ScenarioResultContext;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState;", "runConfiguration", "Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "(Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;)V", "baseScenarioToVerifiedCount", "", "Ljava/io/File;", "", "baseScenarios", "", "getBaseScenarios", "()Ljava/util/Set;", "complete", "", "completedScenario", "Lcom/anaplan/engineering/azuki/verify/batch/api/CompletedScenario;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenario;", "nextBaseScenarios", "", "pcComplete", "azuki-batch-guided"})
@SourceDebugExtension(value={"SMAP\nRepsBasedBatchState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepsBasedBatchState.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/RepsBasedBatchState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,43:1\n1271#2,2:44\n1285#2,4:46\n526#3:50\n511#3,6:51\n*S KotlinDebug\n*F\n+ 1 RepsBasedBatchState.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/RepsBasedBatchState\n*L\n12#1:44,2\n12#1:46,4\n17#1:50\n17#1:51,6\n*E\n"})
public final class RepsBasedBatchState<RC extends ScenarioResultContext>
extends GuidedBatchState<RC> {
    @NotNull
    private Map<File, Integer> baseScenarioToVerifiedCount;
    @NotNull
    private final Set<File> baseScenarios;

    /*
     * WARNING - void declaration
     */
    public RepsBasedBatchState(@NotNull RunConfiguration runConfiguration2) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)runConfiguration2, (String)"runConfiguration");
        super(runConfiguration2);
        Iterable iterable = runConfiguration2.getScenarios().getFiles();
        RepsBasedBatchState repsBasedBatchState = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            File file = (File)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = 0;
            map.put(t, n);
        }
        repsBasedBatchState.baseScenarioToVerifiedCount = result$iv;
        this.baseScenarios = this.baseScenarioToVerifiedCount.keySet();
    }

    @NotNull
    public Set<File> getBaseScenarios() {
        return this.baseScenarios;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> nextBaseScenarios() {
        void $this$filterTo$iv$iv;
        Map<File, Integer> $this$filter$iv = this.baseScenarioToVerifiedCount;
        boolean $i$f$filter = false;
        Map<File, Integer> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            int count = ((Number)entry.getValue()).intValue();
            if (!(count <= this.getRunConfiguration().getReps())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set tbd = SetsKt.minus(destination$iv$iv.keySet(), (Iterable)this.getAbandonedBaseScenarios());
        return tbd.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.toList((Iterable)tbd);
    }

    @Override
    public void complete(@NotNull CompletedScenario<GuidedScenario, RC> completedScenario) {
        Intrinsics.checkNotNullParameter(completedScenario, (String)"completedScenario");
        File baseFile = ((GuidedScenario)completedScenario.getOrchestratableScenario()).getBaseFile();
        this.setCompleted(CollectionsKt.plus((Collection)this.getCompleted(), completedScenario));
        if (this.hasError(completedScenario)) {
            this.abandonIfThresholdMet(baseFile);
        } else if (completedScenario.getExitCode() == ExitCode.Ok) {
            Integer n = this.baseScenarioToVerifiedCount.get(baseFile);
            Intrinsics.checkNotNull((Object)n);
            this.baseScenarioToVerifiedCount = MapsKt.plus(this.baseScenarioToVerifiedCount, (Pair)TuplesKt.to((Object)baseFile, (Object)(((Number)n).intValue() + 1)));
        }
    }

    @Override
    public int pcComplete() {
        Map runningBaseScenariosToVerifiedCounts = MapsKt.minus(this.baseScenarioToVerifiedCount, (Iterable)this.getAbandonedBaseScenarios());
        int required = runningBaseScenariosToVerifiedCounts.keySet().size() * this.getRunConfiguration().getReps();
        int completed = CollectionsKt.sumOfInt((Iterable)runningBaseScenariosToVerifiedCounts.values());
        return required == 0 ? 100 : completed * 100 / required;
    }
}

