/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.verify.batch.guided;

import com.anaplan.engineering.azuki.verify.batch.api.CompletedScenario;
import com.anaplan.engineering.azuki.verify.batch.api.ScenarioResultContext;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedBatchState;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedScenario;
import com.anaplan.engineering.azuki.verify.batch.guided.RunConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/anaplan/engineering/azuki/verify/batch/guided/DurationBasedBatchState;", "RC", "Lcom/anaplan/engineering/azuki/verify/batch/api/ScenarioResultContext;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState;", "runConfiguration", "Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "<init>", "(Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;)V", "start", "", "durationMillis", "", "baseScenarios", "", "Ljava/io/File;", "getBaseScenarios", "()Ljava/util/List;", "nextBaseScenarios", "complete", "", "completedScenario", "Lcom/anaplan/engineering/azuki/verify/batch/api/CompletedScenario;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenario;", "pcComplete", "azuki-batch-guided"})
public final class DurationBasedBatchState<RC extends ScenarioResultContext>
extends GuidedBatchState<RC> {
    private final long start;
    private final int durationMillis;
    @NotNull
    private final List<File> baseScenarios;

    public DurationBasedBatchState(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        super(runConfiguration);
        this.start = System.currentTimeMillis();
        Integer n = runConfiguration.getDuration();
        Intrinsics.checkNotNull((Object)n);
        this.durationMillis = n * 1000 * 60;
        this.baseScenarios = runConfiguration.getScenarios().getFiles();
    }

    @NotNull
    public List<File> getBaseScenarios() {
        return this.baseScenarios;
    }

    @Override
    @NotNull
    public List<File> nextBaseScenarios() {
        return this.getBaseScenarios();
    }

    @Override
    public void complete(@NotNull CompletedScenario<GuidedScenario, RC> completedScenario) {
        Intrinsics.checkNotNullParameter(completedScenario, (String)"completedScenario");
        this.setCompleted(CollectionsKt.plus((Collection)this.getCompleted(), completedScenario));
        if (this.hasError(completedScenario)) {
            this.abandonIfThresholdMet(((GuidedScenario)completedScenario.getOrchestratableScenario()).getBaseFile());
        }
    }

    @Override
    public int pcComplete() {
        int n;
        if (Intrinsics.areEqual((Object)this.getBaseScenarios(), this.getAbandonedBaseScenarios())) {
            n = 100;
        } else {
            long timePassed = System.currentTimeMillis() - this.start;
            n = (int)(timePassed * (long)100 / (long)this.durationMillis);
        }
        return n;
    }
}

