/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.verify.batch.guided;

import com.anaplan.engineering.azuki.runner.ExitCode;
import com.anaplan.engineering.azuki.verify.batch.api.CompletedScenario;
import com.anaplan.engineering.azuki.verify.batch.api.ScenarioResultContext;
import com.anaplan.engineering.azuki.verify.batch.guided.AbandonConfiguration;
import com.anaplan.engineering.azuki.verify.batch.guided.GuidedScenario;
import com.anaplan.engineering.azuki.verify.batch.guided.RunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H&J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0014H&J\b\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\fH\u0004J\u0018\u0010%\u001a\u00020&*\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0014H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eRH\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u00140\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u00140\u0010@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState;", "RC", "Lcom/anaplan/engineering/azuki/verify/batch/api/ScenarioResultContext;", "", "runConfiguration", "Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "<init>", "(Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;)V", "getRunConfiguration", "()Lcom/anaplan/engineering/azuki/verify/batch/guided/RunConfiguration;", "baseScenarios", "", "Ljava/io/File;", "getBaseScenarios", "()Ljava/util/Collection;", "nextBaseScenarios", "", "complete", "", "completedScenario", "Lcom/anaplan/engineering/azuki/verify/batch/api/CompletedScenario;", "Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedScenario;", "pcComplete", "", "value", "completed", "getCompleted", "()Ljava/util/List;", "setCompleted", "(Ljava/util/List;)V", "abandonedBaseScenarios", "getAbandonedBaseScenarios", "setAbandonedBaseScenarios", "abandonConfiguration", "Lcom/anaplan/engineering/azuki/verify/batch/guided/AbandonConfiguration;", "abandonIfThresholdMet", "baseFile", "hasError", "", "Companion", "azuki-batch-guided"})
@SourceDebugExtension(value={"SMAP\nGuidedBatchState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuidedBatchState.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n774#2:41\n865#2,2:42\n1782#2,4:44\n*S KotlinDebug\n*F\n+ 1 GuidedBatchState.kt\ncom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState\n*L\n23#1:41\n23#1:42,2\n25#1:44,4\n*E\n"})
public abstract class GuidedBatchState<RC extends ScenarioResultContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RunConfiguration runConfiguration;
    @NotNull
    private List<CompletedScenario<GuidedScenario, RC>> completed;
    @NotNull
    private List<? extends File> abandonedBaseScenarios;
    @NotNull
    private final AbandonConfiguration abandonConfiguration;
    private static final Logger Log = LoggerFactory.getLogger(GuidedBatchState.class);

    public GuidedBatchState(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        this.runConfiguration = runConfiguration;
        this.completed = CollectionsKt.emptyList();
        this.abandonedBaseScenarios = CollectionsKt.emptyList();
        this.abandonConfiguration = this.runConfiguration.getScenarios().getAbandon();
    }

    @NotNull
    protected final RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    @NotNull
    public abstract Collection<File> getBaseScenarios();

    @NotNull
    public abstract List<File> nextBaseScenarios();

    public abstract void complete(@NotNull CompletedScenario<GuidedScenario, RC> var1);

    public abstract int pcComplete();

    @NotNull
    public final List<CompletedScenario<GuidedScenario, RC>> getCompleted() {
        return this.completed;
    }

    protected final void setCompleted(@NotNull List<CompletedScenario<GuidedScenario, RC>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.completed = list;
    }

    @NotNull
    protected final List<File> getAbandonedBaseScenarios() {
        return this.abandonedBaseScenarios;
    }

    protected final void setAbandonedBaseScenarios(@NotNull List<? extends File> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.abandonedBaseScenarios = list;
    }

    /*
     * WARNING - void declaration
     */
    protected final void abandonIfThresholdMet(@NotNull File baseFile) {
        int n;
        CompletedScenario it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Iterable $this$filter$iv = this.completed;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CompletedScenario)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((GuidedScenario)it.getOrchestratableScenario()).getBaseFile(), (Object)baseFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List completedForBase = (List)destination$iv$iv;
        int runCount = ((Collection)completedForBase).size();
        Iterable $this$count$iv = completedForBase;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (CompletedScenario)element$iv;
                boolean bl = false;
                if (!this.hasError(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int errorCount = n;
        int errorPc = 100 * errorCount / runCount;
        Log.debug("Scenario had error check if abandon threshold met: baseFile=" + baseFile + " runCount=" + runCount + " errorPc=" + errorPc);
        if (runCount >= this.abandonConfiguration.getMinAttempts() && errorPc >= this.abandonConfiguration.getPcErrors()) {
            Log.warn("Abandoning base scenario after error threshold met: baseFile=" + baseFile + " runCount=" + runCount + " errorPc=" + errorPc);
            this.abandonedBaseScenarios = CollectionsKt.plus((Collection)this.abandonedBaseScenarios, (Object)baseFile);
        }
    }

    protected final boolean hasError(@NotNull CompletedScenario<GuidedScenario, RC> $this$hasError) {
        Intrinsics.checkNotNullParameter($this$hasError, (String)"<this>");
        return $this$hasError.getExitCode().getCategory() == ExitCode.Category.Error;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/anaplan/engineering/azuki/verify/batch/guided/GuidedBatchState$Companion;", "", "<init>", "()V", "Log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "azuki-batch-guided"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

