/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.runner;

import com.anaplan.engineering.azuki.core.parser.SimpleScenarioParser;
import com.anaplan.engineering.azuki.core.runner.ImplementationInstance;
import com.anaplan.engineering.azuki.core.runner.MultiOracleScenarioRunner;
import com.anaplan.engineering.azuki.core.runner.VerifiableScenarioRunner;
import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.core.scenario.OracleScenario;
import com.anaplan.engineering.azuki.core.scenario.VerifiableScenario;
import com.anaplan.engineering.azuki.core.system.ActionFactory;
import com.anaplan.engineering.azuki.core.system.ActionGeneratorFactory;
import com.anaplan.engineering.azuki.core.system.CheckFactory;
import com.anaplan.engineering.azuki.core.system.QueryFactory;
import com.anaplan.engineering.azuki.runner.ExitCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u00020\t:\u0004\u001e\u001f !BE\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012 \b\u0002\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J(\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\"\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0013H\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000bJ\u001c\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001dH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "", "testImplementationInstance", "", "oracleImplementationInstances", "", "scenarioImports", "resultProcessor", "Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$ResultProcessor;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$ResultProcessor;)V", "getImplementationInstance", "Lcom/anaplan/engineering/azuki/core/runner/ImplementationInstance;", "instanceName", "getPersistenceVerificationInstance", "runOracleScenario", "", "scenario", "Lcom/anaplan/engineering/azuki/core/scenario/OracleScenario;", "runScenario", "scenarioScript", "runVerifiableScenario", "Lcom/anaplan/engineering/azuki/core/scenario/VerifiableScenario;", "Companion", "InvalidScenarioException", "ResultProcessor", "UnsupportedScenarioTypeException", "azuki-runner"})
@SourceDebugExtension(value={"SMAP\nScenarioScriptRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScenarioScriptRunner.kt\ncom/anaplan/engineering/azuki/runner/ScenarioScriptRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1549#2:200\n1620#2,3:201\n1#3:204\n*S KotlinDebug\n*F\n+ 1 ScenarioScriptRunner.kt\ncom/anaplan/engineering/azuki/runner/ScenarioScriptRunner\n*L\n109#1:200\n109#1:201,3\n*E\n"})
public final class ScenarioScriptRunner<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String testImplementationInstance;
    @NotNull
    private final List<String> oracleImplementationInstances;
    @NotNull
    private final String scenarioImports;
    @NotNull
    private final ResultProcessor<AF, CF, QF, AGF> resultProcessor;
    @NotNull
    private static final Logger Log;

    public ScenarioScriptRunner(@NotNull String testImplementationInstance, @NotNull List<String> oracleImplementationInstances, @NotNull String scenarioImports, @NotNull ResultProcessor<AF, CF, QF, AGF> resultProcessor) {
        Intrinsics.checkNotNullParameter((Object)testImplementationInstance, (String)"testImplementationInstance");
        Intrinsics.checkNotNullParameter(oracleImplementationInstances, (String)"oracleImplementationInstances");
        Intrinsics.checkNotNullParameter((Object)scenarioImports, (String)"scenarioImports");
        Intrinsics.checkNotNullParameter(resultProcessor, (String)"resultProcessor");
        this.testImplementationInstance = testImplementationInstance;
        this.oracleImplementationInstances = oracleImplementationInstances;
        this.scenarioImports = scenarioImports;
        this.resultProcessor = resultProcessor;
    }

    public /* synthetic */ ScenarioScriptRunner(String string, List list, String string2, ResultProcessor resultProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            resultProcessor = new ResultProcessor.Default();
        }
        this(string, list, string2, resultProcessor);
    }

    public final void runScenario(@NotNull String scenarioScript) {
        Intrinsics.checkNotNullParameter((Object)scenarioScript, (String)"scenarioScript");
        try {
            BuildableScenario scenario;
            BuildableScenario buildableScenario;
            try {
                buildableScenario = new SimpleScenarioParser().parse(scenarioScript, this.scenarioImports);
            }
            catch (ScriptException e) {
                this.resultProcessor.handleError(new InvalidScenarioException(e));
                return;
            }
            buildableScenario = scenario = buildableScenario;
            if (buildableScenario instanceof OracleScenario) {
                Intrinsics.checkNotNull((Object)scenario, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.core.scenario.OracleScenario<AF of com.anaplan.engineering.azuki.runner.ScenarioScriptRunner, QF of com.anaplan.engineering.azuki.runner.ScenarioScriptRunner, AGF of com.anaplan.engineering.azuki.runner.ScenarioScriptRunner>");
                this.runOracleScenario((OracleScenario)scenario);
            } else if (buildableScenario instanceof VerifiableScenario) {
                Intrinsics.checkNotNull((Object)scenario, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.core.scenario.VerifiableScenario<AF of com.anaplan.engineering.azuki.runner.ScenarioScriptRunner, CF of com.anaplan.engineering.azuki.runner.ScenarioScriptRunner>");
                this.runVerifiableScenario((VerifiableScenario)scenario);
            } else {
                this.resultProcessor.handleError(new UnsupportedScenarioTypeException(Reflection.getOrCreateKotlinClass(scenario.getClass())));
            }
        }
        catch (Throwable t) {
            this.resultProcessor.handleError(t);
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runOracleScenario(OracleScenario<AF, QF, AGF> scenario) {
        void $this$mapTo$iv$iv;
        ImplementationInstance<AF, CF, QF, AGF> testInstance = this.getImplementationInstance(this.testImplementationInstance);
        Iterable $this$map$iv = this.oracleImplementationInstances;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getImplementationInstance((String)it));
        }
        List oracleInstances = (List)destination$iv$iv;
        MultiOracleScenarioRunner.Result result = new MultiOracleScenarioRunner(testInstance, oracleInstances, scenario, "RunAt" + System.currentTimeMillis()).run();
        this.resultProcessor.processOracleScenario(result);
    }

    private final ImplementationInstance<AF, CF, QF, AGF> getImplementationInstance(String instanceName) {
        Object v0;
        block2: {
            List implementationInstances = ImplementationInstance.Companion.getImplementationInstances();
            Iterable iterable = implementationInstances;
            for (Object t : iterable) {
                ImplementationInstance it = (ImplementationInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInstanceName(), (Object)instanceName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ImplementationInstance implementationInstance = v0;
        if (implementationInstance == null) {
            Companion.exit("No implementation named " + instanceName + " found", ExitCode.UnknownImplementation);
            throw new KotlinNothingValueException();
        }
        return implementationInstance;
    }

    private final void runVerifiableScenario(VerifiableScenario<AF, CF> scenario) {
        ImplementationInstance<AF, CF, QF, AGF> implementationInstance = this.getImplementationInstance(this.testImplementationInstance);
        VerifiableScenarioRunner.Result result = new VerifiableScenarioRunner(implementationInstance, this.getPersistenceVerificationInstance(), scenario, "RunAt" + System.currentTimeMillis()).run();
        this.resultProcessor.processVerifiableScenario(result);
    }

    private final ImplementationInstance<AF, CF, QF, AGF> getPersistenceVerificationInstance() {
        return ImplementationInstance.Companion.getHavePersistenceVerificationInstance() ? ImplementationInstance.Companion.getPersistenceVerificationInstance() : null;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ScenarioScriptRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$Companion;", "", "()V", "Log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "exit", "", "msg", "", "exitCode", "Lcom/anaplan/engineering/azuki/runner/ExitCode;", "azuki-runner"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return Log;
        }

        @NotNull
        public final Void exit(@NotNull String msg, @NotNull ExitCode exitCode) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)((Object)exitCode), (String)"exitCode");
            this.getLog().error(msg);
            System.exit(exitCode.ordinal());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$InvalidScenarioException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "e", "Ljavax/script/ScriptException;", "(Ljavax/script/ScriptException;)V", "azuki-runner"})
    public static final class InvalidScenarioException
    extends RuntimeException {
        public InvalidScenarioException(@NotNull ScriptException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0004\u0010\u0001*\u00020\u0002*\b\b\u0005\u0010\u0003*\u00020\u0004*\b\b\u0006\u0010\u0005*\u00020\u0006*\b\b\u0007\u0010\u0007*\u00020\b2\u00020\t:\u0001\u0013J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$ResultProcessor;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "", "handleError", "", "error", "", "processOracleScenario", "result", "Lcom/anaplan/engineering/azuki/core/runner/MultiOracleScenarioRunner$Result;", "processVerifiableScenario", "Lcom/anaplan/engineering/azuki/core/runner/VerifiableScenarioRunner$Result;", "Default", "azuki-runner"})
    public static interface ResultProcessor<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory> {
        public void processOracleScenario(@NotNull MultiOracleScenarioRunner.Result<AF, CF, QF, AGF> var1);

        public void processVerifiableScenario(@NotNull VerifiableScenarioRunner.Result var1);

        public void handleError(@NotNull Throwable var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\b\u0010\u0001*\u00020\u0002*\b\b\t\u0010\u0003*\u00020\u0004*\b\b\n\u0010\u0005*\u00020\u0006*\b\b\u000b\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\tB\u0005\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$ResultProcessor$Default;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$ResultProcessor;", "()V", "azuki-runner"})
        public static final class Default<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory>
        implements ResultProcessor<AF, CF, QF, AGF> {
            @Override
            public void processOracleScenario(@NotNull MultiOracleScenarioRunner.Result<AF, CF, QF, AGF> result) {
                DefaultImpls.processOracleScenario(this, result);
            }

            @Override
            public void processVerifiableScenario(@NotNull VerifiableScenarioRunner.Result result) {
                DefaultImpls.processVerifiableScenario(this, result);
            }

            @Override
            public void handleError(@NotNull Throwable error) {
                DefaultImpls.handleError(this, error);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static <AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory> void processOracleScenario(@NotNull ResultProcessor<AF, CF, QF, AGF> $this, @NotNull MultiOracleScenarioRunner.Result<AF, CF, QF, AGF> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                Companion.getLog().info("Scenario completed with result: " + result);
            }

            public static <AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory> void processVerifiableScenario(@NotNull ResultProcessor<AF, CF, QF, AGF> $this, @NotNull VerifiableScenarioRunner.Result result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Companion.getLog().info("Scenario completed with result: " + result);
                switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                    case 1: {
                        Companion.exit("Scenario was unverified", ExitCode.VerificationFailed);
                        throw new KotlinNothingValueException();
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        Companion.exit("Invalid scenario", ExitCode.InvalidScenario);
                        throw new KotlinNothingValueException();
                    }
                    case 7: {
                        Companion.exit("System does not support verify/report", ExitCode.InvalidSystem);
                        throw new KotlinNothingValueException();
                    }
                    case 8: {
                        Companion.exit("There was an unexpected error", ExitCode.UnknownError);
                        throw new KotlinNothingValueException();
                    }
                    case 9: {
                        Companion.exit("There was a configuration issue: a persistable system was expected", ExitCode.NotPersistable);
                        throw new KotlinNothingValueException();
                    }
                    case 10: 
                    case 11: {
                        Companion.getLog().info("Run completed successfully");
                    }
                }
            }

            public static <AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory> void handleError(@NotNull ResultProcessor<AF, CF, QF, AGF> $this, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Throwable throwable = error;
                if (throwable instanceof InvalidScenarioException) {
                    Throwable throwable2 = error.getCause();
                    Companion.exit("Scenario is invalid:\n" + (throwable2 != null ? throwable2.getMessage() : null), ExitCode.InvalidScenario);
                    throw new KotlinNothingValueException();
                }
                if (throwable instanceof UnsupportedScenarioTypeException) {
                    Companion.exit("Currently unsupported scenario type: " + ((UnsupportedScenarioTypeException)error).getType(), ExitCode.UnsupportedScenarioType);
                    throw new KotlinNothingValueException();
                }
                Companion.exit("Unknown error", ExitCode.UnknownError);
                throw new KotlinNothingValueException();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VerifiableScenarioRunner.Result.values().length];
                try {
                    nArray[VerifiableScenarioRunner.Result.Unverified.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.UnsupportedCommand.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.UnsupportedDeclaration.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.UnsupportedCheck.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.NoSupportedChecks.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.NotVerifiable.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.IncompatibleSystem.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.UnknownError.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.NotPersistable.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.Verified.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerifiableScenarioRunner.Result.Reported.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/anaplan/engineering/azuki/runner/ScenarioScriptRunner$UnsupportedScenarioTypeException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "type", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "getType", "()Lkotlin/reflect/KClass;", "azuki-runner"})
    public static final class UnsupportedScenarioTypeException
    extends RuntimeException {
        @NotNull
        private final KClass<?> type;

        public UnsupportedScenarioTypeException(@NotNull KClass<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final KClass<?> getType() {
            return this.type;
        }
    }
}

