/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.script.generation;

import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.core.scenario.VerifiableScenario;
import com.anaplan.engineering.azuki.core.system.Action;
import com.anaplan.engineering.azuki.core.system.ActionFactory;
import com.anaplan.engineering.azuki.core.system.ActionGeneratorFactory;
import com.anaplan.engineering.azuki.core.system.Answer;
import com.anaplan.engineering.azuki.core.system.Check;
import com.anaplan.engineering.azuki.core.system.CheckFactory;
import com.anaplan.engineering.azuki.core.system.QueryFactory;
import com.anaplan.engineering.azuki.core.system.UnsupportedAction;
import com.anaplan.engineering.azuki.declaration.DeclarableActionKt;
import com.anaplan.engineering.azuki.declaration.Declaration;
import com.anaplan.engineering.azuki.declaration.DeclarationBuilderFactory;
import com.anaplan.engineering.azuki.declaration.DeclarationState;
import com.anaplan.engineering.azuki.declaration.DeclarationStateBuilder;
import com.anaplan.engineering.azuki.declaration.DeclarationStateFactory;
import com.anaplan.engineering.azuki.script.formatter.ScenarioFormatter;
import com.anaplan.engineering.azuki.script.generation.ScriptGenDeclarationBuilder;
import com.anaplan.engineering.azuki.script.generation.ScriptGenDeclarationBuilderFactory;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationAction;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheck;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n2\u00020\u000b:\u00014B#\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0006\u0010\r\u001a\u00028\u0001\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00040\u000f\u00a2\u0006\u0002\u0010\u0010J%\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0005\u0010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ&\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aJ\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aJ\u0014\u0010$\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001a\u0010%\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&J\u001e\u0010%\u001a\u00020\u001a2\u0016\u0010'\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010)0(J\u0016\u0010*\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0(H\u0002J\u0016\u0010-\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0002J\u001e\u0010.\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aJ\u0014\u00100\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001c\u00101\u001a\b\u0012\u0004\u0012\u0002020(2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J\"\u00103\u001a\b\u0012\u0004\u0012\u00020,0(2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&H\u0016R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\r\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "S", "Lcom/anaplan/engineering/azuki/declaration/DeclarationState;", "", "actionFactory", "checkFactory", "declarationStateFactory", "Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;", "(Lcom/anaplan/engineering/azuki/core/system/ActionFactory;Lcom/anaplan/engineering/azuki/core/system/CheckFactory;Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;)V", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "declarationBuilder", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilder;", "D", "Lcom/anaplan/engineering/azuki/declaration/Declaration;", "declaration", "(Lcom/anaplan/engineering/azuki/declaration/Declaration;)Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilder;", "generateGivenScript", "", "scenario", "Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;", "generateOracleScenarioScript", "given", "whenever", "generate", "verify", "generateQueryScenarioScript", "query", "generateScript", "generateThenScript", "Lcom/anaplan/engineering/azuki/core/scenario/VerifiableScenario;", "answers", "", "Lcom/anaplan/engineering/azuki/core/system/Answer;", "generateThenScriptFromChecks", "checks", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationCheck;", "generateUnformattedScript", "generateVerifiableScenarioScript", "then", "generateWheneverScript", "getBuildActions", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationAction;", "getChecks", "Companion", "azuki-script-generation"})
@SourceDebugExtension(value={"SMAP\nScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/ScriptGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1549#2:155\n1620#2,3:156\n1360#2:159\n1446#2,5:160\n1549#2:165\n1620#2,3:166\n1549#2:169\n1620#2,3:170\n800#2,11:173\n1855#2,2:184\n1549#2:186\n1620#2,3:187\n*S KotlinDebug\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/ScriptGenerator\n*L\n58#1:155\n58#1:156,3\n65#1:159\n65#1:160,5\n66#1:165\n66#1:166,3\n90#1:169\n90#1:170,3\n95#1:173,11\n96#1:184,2\n99#1:186\n99#1:187,3\n*E\n"})
public abstract class ScriptGenerator<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory, S extends DeclarationState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AF actionFactory;
    @NotNull
    private final CF checkFactory;
    @NotNull
    private final DeclarationStateFactory<S> declarationStateFactory;
    @NotNull
    private static final DeclarationBuilderFactory<ScriptGenDeclarationBuilderFactory<?>> declarationBuilderFactory = new DeclarationBuilderFactory(ScriptGenDeclarationBuilderFactory.class);

    public ScriptGenerator(@NotNull AF actionFactory, @NotNull CF checkFactory, @NotNull DeclarationStateFactory<S> declarationStateFactory) {
        Intrinsics.checkNotNullParameter(actionFactory, (String)"actionFactory");
        Intrinsics.checkNotNullParameter(checkFactory, (String)"checkFactory");
        Intrinsics.checkNotNullParameter(declarationStateFactory, (String)"declarationStateFactory");
        this.actionFactory = actionFactory;
        this.checkFactory = checkFactory;
        this.declarationStateFactory = declarationStateFactory;
    }

    @NotNull
    public final String generateScript(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        String script = this.generateUnformattedScript(scenario);
        String string = ScenarioFormatter.formatScenario((String)script);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatScenario(...)");
        return string;
    }

    private final String generateUnformattedScript(BuildableScenario<AF> scenario) {
        String given = this.generateGivenScript(scenario);
        String whenever = this.generateWheneverScript(scenario);
        if (!(scenario instanceof VerifiableScenario)) {
            throw new IllegalArgumentException("Unsupported scenario " + scenario);
        }
        Intrinsics.checkNotNull(scenario, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.core.scenario.VerifiableScenario<AF of com.anaplan.engineering.azuki.script.generation.ScriptGenerator, CF of com.anaplan.engineering.azuki.script.generation.ScriptGenerator>");
        String then = this.generateThenScript((VerifiableScenario)scenario);
        return this.generateVerifiableScenarioScript(given, whenever, then);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ScriptGenerationCheck> getChecks(@NotNull VerifiableScenario<AF, CF> scenario) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        Iterable $this$map$iv = scenario.checks(this.checkFactory);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Check check = (Check)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheck");
            collection.add((ScriptGenerationCheck)it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String generateThenScript(@NotNull VerifiableScenario<AF, CF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateThenScriptFromChecks(this.getChecks(scenario));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateThenScript(@NotNull List<? extends Answer<?, CF>> answers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        Answer it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(answers, (String)"answers");
        Iterable iterable = answers;
        ScriptGenerator scriptGenerator = this;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Answer)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.createChecks(this.checkFactory);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Check)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheck");
            collection.add((ScriptGenerationCheck)it);
        }
        return scriptGenerator.generateThenScriptFromChecks((List)destination$iv$iv);
    }

    private final String generateThenScriptFromChecks(List<? extends ScriptGenerationCheck> checks) {
        if (checks.isEmpty()) {
            throw new IllegalArgumentException("No checks to generate!");
        }
        return "\n                then {\n                    " + CollectionsKt.joinToString$default((Iterable)checks, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateThenScriptFromChecks.1.INSTANCE, (int)30, null) + "\n                }\n            ";
    }

    @NotNull
    public final String generateVerifiableScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String then) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)then, (String)"then");
        return "\n            verifiableScenario {\n                " + given + "\n                " + whenever + "\n                " + then + "\n            }\n        ";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ScriptGenerationAction> getBuildActions(@NotNull BuildableScenario<AF> scenario) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        Iterable $this$map$iv = scenario.commands(this.actionFactory);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.script.generation.ScriptGenerationAction");
            collection.add((ScriptGenerationAction)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateGivenScript(@NotNull BuildableScenario<AF> scenario) {
        void $this$mapTo$iv$iv;
        Iterable element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        List definitions = scenario.declarations(this.actionFactory);
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof UnsupportedAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!((Collection)((List)destination$iv$iv)).isEmpty()) {
            Iterable $this$forEach$iv = definitions;
            boolean $i$f$forEach = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                Action it = (Action)element$iv2;
                boolean bl = false;
                System.out.println((Object)(" * " + it));
            }
            throw new IllegalArgumentException("Scriptgen is missing action");
        }
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(DeclarableActionKt.toDeclarableAction((Action)it));
        }
        List declarableActions = (List)destination$iv$iv2;
        List declarations = new DeclarationStateBuilder(this.declarationStateFactory).build(declarableActions);
        return declarations.isEmpty() ? "" : "\n                given {\n                    " + CollectionsKt.joinToString$default((Iterable)declarations, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Declaration, CharSequence>(this){
            final /* synthetic */ ScriptGenerator<AF, CF, QF, AGF, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Declaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ScriptGenerator.access$declarationBuilder(this.this$0, it).getDeclarationScript();
            }
        }), (int)30, null) + "\n                }\n            ";
    }

    private final <D extends Declaration> ScriptGenDeclarationBuilder<D> declarationBuilder(D declaration) {
        return (ScriptGenDeclarationBuilder)declarationBuilderFactory.createBuilder(declaration);
    }

    @NotNull
    public final String generateWheneverScript(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        List<ScriptGenerationAction> buildActions = this.getBuildActions(scenario);
        return buildActions.isEmpty() ? "" : "\n                whenever {\n                    " + CollectionsKt.joinToString$default((Iterable)buildActions, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateWheneverScript.1.INSTANCE, (int)30, null) + "\n                }\n            ";
    }

    @NotNull
    public final String generateOracleScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String generate, @NotNull String verify) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)generate, (String)"generate");
        Intrinsics.checkNotNullParameter((Object)verify, (String)"verify");
        return "\n            oracleScenario {\n                " + given + "\n                " + whenever + "\n                " + generate + "\n                " + verify + "\n            }\n        ";
    }

    @NotNull
    public final String generateQueryScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return "\n            queryScenario {\n                " + given + "\n                " + whenever + "\n                " + query + "\n            }\n        ";
    }

    public static final /* synthetic */ ScriptGenDeclarationBuilder access$declarationBuilder(ScriptGenerator $this, Declaration declaration) {
        return $this.declarationBuilder(declaration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator$Companion;", "", "()V", "declarationBuilderFactory", "Lcom/anaplan/engineering/azuki/declaration/DeclarationBuilderFactory;", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilderFactory;", "azuki-script-generation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

