/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.script.generation;

import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.core.scenario.VerifiableScenario;
import com.anaplan.engineering.azuki.core.system.Action;
import com.anaplan.engineering.azuki.core.system.ActionFactory;
import com.anaplan.engineering.azuki.core.system.ActionGeneratorFactory;
import com.anaplan.engineering.azuki.core.system.Answer;
import com.anaplan.engineering.azuki.core.system.Check;
import com.anaplan.engineering.azuki.core.system.CheckFactory;
import com.anaplan.engineering.azuki.core.system.QueryFactory;
import com.anaplan.engineering.azuki.core.system.UnsupportedAction;
import com.anaplan.engineering.azuki.core.system.ValidatableAnswer;
import com.anaplan.engineering.azuki.declaration.DeclarableActionKt;
import com.anaplan.engineering.azuki.declaration.Declaration;
import com.anaplan.engineering.azuki.declaration.DeclarationBuilderFactory;
import com.anaplan.engineering.azuki.declaration.DeclarationState;
import com.anaplan.engineering.azuki.declaration.DeclarationStateBuilder;
import com.anaplan.engineering.azuki.declaration.DeclarationStateFactory;
import com.anaplan.engineering.azuki.script.formatter.ScenarioFormatter;
import com.anaplan.engineering.azuki.script.generation.ScriptGenDeclarationBuilder;
import com.anaplan.engineering.azuki.script.generation.ScriptGenDeclarationBuilderFactory;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationAction;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationActionKt;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheck;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheckState;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheckStateBuilder;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationCheckStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 H*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n*\b\b\u0005\u0010\u000b*\u00020\f2\u00020\r:\u0001HB3\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u0012\u0006\u0010\u000f\u001a\u00028\u0001\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00040\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00050\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0002J&\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0014J\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010#H\u0016J \u0010$\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010&H\u0016J \u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0010\u0010%\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010(H\u0016J\u001a\u0010)\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010#J(\u0010)\u001a\u00020\u00192\u0016\u0010*\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010(0!2\b\b\u0002\u0010+\u001a\u00020,J\u0014\u0010-\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0!J\u001e\u0010/\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0019J\u001c\u00101\u001a\b\u0012\u0004\u0012\u0002020!2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u001c\u00103\u001a\b\u0012\u0004\u0012\u0002040!2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0014\u00105\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0014\u00106\u001a\u00020\u00192\f\u00107\u001a\b\u0012\u0004\u0012\u0002020!J%\u00108\u001a\b\u0012\u0004\u0012\u0002H:09\"\b\b\u0006\u0010:*\u00020;2\u0006\u0010<\u001a\u0002H:H\u0002\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0014\u0010?\u001a\u00020\u00192\f\u0010@\u001a\b\u0012\u0004\u0012\u0002040!J(\u0010A\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010B\u001a\u00020\u00192\u0006\u0010C\u001a\u00020\u0019H\u0007J.\u0010A\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u00192\u0006\u0010C\u001a\u00020\u0019J\u001e\u0010F\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u0019R\u0010\u0010\u000e\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u000f\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "S", "Lcom/anaplan/engineering/azuki/declaration/DeclarationState;", "CS", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationCheckState;", "", "actionFactory", "checkFactory", "declarationStateFactory", "Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;", "checkStateFactory", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationCheckStateFactory;", "<init>", "(Lcom/anaplan/engineering/azuki/core/system/ActionFactory;Lcom/anaplan/engineering/azuki/core/system/CheckFactory;Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationCheckStateFactory;)V", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "generateScript", "", "scenario", "Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;", "generateUnformattedScript", "generateNonVerifiableScenario", "given", "whenever", "getChecks", "", "Lcom/anaplan/engineering/azuki/core/system/Check;", "Lcom/anaplan/engineering/azuki/core/scenario/VerifiableScenario;", "getValidationChecks", "answer", "Lcom/anaplan/engineering/azuki/core/system/ValidatableAnswer;", "getChecksFromAnswer", "Lcom/anaplan/engineering/azuki/core/system/Answer;", "generateThenScript", "answers", "useValidationChecks", "", "generateThenScriptFromChecks", "checks", "generateVerifiableScenarioScript", "then", "getDeclarationActions", "Lcom/anaplan/engineering/azuki/core/system/Action;", "getBuildActions", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationAction;", "generateGivenScript", "generateGivenScriptFromActions", "definitions", "declarationBuilder", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilder;", "D", "Lcom/anaplan/engineering/azuki/declaration/Declaration;", "declaration", "(Lcom/anaplan/engineering/azuki/declaration/Declaration;)Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilder;", "generateWheneverScript", "generateWheneverScriptFromActions", "buildActions", "generateOracleScenarioScript", "generate", "verify", "givenGenerate", "whenGenerate", "generateQueryScenarioScript", "query", "Companion", "azuki-script-generation"})
@SourceDebugExtension(value={"SMAP\nScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/ScriptGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1368#2:258\n1454#2,5:259\n1557#2:264\n1628#2,3:265\n808#2,11:268\n1863#2,2:279\n1557#2:281\n1628#2,3:282\n*S KotlinDebug\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/ScriptGenerator\n*L\n55#1:258\n55#1:259,5\n90#1:264\n90#1:265,3\n96#1:268,11\n97#1:279,2\n100#1:281\n100#1:282,3\n*E\n"})
public abstract class ScriptGenerator<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory, S extends DeclarationState, CS extends ScriptGenerationCheckState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AF actionFactory;
    @NotNull
    private final CF checkFactory;
    @NotNull
    private final DeclarationStateFactory<S> declarationStateFactory;
    @NotNull
    private final ScriptGenerationCheckStateFactory<CS> checkStateFactory;
    @NotNull
    private static final DeclarationBuilderFactory<ScriptGenDeclarationBuilderFactory<?>> declarationBuilderFactory = new DeclarationBuilderFactory(ScriptGenDeclarationBuilderFactory.class);

    public ScriptGenerator(@NotNull AF actionFactory, @NotNull CF checkFactory, @NotNull DeclarationStateFactory<S> declarationStateFactory, @NotNull ScriptGenerationCheckStateFactory<CS> checkStateFactory) {
        Intrinsics.checkNotNullParameter(actionFactory, (String)"actionFactory");
        Intrinsics.checkNotNullParameter(checkFactory, (String)"checkFactory");
        Intrinsics.checkNotNullParameter(declarationStateFactory, (String)"declarationStateFactory");
        Intrinsics.checkNotNullParameter(checkStateFactory, (String)"checkStateFactory");
        this.actionFactory = actionFactory;
        this.checkFactory = checkFactory;
        this.declarationStateFactory = declarationStateFactory;
        this.checkStateFactory = checkStateFactory;
    }

    @NotNull
    public final String generateScript(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        String script = this.generateUnformattedScript(scenario);
        return ScenarioFormatter.formatScenario((String)script);
    }

    private final String generateUnformattedScript(BuildableScenario<AF> scenario) {
        String string;
        String given = this.generateGivenScript(scenario);
        String whenever = this.generateWheneverScript(scenario);
        if (scenario instanceof VerifiableScenario) {
            String then = this.generateThenScript((VerifiableScenario)scenario);
            string = this.generateVerifiableScenarioScript(given, whenever, then);
        } else {
            string = this.generateNonVerifiableScenario(given, whenever, scenario);
        }
        return string;
    }

    @NotNull
    protected String generateNonVerifiableScenario(@NotNull String given, @NotNull String whenever, @NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        throw new UnsupportedOperationException("Unsupported scenario type " + Reflection.getOrCreateKotlinClass(scenario.getClass()));
    }

    @NotNull
    public List<Check> getChecks(@NotNull VerifiableScenario<AF, CF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return scenario.checks(this.checkFactory);
    }

    @NotNull
    public List<Check> getValidationChecks(@NotNull ValidatableAnswer<?, CF> answer) {
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        return answer.createValidationChecks(this.checkFactory);
    }

    @NotNull
    public List<Check> getChecksFromAnswer(@NotNull Answer<?, CF> answer) {
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        return answer.createChecks(this.checkFactory);
    }

    @NotNull
    public final String generateThenScript(@NotNull VerifiableScenario<AF, CF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateThenScriptFromChecks(this.getChecks(scenario));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateThenScript(@NotNull List<? extends Answer<?, CF>> answers, boolean useValidationChecks) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(answers, (String)"answers");
        Iterable iterable = answers;
        ScriptGenerator scriptGenerator = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Answer it = (Answer)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = useValidationChecks && it instanceof ValidatableAnswer ? this.getValidationChecks((ValidatableAnswer)it) : this.getChecksFromAnswer(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return scriptGenerator.generateThenScriptFromChecks((List)destination$iv$iv);
    }

    public static /* synthetic */ String generateThenScript$default(ScriptGenerator scriptGenerator, List list, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateThenScript");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return scriptGenerator.generateThenScript(list, bl);
    }

    @NotNull
    public final String generateThenScriptFromChecks(@NotNull List<? extends Check> checks) {
        Intrinsics.checkNotNullParameter(checks, (String)"checks");
        List<ScriptGenerationCheck> body = new ScriptGenerationCheckStateBuilder<CS>(this.checkStateFactory).build(checks);
        if (body.isEmpty()) {
            throw new IllegalArgumentException("No checks to generate!");
        }
        return "\n                then {\n                    " + CollectionsKt.joinToString$default((Iterable)body, (CharSequence)"\n", null, null, (int)0, null, ScriptGenerator::generateThenScriptFromChecks$lambda$1, (int)30, null) + "\n                }\n            ";
    }

    @NotNull
    public final String generateVerifiableScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String then) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)then, (String)"then");
        return "\n            verifiableScenario {\n                " + given + "\n                " + whenever + "\n                " + then + "\n            }\n        ";
    }

    @NotNull
    public List<Action> getDeclarationActions(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return scenario.declarations(this.actionFactory);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ScriptGenerationAction> getBuildActions(@NotNull BuildableScenario<AF> scenario) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        Iterable $this$map$iv = scenario.commands(this.actionFactory);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$getBuildActions$stub_for_inlining = false;
            boolean bl = false;
            collection.add(ScriptGenerationActionKt.toScriptGenAction((Action)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String generateGivenScript(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateGivenScriptFromActions(this.getDeclarationActions(scenario));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateGivenScriptFromActions(@NotNull List<? extends Action> definitions) {
        void $this$mapTo$iv$iv;
        Iterable element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        Iterable $this$filterIsInstance$iv = definitions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof UnsupportedAction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!((Collection)((List)destination$iv$iv)).isEmpty()) {
            Iterable $this$forEach$iv = definitions;
            boolean $i$f$forEach = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                Action it = (Action)element$iv2;
                boolean bl = false;
                System.out.println((Object)(" * " + it));
            }
            throw new IllegalArgumentException("Scriptgen is missing action");
        }
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(DeclarableActionKt.toDeclarableAction((Action)it));
        }
        List declarableActions = (List)destination$iv$iv2;
        List declarations = new DeclarationStateBuilder(this.declarationStateFactory).build(declarableActions);
        return declarations.isEmpty() ? "" : "\n                given {\n                    " + CollectionsKt.joinToString$default((Iterable)declarations, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ScriptGenerator.generateGivenScriptFromActions$lambda$4(this, arg_0), (int)30, null) + "\n                }\n            ";
    }

    private final <D extends Declaration> ScriptGenDeclarationBuilder<D> declarationBuilder(D declaration) {
        return (ScriptGenDeclarationBuilder)declarationBuilderFactory.createBuilder(declaration);
    }

    @NotNull
    public final String generateWheneverScript(@NotNull BuildableScenario<AF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateWheneverScriptFromActions(this.getBuildActions(scenario));
    }

    @NotNull
    public final String generateWheneverScriptFromActions(@NotNull List<? extends ScriptGenerationAction> buildActions) {
        Intrinsics.checkNotNullParameter(buildActions, (String)"buildActions");
        return buildActions.isEmpty() ? "" : "\n                whenever {\n                    " + CollectionsKt.joinToString$default((Iterable)buildActions, (CharSequence)"\n", null, null, (int)0, null, ScriptGenerator::generateWheneverScriptFromActions$lambda$5, (int)30, null) + "\n                }\n            ";
    }

    @Deprecated(message="Use the version with separate generate blocks", replaceWith=@ReplaceWith(expression="generateOracleScenarioScript(given, whenever, \"\", generate, verify)", imports={}))
    @NotNull
    public final String generateOracleScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String generate, @NotNull String verify) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)generate, (String)"generate");
        Intrinsics.checkNotNullParameter((Object)verify, (String)"verify");
        return this.generateOracleScenarioScript(given, whenever, "", generate, verify);
    }

    @NotNull
    public final String generateOracleScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String givenGenerate, @NotNull String whenGenerate, @NotNull String verify) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)givenGenerate, (String)"givenGenerate");
        Intrinsics.checkNotNullParameter((Object)whenGenerate, (String)"whenGenerate");
        Intrinsics.checkNotNullParameter((Object)verify, (String)"verify");
        return "\n            oracleScenario {\n                " + given + "\n                " + givenGenerate + "\n                " + whenever + "\n                " + whenGenerate + "\n                " + verify + "\n            }\n        ";
    }

    @NotNull
    public final String generateQueryScenarioScript(@NotNull String given, @NotNull String whenever, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return "\n            queryScenario {\n                " + given + "\n                " + whenever + "\n                " + query + "\n            }\n        ";
    }

    private static final CharSequence generateThenScriptFromChecks$lambda$1(ScriptGenerationCheck it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCheckScript();
    }

    private static final CharSequence generateGivenScriptFromActions$lambda$4(ScriptGenerator this$0, Declaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.declarationBuilder(it).getDeclarationScript();
    }

    private static final CharSequence generateWheneverScriptFromActions$lambda$5(ScriptGenerationAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getActionScript();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator$Companion;", "", "<init>", "()V", "declarationBuilderFactory", "Lcom/anaplan/engineering/azuki/declaration/DeclarationBuilderFactory;", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenDeclarationBuilderFactory;", "azuki-script-generation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

