/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.script.generation;

import com.anaplan.engineering.azuki.core.parser.ScenarioParser;
import com.anaplan.engineering.azuki.core.parser.ScenarioParsingContext;
import com.anaplan.engineering.azuki.core.parser.SimpleScenarioParser;
import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.core.system.ActionFactory;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u0015*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001\u0015B?\u0012&\u0010\u0006\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0019\b\u0002\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014R.\u0010\u0006\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationTestHelper;", "S", "Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "", "generatorFactory", "Lkotlin/Function0;", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator;", "parser", "Lcom/anaplan/engineering/azuki/core/parser/ScenarioParser;", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/anaplan/engineering/azuki/core/parser/ScenarioParser;)V", "checkScenarioGeneration", "", "scenario", "initContext", "Lkotlin/Function1;", "Lcom/anaplan/engineering/azuki/core/parser/ScenarioParsingContext;", "Lkotlin/ExtensionFunctionType;", "(Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;Lkotlin/jvm/functions/Function1;)V", "Companion", "azuki-script-generation"})
public class ScriptGenerationTestHelper<S extends BuildableScenario<AF>, AF extends ActionFactory> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<ScriptGenerator<AF, ?, ?, ?, ?, ?>> generatorFactory;
    @NotNull
    private final ScenarioParser<S> parser;
    private static final Logger Log = LoggerFactory.getLogger(Companion.getClass().getDeclaringClass());

    public ScriptGenerationTestHelper(@NotNull Function0<? extends ScriptGenerator<AF, ?, ?, ?, ?, ?>> generatorFactory, @NotNull ScenarioParser<S> parser) {
        Intrinsics.checkNotNullParameter(generatorFactory, (String)"generatorFactory");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        this.generatorFactory = generatorFactory;
        this.parser = parser;
    }

    public /* synthetic */ ScriptGenerationTestHelper(Function0 function0, ScenarioParser scenarioParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scenarioParser = (ScenarioParser)new SimpleScenarioParser();
        }
        this(function0, scenarioParser);
    }

    public final void checkScenarioGeneration(@NotNull S scenario, @NotNull Function1<? super ScenarioParsingContext, Unit> initContext) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter(initContext, (String)"initContext");
        Log.debug("Generating script");
        String generatedScript = ((ScriptGenerator)this.generatorFactory.invoke()).generateScript(scenario);
        Log.debug("Generated:\n" + generatedScript);
        BuildableScenario parsedScenario = this.parser.parse(generatedScript, initContext);
        Log.debug("Regenerating script");
        String regeneratedScript = ((ScriptGenerator)this.generatorFactory.invoke()).generateScript(parsedScenario);
        Log.debug("Regenerated:\n" + regeneratedScript);
        Assert.assertEquals((Object)generatedScript, (Object)regeneratedScript);
    }

    public static /* synthetic */ void checkScenarioGeneration$default(ScriptGenerationTestHelper scriptGenerationTestHelper, BuildableScenario buildableScenario, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkScenarioGeneration");
        }
        if ((n & 2) != 0) {
            function1 = ScriptGenerationTestHelper::checkScenarioGeneration$lambda$0;
        }
        scriptGenerationTestHelper.checkScenarioGeneration(buildableScenario, (Function1<ScenarioParsingContext, Unit>)function1);
    }

    private static final Unit checkScenarioGeneration$lambda$0(ScenarioParsingContext scenarioParsingContext) {
        Intrinsics.checkNotNullParameter((Object)scenarioParsingContext, (String)"<this>");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationTestHelper$Companion;", "", "<init>", "()V", "Log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "azuki-script-generation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

