/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.script.generation;

import com.anaplan.engineering.azuki.core.scenario.BuildableScenario;
import com.anaplan.engineering.azuki.core.scenario.OracleScenario;
import com.anaplan.engineering.azuki.core.scenario.ScenarioQueries;
import com.anaplan.engineering.azuki.core.scenario.ScenarioWithQueries;
import com.anaplan.engineering.azuki.core.system.ActionFactory;
import com.anaplan.engineering.azuki.core.system.ActionGenerator;
import com.anaplan.engineering.azuki.core.system.ActionGeneratorFactory;
import com.anaplan.engineering.azuki.core.system.CheckFactory;
import com.anaplan.engineering.azuki.core.system.DerivedQuery;
import com.anaplan.engineering.azuki.core.system.Query;
import com.anaplan.engineering.azuki.core.system.QueryFactory;
import com.anaplan.engineering.azuki.declaration.DeclarationState;
import com.anaplan.engineering.azuki.declaration.DeclarationStateFactory;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationActionGenerator;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationDerivedQuery;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationEnvironment;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerationQuery;
import com.anaplan.engineering.azuki.script.generation.ScriptGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n*\b\b\u0005\u0010\u000b*\u00020\f2&\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\rBE\u0012\u0006\u0010\u000e\u001a\u00028\u0000\u0012\u0006\u0010\u000f\u001a\u00028\u0001\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00040\u0011\u0012\u0006\u0010\u0012\u001a\u00028\u0005\u0012\u0006\u0010\u0013\u001a\u00028\u0003\u0012\u0006\u0010\u0014\u001a\u00028\u0002\u0012\u0006\u0010\u0015\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0014J\u001a\u0010 \u001a\u00020\u001b2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\"J \u0010$\u001a\u00020\u001b2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030%J\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u00020\u001b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020*J\u000e\u0010+\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002R\u0010\u0010\u0013\u001a\u00028\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0014\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u0015\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/anaplan/engineering/azuki/script/generation/VerificationCapableScriptGenerator;", "AF", "Lcom/anaplan/engineering/azuki/core/system/ActionFactory;", "CF", "Lcom/anaplan/engineering/azuki/core/system/CheckFactory;", "QF", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "AGF", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "S", "Lcom/anaplan/engineering/azuki/declaration/DeclarationState;", "E", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationEnvironment;", "Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerator;", "actionFactory", "checkFactory", "declarationStateFactory", "Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;", "environment", "actionGeneratorFactory", "queryQueryFactory", "verifyQueryFactory", "<init>", "(Lcom/anaplan/engineering/azuki/core/system/ActionFactory;Lcom/anaplan/engineering/azuki/core/system/CheckFactory;Lcom/anaplan/engineering/azuki/declaration/DeclarationStateFactory;Lcom/anaplan/engineering/azuki/script/generation/ScriptGenerationEnvironment;Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;Lcom/anaplan/engineering/azuki/core/system/QueryFactory;Lcom/anaplan/engineering/azuki/core/system/QueryFactory;)V", "Lcom/anaplan/engineering/azuki/core/system/ActionGeneratorFactory;", "Lcom/anaplan/engineering/azuki/core/system/QueryFactory;", "generateNonVerifiableScenario", "", "given", "whenever", "scenario", "Lcom/anaplan/engineering/azuki/core/scenario/BuildableScenario;", "generateGenerateScript", "generations", "", "Lcom/anaplan/engineering/azuki/core/system/ActionGenerator;", "generateVerifyScript", "Lcom/anaplan/engineering/azuki/core/scenario/OracleScenario;", "generateVerifyScriptFromQueries", "scenarioQueries", "Lcom/anaplan/engineering/azuki/core/scenario/ScenarioQueries;", "generateQueryScript", "Lcom/anaplan/engineering/azuki/core/scenario/ScenarioWithQueries;", "generateQueryScriptFromQueries", "generateVerifyOrQueryScriptBody", "azuki-script-generation"})
@SourceDebugExtension(value={"SMAP\nScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/VerificationCapableScriptGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n1557#2:275\n1628#2,3:276\n*S KotlinDebug\n*F\n+ 1 ScriptGenerator.kt\ncom/anaplan/engineering/azuki/script/generation/VerificationCapableScriptGenerator\n*L\n229#1:275\n229#1:276,3\n*E\n"})
public abstract class VerificationCapableScriptGenerator<AF extends ActionFactory, CF extends CheckFactory, QF extends QueryFactory, AGF extends ActionGeneratorFactory, S extends DeclarationState, E extends ScriptGenerationEnvironment>
extends ScriptGenerator<AF, CF, QF, AGF, S, E> {
    @NotNull
    private final AGF actionGeneratorFactory;
    @NotNull
    private final QF queryQueryFactory;
    @NotNull
    private final QF verifyQueryFactory;

    public VerificationCapableScriptGenerator(@NotNull AF actionFactory, @NotNull CF checkFactory, @NotNull DeclarationStateFactory<S> declarationStateFactory, @NotNull E environment, @NotNull AGF actionGeneratorFactory, @NotNull QF queryQueryFactory, @NotNull QF verifyQueryFactory) {
        Intrinsics.checkNotNullParameter(actionFactory, (String)"actionFactory");
        Intrinsics.checkNotNullParameter(checkFactory, (String)"checkFactory");
        Intrinsics.checkNotNullParameter(declarationStateFactory, (String)"declarationStateFactory");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(actionGeneratorFactory, (String)"actionGeneratorFactory");
        Intrinsics.checkNotNullParameter(queryQueryFactory, (String)"queryQueryFactory");
        Intrinsics.checkNotNullParameter(verifyQueryFactory, (String)"verifyQueryFactory");
        super(actionFactory, checkFactory, declarationStateFactory, environment);
        this.actionGeneratorFactory = actionGeneratorFactory;
        this.queryQueryFactory = queryQueryFactory;
        this.verifyQueryFactory = verifyQueryFactory;
    }

    @Override
    @NotNull
    protected String generateNonVerifiableScenario(@NotNull String given, @NotNull String whenever, @NotNull BuildableScenario<AF> scenario) {
        String string;
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        Intrinsics.checkNotNullParameter((Object)whenever, (String)"whenever");
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        BuildableScenario<AF> buildableScenario = scenario;
        if (buildableScenario instanceof OracleScenario) {
            OracleScenario oracleScenario = (OracleScenario)scenario;
            String givenGenerate = this.generateGenerateScript(oracleScenario.givenActionGenerations(this.actionGeneratorFactory));
            String whenGenerate = this.generateGenerateScript(oracleScenario.whenActionGenerations(this.actionGeneratorFactory));
            String verify = this.generateVerifyScript(oracleScenario);
            string = this.generateOracleScenarioScript(given, whenever, givenGenerate, whenGenerate, verify);
        } else if (buildableScenario instanceof ScenarioWithQueries) {
            String query = this.generateQueryScript((ScenarioWithQueries)scenario);
            string = this.generateQueryScenarioScript(given, whenever, query);
        } else {
            throw new IllegalArgumentException("Unsupported scenario " + scenario);
        }
        return string;
    }

    @NotNull
    public final String generateGenerateScript(@NotNull List<? extends List<? extends ActionGenerator>> generations) {
        Intrinsics.checkNotNullParameter(generations, (String)"generations");
        return CollectionsKt.joinToString$default((Iterable)generations, (CharSequence)"\n", null, null, (int)0, null, VerificationCapableScriptGenerator::generateGenerateScript$lambda$2, (int)30, null);
    }

    @NotNull
    public final String generateVerifyScript(@NotNull OracleScenario<AF, QF, AGF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateVerifyScriptFromQueries(scenario.queries(this.verifyQueryFactory));
    }

    @NotNull
    public final String generateVerifyScriptFromQueries(@NotNull ScenarioQueries scenarioQueries) {
        Intrinsics.checkNotNullParameter((Object)scenarioQueries, (String)"scenarioQueries");
        if (scenarioQueries.isEmpty()) {
            throw new IllegalArgumentException("No queries for oracle scenario");
        }
        return "\n            verify {\n                " + this.generateVerifyOrQueryScriptBody(scenarioQueries) + "\n            }\n            ";
    }

    @NotNull
    public final String generateQueryScript(@NotNull ScenarioWithQueries<AF, QF> scenario) {
        Intrinsics.checkNotNullParameter(scenario, (String)"scenario");
        return this.generateQueryScriptFromQueries(scenario.queries(this.queryQueryFactory));
    }

    @NotNull
    public final String generateQueryScriptFromQueries(@NotNull ScenarioQueries scenarioQueries) {
        Intrinsics.checkNotNullParameter((Object)scenarioQueries, (String)"scenarioQueries");
        if (scenarioQueries.isEmpty()) {
            throw new IllegalArgumentException("No queries for verify script");
        }
        return "\n            query {\n                " + this.generateVerifyOrQueryScriptBody(scenarioQueries) + "\n            }\n            ";
    }

    private final String generateVerifyOrQueryScriptBody(ScenarioQueries scenarioQueries) {
        String queries = CollectionsKt.joinToString$default((Iterable)scenarioQueries.getQueries(), (CharSequence)"\n", null, null, (int)0, null, VerificationCapableScriptGenerator::generateVerifyOrQueryScriptBody$lambda$3, (int)30, null);
        String forAllQueries = CollectionsKt.joinToString$default((Iterable)scenarioQueries.getForAllQueries(), (CharSequence)"\n", null, null, (int)0, null, VerificationCapableScriptGenerator::generateVerifyOrQueryScriptBody$lambda$4, (int)30, null);
        return queries + "\n" + forAllQueries;
    }

    private static final CharSequence generateGenerateScript$lambda$2$lambda$1(ScriptGenerationActionGenerator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getActionGeneratorScript();
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateGenerateScript$lambda$2(List generation) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)generation, (String)"generation");
        Iterable $this$map$iv = generation;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ActionGenerator actionGenerator = (ActionGenerator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.anaplan.engineering.azuki.script.generation.ScriptGenerationActionGenerator");
            collection.add((ScriptGenerationActionGenerator)it);
        }
        List actionGenerators = (List)destination$iv$iv;
        return actionGenerators.isEmpty() ? (CharSequence)"" : (CharSequence)("\n                generate {\n                    " + CollectionsKt.joinToString$default((Iterable)actionGenerators, (CharSequence)"\n", null, null, (int)0, null, VerificationCapableScriptGenerator::generateGenerateScript$lambda$2$lambda$1, (int)30, null) + "\n                }\n            ");
    }

    private static final CharSequence generateVerifyOrQueryScriptBody$lambda$3(Query it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((ScriptGenerationQuery)it).getQueryScript();
    }

    private static final CharSequence generateVerifyOrQueryScriptBody$lambda$4(DerivedQuery it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((ScriptGenerationDerivedQuery)it).getDerivedQueryScript();
    }
}

