/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.azuki.vdm.coverage;

import com.anaplan.engineering.vdmanimation.api.AnimationCoverage;
import com.anaplan.engineering.vdmanimation.api.FileCoverage;
import com.anaplan.engineering.vdmanimation.api.Location;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\nJ \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/anaplan/engineering/azuki/vdm/coverage/CoverageRecorder;", "", "()V", "locationComparator", "Ljava/util/Comparator;", "Lcom/anaplan/engineering/vdmanimation/api/Location;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "escape", "", "text", "generateHtml", "fileCoverage", "Lcom/anaplan/engineering/vdmanimation/api/FileCoverage;", "recordHtml", "", "coverage", "Lcom/anaplan/engineering/vdmanimation/api/AnimationCoverage;", "reportDir", "Ljava/io/File;", "reportLocation", "recordJson", "coverageLocation", "writeHtmlCoverage", "moduleName", "azuki-vdm"})
@SourceDebugExtension(value={"SMAP\nCoverageRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageRecorder.kt\ncom/anaplan/engineering/azuki/vdm/coverage/CoverageRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,126:1\n1477#2:127\n1502#2,3:128\n1505#2,3:138\n1864#2,3:142\n1855#2,2:146\n1855#2,2:148\n372#3,7:131\n215#4:141\n216#4:145\n*S KotlinDebug\n*F\n+ 1 CoverageRecorder.kt\ncom/anaplan/engineering/azuki/vdm/coverage/CoverageRecorder\n*L\n32#1:127\n32#1:128,3\n32#1:138,3\n36#1:142,3\n92#1:146,2\n78#1:148,2\n32#1:131,7\n32#1:141\n32#1:145\n*E\n"})
public final class CoverageRecorder {
    @NotNull
    public static final CoverageRecorder INSTANCE = new CoverageRecorder();
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
    @NotNull
    private static final Comparator<Location> locationComparator = CoverageRecorder::locationComparator$lambda$3;

    private CoverageRecorder() {
    }

    public final void recordJson(@NotNull AnimationCoverage coverage, @Nullable String coverageLocation) {
        Intrinsics.checkNotNullParameter((Object)coverage, (String)"coverage");
        if (coverageLocation == null) {
            return;
        }
        File coverageDir = new File(coverageLocation);
        if (!coverageDir.exists()) {
            coverageDir.mkdirs();
        }
        objectMapper.writeValue(new File(coverageDir, System.currentTimeMillis() + ".cov"), (Object)coverage);
    }

    public static /* synthetic */ void recordJson$default(CoverageRecorder coverageRecorder, AnimationCoverage animationCoverage, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = System.getProperty("coverage.location");
        }
        coverageRecorder.recordJson(animationCoverage, string);
    }

    public final void recordHtml(@NotNull AnimationCoverage coverage, @Nullable String reportLocation) {
        Intrinsics.checkNotNullParameter((Object)coverage, (String)"coverage");
        if (reportLocation == null) {
            return;
        }
        this.recordHtml(coverage, new File(reportLocation));
    }

    public static /* synthetic */ void recordHtml$default(CoverageRecorder coverageRecorder, AnimationCoverage animationCoverage, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = System.getProperty("report.location");
        }
        coverageRecorder.recordHtml(animationCoverage, string);
    }

    /*
     * WARNING - void declaration
     */
    public final void recordHtml(@NotNull AnimationCoverage coverage, @NotNull File reportDir) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)coverage, (String)"coverage");
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        if (!reportDir.exists()) {
            reportDir.mkdirs();
        }
        Iterable $this$groupBy$iv = coverage.getFiles();
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            FileCoverage it = (FileCoverage)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getModuleName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String moduleName = (String)entry.getKey();
            List files2 = (List)entry.getValue();
            if (files2.size() == 1) {
                INSTANCE.writeHtmlCoverage(reportDir, moduleName, (FileCoverage)files2.get(0));
                continue;
            }
            Iterable $this$forEachIndexed$iv = files2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void file;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileCoverage fileCoverage = (FileCoverage)item$iv;
                int index = n;
                boolean bl3 = false;
                INSTANCE.writeHtmlCoverage(reportDir, moduleName + "_" + index, (FileCoverage)file);
            }
        }
    }

    private final void writeHtmlCoverage(File reportDir, String moduleName, FileCoverage fileCoverage) {
        File reportFile = new File(reportDir, moduleName + ".html");
        FilesKt.writeText$default((File)reportFile, (String)this.generateHtml(fileCoverage), null, (int)2, null);
    }

    private final String escape(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    private final String generateHtml(FileCoverage fileCoverage) {
        List lines = StringsKt.lines((CharSequence)fileCoverage.getText());
        List locations = CollectionsKt.sortedWith((Iterable)fileCoverage.getCoverage().keySet(), locationComparator);
        int currentLine = 0;
        currentLine = 1;
        int currentPos = 0;
        currentPos = 1;
        StringBuilder htmlBuilder = new StringBuilder("<html>\n<pre>\n");
        Iterable $this$forEach$iv = locations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location location = (Location)element$iv;
            boolean bl = false;
            Object v = fileCoverage.getCoverage().get(location);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
            long hitCount = (Long)v;
            if (location.getStartLine() < currentLine || location.getStartLine() == currentLine && location.getStartPos() < currentPos) {
                throw new IllegalStateException("Overlapping locations!");
            }
            if (location.getStartLine() != currentLine || location.getStartPos() != currentPos) {
                CoverageRecorder.generateHtml$copyText(lines, htmlBuilder, currentLine, currentPos, location.getStartLine(), location.getStartPos());
            }
            if (hitCount > 0L) {
                htmlBuilder.append("<span title=\"Hit " + hitCount + " times\" style=\"background-color: #c4ffc5;\">");
                CoverageRecorder.generateHtml$copyText(lines, htmlBuilder, location.getStartLine(), location.getStartPos(), location.getEndLine(), location.getEndPos());
                htmlBuilder.append("</span>");
            } else {
                htmlBuilder.append("<span style=\"background-color: #ff9696;\">");
                CoverageRecorder.generateHtml$copyText(lines, htmlBuilder, location.getStartLine(), location.getStartPos(), location.getEndLine(), location.getEndPos());
                htmlBuilder.append("</span>");
            }
            currentLine = location.getEndLine();
            currentPos = location.getEndPos();
        }
        if (currentLine < lines.size() || currentPos < ((String)lines.get(lines.size() - 1)).length()) {
            CoverageRecorder.generateHtml$copyText(lines, htmlBuilder, currentLine, currentPos, lines.size(), ((String)lines.get(lines.size() - 1)).length() + 1);
        }
        htmlBuilder.append("\n</pre>\n</html>");
        String string = htmlBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int locationComparator$lambda$3(Location o1, Location o2) {
        int endLineCompare;
        int startPosCompare;
        int startLineCompare = Intrinsics.compare((int)o1.getStartLine(), (int)o2.getStartLine());
        return startLineCompare != 0 ? startLineCompare : ((startPosCompare = Intrinsics.compare((int)o1.getStartPos(), (int)o2.getStartPos())) != 0 ? startPosCompare : ((endLineCompare = Intrinsics.compare((int)o1.getEndLine(), (int)o2.getEndLine())) != 0 ? endLineCompare : Intrinsics.compare((int)o1.getEndPos(), (int)o2.getEndPos())));
    }

    private static final void generateHtml$copyText(List<String> lines, StringBuilder htmlBuilder, int startLine, int startPos, int endLine, int endPos) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(startLine - 1, endLine - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int endIndex;
            int element$iv;
            int line = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int lastIndex = lines.get(line).length();
            int startIndex = line == startLine - 1 ? Math.max(startPos - 1, 0) : 0;
            int n = endIndex = line == endLine - 1 ? Math.max(endPos - 1, 0) : lastIndex;
            if (startIndex == lastIndex) {
                htmlBuilder.append("\n");
                continue;
            }
            if (endIndex == lastIndex) {
                String string = lines.get(line).substring(startIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                htmlBuilder.append(INSTANCE.escape(string));
                htmlBuilder.append("\n");
                continue;
            }
            String string = lines.get(line).substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            htmlBuilder.append(INSTANCE.escape(string));
        }
    }
}

