package com.anaplan.engineering.kazuki.toolkit

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.Sequence
import com.anaplan.engineering.kazuki.core.`internal`._KSequence
import com.anaplan.engineering.kazuki.core.as_Set
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Set

public object OrderedSet_Module {
  public fun <T> mk_OrderedSet(elements: List<T>): OrderedSet<T> = OrderedSet_Seq(elements)

  public fun <T> mk_OrderedSet(vararg elements: T): OrderedSet<T> =
      OrderedSet_Seq(elements.toList())

  public fun <T> is_OrderedSet(elements: List<T>): Boolean = OrderedSet_Seq(elements,
      false).isValid()

  public fun <T> as_OrderedSet(elements: List<T>): OrderedSet<T> = mk_OrderedSet(elements)

  private class OrderedSet_Seq<T>(
    open override val elements: List<T>,
    enforceInvariant: Boolean = true,
  ) : OrderedSet<T>, _KSequence<T, OrderedSet<T>>, List<T> by elements {
    override val len: Int by elements::size

    override val elems: Set<T> by lazy {
          as_Set(elements)}


    override val inds: Set<Int> by lazy {
          as_Set(1 .. len)}


    init {
      if (enforceInvariant && !isValid()) {
        throw InvariantFailure()
      }
    }

    internal fun isValid(): Boolean = noDuplicates()

    override fun construct(elements: List<T>): OrderedSet<T> = OrderedSet_Seq(elements)

    override operator fun `get`(index: Int): T {
      if (index < 1 || index > len) {
        throw PreconditionFailure()
      }
      return elements.get(index - 1)
    }

    override fun indexOf(element: T): Int {
      if (element !in elements) {
        throw PreconditionFailure()
      }
      return elements.indexOf(element) + 1
    }

    override fun lastIndexOf(element: T): Int {
      if (element !in elements) {
        throw PreconditionFailure()
      }
      return elements.lastIndexOf(element) + 1
    }

    override fun toString(): String = "OrderedSet$elements"

    override fun hashCode(): Int = elements.hashCode()

    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (other !is Sequence<*>) {
        return false
      }
      return elements == other
    }
  }
}
