package com.anaplan.engineering.kazuki.toolkit.ISO8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import com.anaplan.engineering.kazuki.toolkit.ISO8601.DtgInZone.DtgInZoneFunctions
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object DtgInZone_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun DtgInZone.as_Tuple(): Tuple2<Date, TimeInZone> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Date, TimeInZone>
    } else {
      throw PreconditionFailure("Cannot convert instance of DtgInZone created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_DtgInZone(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Date) {
      return false
    }
    if (other._2 !is TimeInZone) {
      return false
    }
    val candidate = DtgInZone_Rec(other._1 as Date, other._2 as TimeInZone, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  private fun as_DtgInZone(other: Tuple2<Date, TimeInZone>): DtgInZone = DtgInZone_Rec(other._1,
      other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_DtgInZone(other: Any): DtgInZone {
    if (!is_DtgInZone(other)) {
      throw PreconditionFailure("""$other is not a DtgInZone""")
    } else {
      return as_DtgInZone(other as Tuple2<Date, TimeInZone>)
    }
  }

  public operator fun DtgInZone.component1(): Date = this.date

  public operator fun DtgInZone.component2(): TimeInZone = this.time

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : DtgInZone> _A.`set`(date: Date = this.date, time: TimeInZone = this.time): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Date, TimeInZone, _A>).construct(date, time)
    } else {
      throw PreconditionFailure("Cannot set on instance of DtgInZone created outside Kazuki")
    }
  }

  public fun mk_DtgInZone(date: Date, time: TimeInZone): DtgInZone = DtgInZone_Rec(date, time)

  @_Record("date", "time")
  private data class DtgInZone_Rec(
    override val date: Date,
    override val time: TimeInZone,
    private val enforceInvariant: Boolean = true,
  ) : DtgInZone, _Tuple2<Date, TimeInZone, DtgInZone> {
    override val _1: Date = date

    override val _2: TimeInZone = time

    override val functions: DtgInZone.DtgInZoneFunctions =
        com.anaplan.engineering.kazuki.toolkit.ISO8601.DtgInZone.DtgInZoneFunctions(this)


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("DtgInZone", "dtgBeforeFirstDate", ::dtgBeforeFirstDate),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("DtgInZone", "dtgAfterLastDate", ::dtgAfterLastDate))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("DtgInZone invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: Date): DtgInZone = DtgInZone_Rec(t1,_2)

    override fun construct(t1: Date, t2: TimeInZone): DtgInZone = DtgInZone_Rec(t1,t2)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("DtgInZone")
        append("(")
        append("""date=$date, """)
        append("""time=$time""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
