package com.anaplan.engineering.kazuki.toolkit.ISO8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Interval.IntervalFunctions
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object Interval_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Interval.as_Tuple(): Tuple2<Dtg, Dtg> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Dtg, Dtg>
    } else {
      throw PreconditionFailure("Cannot convert instance of Interval created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Interval(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Dtg) {
      return false
    }
    if (other._2 !is Dtg) {
      return false
    }
    val candidate = Interval_Rec(other._1 as Dtg, other._2 as Dtg, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  private fun as_Interval(other: Tuple2<Dtg, Dtg>): Interval = Interval_Rec(other._1, other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Interval(other: Any): Interval {
    if (!is_Interval(other)) {
      throw PreconditionFailure("""$other is not a Interval""")
    } else {
      return as_Interval(other as Tuple2<Dtg, Dtg>)
    }
  }

  public operator fun Interval.component1(): Dtg = this.begins

  public operator fun Interval.component2(): Dtg = this.ends

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Interval> _A.`set`(begins: Dtg = this.begins, ends: Dtg = this.ends): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Dtg, Dtg, _A>).construct(begins, ends)
    } else {
      throw PreconditionFailure("Cannot set on instance of Interval created outside Kazuki")
    }
  }

  public fun mk_Interval(begins: Dtg, ends: Dtg): Interval = Interval_Rec(begins, ends)

  @_Record("begins", "ends")
  private data class Interval_Rec(
    override val begins: Dtg,
    override val ends: Dtg,
    private val enforceInvariant: Boolean = true,
  ) : Interval, _Tuple2<Dtg, Dtg, Interval> {
    override val _1: Dtg = begins

    override val _2: Dtg = ends

    override val functions: Interval.IntervalFunctions =
        com.anaplan.engineering.kazuki.toolkit.ISO8601.Interval.IntervalFunctions(this)


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("Interval", "zeroSizeInterval", ::zeroSizeInterval),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Interval", "beginAfterEnd", ::beginAfterEnd))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("Interval invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: Dtg): Interval = Interval_Rec(t1,_2)

    override fun construct(t1: Dtg, t2: Dtg): Interval = Interval_Rec(t1,t2)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Interval")
        append("(")
        append("""begins=$begins, """)
        append("""ends=$ends""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
