package com.anaplan.engineering.kazuki.toolkit.ISO8601

import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.reflect.KClass

public object NormalisedTime_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun NormalisedTime.as_Tuple(): Tuple2<Time, PlusOrMinus> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Time, PlusOrMinus>
    } else {
      throw PreconditionFailure("Cannot convert instance of NormalisedTime created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_NormalisedTime(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Time) {
      return false
    }
    if (other._2 !is PlusOrMinus) {
      return false
    }
    val candidate = NormalisedTime_Rec(other._1 as Time, other._2 as PlusOrMinus, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  private fun as_NormalisedTime(other: Tuple2<Time, PlusOrMinus>): NormalisedTime =
      NormalisedTime_Rec(other._1, other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_NormalisedTime(other: Any): NormalisedTime {
    if (!is_NormalisedTime(other)) {
      throw PreconditionFailure("""$other is not a NormalisedTime""")
    } else {
      return as_NormalisedTime(other as Tuple2<Time, PlusOrMinus>)
    }
  }

  public operator fun NormalisedTime.component1(): Time = this.time

  public operator fun NormalisedTime.component2(): PlusOrMinus = this.plusOrMinusADay

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : NormalisedTime> _A.`set`(time: Time = this.time, plusOrMinusADay: PlusOrMinus =
      this.plusOrMinusADay): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Time, PlusOrMinus, _A>).construct(time, plusOrMinusADay)
    } else {
      throw PreconditionFailure("Cannot set on instance of NormalisedTime created outside Kazuki")
    }
  }

  public fun mk_NormalisedTime(time: Time, plusOrMinusADay: PlusOrMinus): NormalisedTime =
      NormalisedTime_Rec(time, plusOrMinusADay)

  @_Record("time", "plusOrMinusADay")
  private data class NormalisedTime_Rec(
    override val time: Time,
    override val plusOrMinusADay: PlusOrMinus,
    private val enforceInvariant: Boolean = true,
  ) : NormalisedTime, _Tuple2<Time, PlusOrMinus, NormalisedTime> {
    override val _1: Time = time

    override val _2: PlusOrMinus = plusOrMinusADay

    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    override fun construct(t1: Time): NormalisedTime = NormalisedTime_Rec(t1,_2)

    override fun construct(t1: Time, t2: PlusOrMinus): NormalisedTime = NormalisedTime_Rec(t1,t2)

    internal fun isValid(): Boolean = true

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("NormalisedTime")
        append("(")
        append("""time=$time, """)
        append("""plusOrMinusADay=$plusOrMinusADay""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
