package com.anaplan.engineering.kazuki.toolkit

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._KSequence
import com.anaplan.engineering.kazuki.core.`internal`._KazukiObject
import com.anaplan.engineering.kazuki.core.as_Set
import java.util.ArrayList
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Set
import kotlin.reflect.KClass

public object OrderedSet_Module {
  public fun <T> mk_OrderedSet(elements: List<T>): OrderedSet<T> = OrderedSet_Seq(elements)

  public fun <T> mk_OrderedSet(vararg elements: T): OrderedSet<T> =
      OrderedSet_Seq(elements.toList())

  public fun <T> is_OrderedSet(elements: List<T>): Boolean = (elements is OrderedSet<*>) ||
      OrderedSet_Seq<T>(ArrayList<T>(elements.size).apply { addAll(elements) }, false ).isValid()

  public fun <T> as_OrderedSet(elements: List<T>): OrderedSet<T> {
    if (elements is OrderedSet<*>) {
      return elements as OrderedSet<T>
    } else {
      return mk_OrderedSet(ArrayList<T>(elements.size).apply { addAll(elements) })
    }
  }

  private class OrderedSet_Seq<T>(
    override val elements: List<T>,
    enforceInvariant: Boolean = true,
  ) : OrderedSet<T>, _KSequence<T, OrderedSet<T>>, List<T> by elements {
    override val len: Int by elements::size

    override val elems: Set<T> by lazy {
          as_Set(elements)}


    override val inds: Set<Int> by lazy {
          as_Set(1 .. len)}


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Sequence::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("OrderedSet", "noDuplicates", ::noDuplicates))

    init {
      assert (elements !is _KazukiObject) {
        "Internal state should not be a Kazuki-generated object"
      }
    }
    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("OrderedSet invariant failed in: " + failedClauses)
        }
      }
    }

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun construct(elements: List<T>): OrderedSet<T> = OrderedSet_Seq(elements)

    override operator fun `get`(index: Int): T {
      if (index < 1 || index > len) {
        throw PreconditionFailure("""Index $index is not valid for sequence of length $len""")
      }
      return elements.get(index - 1)
    }

    override fun indexOf(element: T): Int {
      if (element !in elements) {
        throw PreconditionFailure()
      }
      return elements.indexOf(element) + 1
    }

    override fun lastIndexOf(element: T): Int {
      if (element !in elements) {
        throw PreconditionFailure()
      }
      return elements.lastIndexOf(element) + 1
    }

    override fun toString(): String = "OrderedSet$elements"

    override fun hashCode(): Int = elements.hashCode()

    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (other !is _KSequence<*, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return elements == other
    }
  }
}
