/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.kazuki.toolkit.ISO8601;

import com.anaplan.engineering.kazuki.core.FunctionProvider;
import com.anaplan.engineering.kazuki.core.FunctionsKt;
import com.anaplan.engineering.kazuki.core.Invariant;
import com.anaplan.engineering.kazuki.core.Module;
import com.anaplan.engineering.kazuki.core.PredicateLogicKt;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.ConstantsKt;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Date;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.DateKt;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Date_Module;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.DayOfWeek;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Dtg;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Dtg_Module;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Duration;
import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dJ\u0011\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0017J\b\u0010\u001c\u001a\u00020\u001bH\u0017R$\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u0003j\b\u0012\u0004\u0012\u00020\u0000`\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00060\bj\u0002`\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\r8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00060\bj\u0002`\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0016\u0010\u0015\u001a\u00060\bj\u0002`\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date;", "", "dateComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getDateComparator", "()Ljava/util/Comparator;", "day", "", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Day;", "getDay", "()I", "functions", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date$DateFunctions;", "getFunctions$annotations", "()V", "getFunctions", "()Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date$DateFunctions;", "month", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Month;", "getMonth", "year", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Year;", "getYear", "compareTo", "other", "isDayValid", "", "primitivesValid", "DateFunctions", "kazuki-toolkit"})
public interface Date
extends Comparable<Date> {
    public int getYear();

    public int getMonth();

    public int getDay();

    @Invariant
    default public boolean primitivesValid() {
        return DateKt.yearInRange(this.getYear()) && DateKt.monthInRange(this.getMonth()) && DateKt.dayInRange(this.getDay());
    }

    @Invariant
    default public boolean isDayValid() {
        return this.getDay() <= ((Number)DateKt.getDaysInMonth().invoke((Object)this.getYear(), (Object)this.getMonth())).intValue();
    }

    private Comparator<Date> getDateComparator() {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Date it = (Date)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getYear());
                it = (Date)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getYear()));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Date it = (Date)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getMonth());
                    it = (Date)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMonth()));
                }
                return n;
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Date it = (Date)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getDay());
                    it = (Date)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDay()));
                }
                return n;
            }
        };
    }

    @Override
    default public int compareTo(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getDateComparator().compare(this, other);
    }

    @NotNull
    public DateFunctions getFunctions();

    @FunctionProvider(provider=DateFunctions.class)
    public static /* synthetic */ void getFunctions$annotations() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R!\u0010\u0005\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\f\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR!\u0010\u0015\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\f\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date$DateFunctions;", "", "date", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date;", "(Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Date;)V", "addDays", "Lkotlin/Function1;", "", "Lcom/anaplan/engineering/kazuki/core/nat;", "getAddDays", "()Lkotlin/jvm/functions/Function1;", "addMonths", "Lcom/anaplan/engineering/kazuki/core/int;", "getAddMonths", "format", "Lkotlin/Function0;", "", "getFormat", "()Lkotlin/jvm/functions/Function0;", "subtractDays", "getSubtractDays", "subtractMonths", "getSubtractMonths", "toDayOfWeek", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/DayOfWeek;", "getToDayOfWeek", "toDtgAtStartOfDay", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Dtg;", "getToDtgAtStartOfDay", "toDurationSinceFirstDate", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Duration;", "getToDurationSinceFirstDate", "kazuki-toolkit"})
    public static final class DateFunctions {
        @NotNull
        private final Date date;
        @NotNull
        private final Function0<Duration> toDurationSinceFirstDate;
        @NotNull
        private final Function0<String> format;
        @NotNull
        private final Function0<DayOfWeek> toDayOfWeek;
        @NotNull
        private final Function1<Integer, Date> addMonths;
        @NotNull
        private final Function1<Integer, Date> subtractMonths;
        @NotNull
        private final Function1<Integer, Date> addDays;
        @NotNull
        private final Function1<Integer, Date> subtractDays;
        @NotNull
        private final Function0<Dtg> toDtgAtStartOfDay;

        public DateFunctions(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.date = date;
            this.toDurationSinceFirstDate = (Function0)FunctionsKt.function$default((Function0)((Function0)new Function0<Duration>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Duration invoke() {
                    return (Duration)((Duration)Duration.Companion.getDurationFromFirstYearUpToStartOfYear().invoke((Object)DateFunctions.access$getDate$p(this.this$0).getYear())).getFunctions().getAddDuration().invoke(((Duration)Duration.Companion.getDurationInYearUpToStartOfMonth().invoke((Object)DateFunctions.access$getDate$p(this.this$0).getYear(), (Object)DateFunctions.access$getDate$p(this.this$0).getMonth())).getFunctions().getAddDuration().invoke(Duration.Companion.getFromDays().invoke((Object)((long)DateFunctions.access$getDate$p(this.this$0).getDay() - 1L))));
                }
            }), null, null, null, (int)14, null);
            this.format = (Function0)FunctionsKt.function$default((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "%04d-%02d-%02d";
                    Object[] objectArray = new Object[]{DateFunctions.access$getDate$p(this.this$0).getYear(), DateFunctions.access$getDate$p(this.this$0).getMonth(), DateFunctions.access$getDate$p(this.this$0).getDay()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    return string2;
                }
            }), null, (Function1)format.2.INSTANCE, null, (int)10, null);
            this.toDayOfWeek = (Function0)FunctionsKt.function$default((Function0)((Function0)new Function0<DayOfWeek>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final DayOfWeek invoke() {
                    return (DayOfWeek)((Object)PredicateLogicKt.iota((Iterable)((Iterable)toDayOfWeek.EntriesMappings.entries$0), (Function1)((Function1)new Function1<DayOfWeek, Boolean>(this.this$0){
                        final /* synthetic */ DateFunctions this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull DayOfWeek day) {
                            Intrinsics.checkNotNullParameter((Object)((Object)day), (String)"day");
                            return day.ordinal() == ((int)((Number)((Duration)DateFunctions.access$getDate$p(this.this$0).getFunctions().getToDurationSinceFirstDate().invoke()).getFunctions().getToDays().invoke()).longValue() - 365) % 7;
                        }
                    })));
                }
            }), null, null, null, (int)14, null);
            this.addMonths = (Function1)FunctionsKt.function$default((Function1)((Function1)new Function1<Integer, Date>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Date invoke(int n) {
                    int n2 = DateFunctions.access$getDate$p(this.this$0).getMonth() + n - 1;
                    int n3 = ConstantsKt.getMonthsPerYear();
                    int n4 = n2 % n3;
                    int nextMonth = n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31) + 1;
                    n3 = DateFunctions.access$getDate$p(this.this$0).getMonth() + n - 1;
                    n4 = ConstantsKt.getMonthsPerYear();
                    int n5 = n3 / n4;
                    if ((n3 ^ n4) < 0 && n5 * n4 != n3) {
                        --n5;
                    }
                    int yearShift = n5;
                    int nextYear = DateFunctions.access$getDate$p(this.this$0).getYear() + yearShift;
                    int nextDay = Math.min(DateFunctions.access$getDate$p(this.this$0).getDay(), ((Number)DateKt.getDaysInMonth().invoke((Object)nextYear, (Object)nextMonth)).intValue());
                    return Date_Module.INSTANCE.mk_Date(nextYear, nextMonth, nextDay);
                }
            }), (Function1)((Function1)new Function1<Integer, Boolean>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int n) {
                    return DateFunctions.access$getDate$p(this.this$0).getYear() * 12 + DateFunctions.access$getDate$p(this.this$0).getMonth() + n > 0;
                }
            }), null, null, (int)12, null);
            this.subtractMonths = (Function1)FunctionsKt.function$default((Function1)((Function1)new Function1<Integer, Date>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Date invoke(int n) {
                    return (Date)DateFunctions.access$getDate$p(this.this$0).getFunctions().getAddMonths().invoke((Object)(-n));
                }
            }), null, null, null, (int)14, null);
            this.addDays = (Function1)FunctionsKt.function$default((Function1)((Function1)new Function1<Integer, Date>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Date invoke(int n) {
                    return (Date)((Duration)((Duration)DateFunctions.access$getDate$p(this.this$0).getFunctions().getToDurationSinceFirstDate().invoke()).getFunctions().getAddDuration().invoke(Duration.Companion.getFromDays().invoke((Object)n))).getFunctions().getToDateAfterFirstDate().invoke();
                }
            }), null, (Function2)((Function2)new Function2<Integer, Date, Boolean>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(int n, @NotNull Date result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    return Intrinsics.areEqual((Object)result.getFunctions().getSubtractDays().invoke((Object)n), (Object)DateFunctions.access$getDate$p(this.this$0));
                }
            }), null, (int)10, null);
            this.subtractDays = (Function1)FunctionsKt.function$default((Function1)((Function1)new Function1<Integer, Date>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Date invoke(int n) {
                    return (Date)((Duration)((Duration)DateFunctions.access$getDate$p(this.this$0).getFunctions().getToDurationSinceFirstDate().invoke()).getFunctions().getSubtractDuration().invoke(Duration.Companion.getFromDays().invoke((Object)n))).getFunctions().getToDateAfterFirstDate().invoke();
                }
            }), (Function1)((Function1)new Function1<Integer, Boolean>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int n) {
                    return ((Number)((Duration)DateFunctions.access$getDate$p(this.this$0).getFunctions().getToDurationSinceFirstDate().invoke()).getFunctions().getToDays().invoke()).longValue() >= (long)n;
                }
            }), null, null, (int)12, null);
            this.toDtgAtStartOfDay = (Function0)FunctionsKt.function$default((Function0)((Function0)new Function0<Dtg>(this){
                final /* synthetic */ DateFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Dtg invoke() {
                    return Dtg_Module.INSTANCE.mk_Dtg(DateFunctions.access$getDate$p(this.this$0), ConstantsKt.getFirstTime());
                }
            }), null, null, null, (int)14, null);
        }

        @NotNull
        public final Function0<Duration> getToDurationSinceFirstDate() {
            return this.toDurationSinceFirstDate;
        }

        @NotNull
        public final Function0<String> getFormat() {
            return this.format;
        }

        @NotNull
        public final Function0<DayOfWeek> getToDayOfWeek() {
            return this.toDayOfWeek;
        }

        @NotNull
        public final Function1<Integer, Date> getAddMonths() {
            return this.addMonths;
        }

        @NotNull
        public final Function1<Integer, Date> getSubtractMonths() {
            return this.subtractMonths;
        }

        @NotNull
        public final Function1<Integer, Date> getAddDays() {
            return this.addDays;
        }

        @NotNull
        public final Function1<Integer, Date> getSubtractDays() {
            return this.subtractDays;
        }

        @NotNull
        public final Function0<Dtg> getToDtgAtStartOfDay() {
            return this.toDtgAtStartOfDay;
        }

        public static final /* synthetic */ Date access$getDate$p(DateFunctions $this) {
            return $this.date;
        }
    }
}

