/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.kazuki.toolkit.ISO8601;

import com.anaplan.engineering.kazuki.core.FunctionProvider;
import com.anaplan.engineering.kazuki.core.FunctionsKt;
import com.anaplan.engineering.kazuki.core.Invariant;
import com.anaplan.engineering.kazuki.core.Module;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.ConstantsKt;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Duration;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Offset;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.PlusOrMinus;
import com.anaplan.engineering.kazuki.toolkit.ISO8601.Time;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001:\u0001\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0012H\u0017R\u001a\u0010\u0002\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00060\tj\u0002`\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset;", "", "functions", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset$OffsetFunctions;", "getFunctions$annotations", "()V", "getFunctions", "()Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset$OffsetFunctions;", "offsetDirection", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/PlusOrMinus;", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/OffsetDirection;", "getOffsetDirection", "()Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/PlusOrMinus;", "offsetDuration", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Duration;", "getOffsetDuration", "()Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Duration;", "offsetGranularityTooFine", "", "offsetMoreThanDay", "OffsetFunctions", "kazuki-toolkit"})
public interface Offset {
    @NotNull
    public Duration getOffsetDuration();

    @NotNull
    public PlusOrMinus getOffsetDirection();

    @Invariant
    default public boolean offsetMoreThanDay() {
        return this.getOffsetDuration().compareTo(ConstantsKt.getOneDayDuration()) < 0;
    }

    @Invariant
    default public boolean offsetGranularityTooFine() {
        return Intrinsics.areEqual((Object)this.getOffsetDuration().getFunctions().getModMinutes().invoke(), (Object)ConstantsKt.getNoDuration());
    }

    @NotNull
    public OffsetFunctions getFunctions();

    @FunctionProvider(provider=OffsetFunctions.class)
    public static /* synthetic */ void getFunctions$annotations() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset$OffsetFunctions;", "", "offset", "Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset;", "(Lcom/anaplan/engineering/kazuki/toolkit/ISO8601/Offset;)V", "format", "Lkotlin/Function0;", "", "getFormat", "()Lkotlin/jvm/functions/Function0;", "kazuki-toolkit"})
    public static final class OffsetFunctions {
        @NotNull
        private final Offset offset;
        @NotNull
        private final Function0<String> format;

        public OffsetFunctions(@NotNull Offset offset) {
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            this.offset = offset;
            this.format = (Function0)FunctionsKt.function$default((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ OffsetFunctions this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string;
                    Time hourMinute = (Time)OffsetFunctions.access$getOffset$p(this.this$0).getOffsetDuration().getFunctions().getToTimeAfterFirstTime().invoke();
                    switch (format.WhenMappings.$EnumSwitchMapping$0[OffsetFunctions.access$getOffset$p(this.this$0).getOffsetDirection().ordinal()]) {
                        case 1: {
                            string = "+";
                            break;
                        }
                        case 2: {
                            string = "-";
                            break;
                        }
                        case 3: {
                            string = "";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    String sign = string;
                    String string2 = "%s%02d:%02d";
                    Object[] objectArray = new Object[]{sign, hourMinute.getHour(), hourMinute.getMinute()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    return string3;
                }
            }), null, null, null, (int)14, null);
        }

        @NotNull
        public final Function0<String> getFormat() {
            return this.format;
        }

        public static final /* synthetic */ Offset access$getOffset$p(OffsetFunctions $this) {
            return $this.offset;
        }
    }
}

