package com.anaplan.engineering.kazuki.toolkit.ISO8601

import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import com.anaplan.engineering.kazuki.toolkit.ISO8601.TimeInZone.TimeInZoneFunctions
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.reflect.KClass

public object TimeInZone_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun TimeInZone.as_Tuple(): Tuple2<Time, Offset> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Time, Offset>
    } else {
      throw PreconditionFailure("Cannot convert instance of TimeInZone created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_TimeInZone(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Time) {
      return false
    }
    if (other._2 !is Offset) {
      return false
    }
    val candidate = TimeInZone_Rec(other._1 as Time, other._2 as Offset, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: TimeInZone?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun TimeInZone.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_TimeInZone(other: Tuple2<Time, Offset>): TimeInZone = TimeInZone_Rec(other._1,
      other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_TimeInZone(other: Any): TimeInZone {
    if (!is_TimeInZone(other)) {
      throw PreconditionFailure("""$other is not a TimeInZone""")
    } else {
      return as_TimeInZone(other as Tuple2<Time, Offset>)
    }
  }

  public operator fun TimeInZone.component1(): Time = this.time

  public operator fun TimeInZone.component2(): Offset = this.offset

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : TimeInZone> _A.`set`(time: Time = this.time, offset: Offset = this.offset): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Time, Offset, _A>).construct(time, offset)
    } else {
      throw PreconditionFailure("Cannot set on instance of TimeInZone created outside Kazuki")
    }
  }

  public fun mk_TimeInZone(time: Time, offset: Offset): TimeInZone = TimeInZone_Rec(time, offset)

  @_Record("time", "offset")
  private data class TimeInZone_Rec(
    override val time: Time,
    override val offset: Offset,
    private val enforceInvariant: Boolean = true,
  ) : TimeInZone, _Tuple2<Time, Offset, TimeInZone> {
    override val _1: Time = time

    override val _2: Offset = offset

    override val functions: TimeInZone.TimeInZoneFunctions =
        com.anaplan.engineering.kazuki.toolkit.ISO8601.TimeInZone.TimeInZoneFunctions(this)


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    override fun construct(t1: Time): TimeInZone = TimeInZone_Rec(t1,_2)

    override fun construct(t1: Time, t2: Offset): TimeInZone = TimeInZone_Rec(t1,t2)

    internal fun isValid(): Boolean = true

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("TimeInZone")
        append("(")
        append("""time=$time, """)
        append("""offset=$offset""")
        append(")")
      }
      return sb.toString()
    }

    override fun pretty(): String {
      val sb = StringBuilder().apply {
        append("(")
        append("""time=${com.anaplan.engineering.kazuki.toolkit.ISO8601.Time_Module._pretty(time)}, """)
        append("""offset=${com.anaplan.engineering.kazuki.toolkit.ISO8601.Offset_Module._pretty(offset)}""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
