package com.anaplan.engineering.kazuki.toolkit.iso8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple4
import com.anaplan.engineering.kazuki.core.`internal`._Constructable4
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple4
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object Time_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Time.as_Tuple(): Tuple4<Hour, Minute, Second, Millisecond> {
    if (this is Tuple4<*, *, *, *>) {
      return this as Tuple4<Hour, Minute, Second, Millisecond>
    } else {
      throw PreconditionFailure("Cannot convert instance of Time created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Time(other: Any): Boolean {
    if (other !is _Tuple4<*, *, *, *, *>) {
      return false
    }
    if (other._1 !is Hour) {
      return false
    }
    if (other._2 !is Minute) {
      return false
    }
    if (other._3 !is Second) {
      return false
    }
    if (other._4 !is Millisecond) {
      return false
    }
    val candidate = Time_Rec(other._1 as Hour, other._2 as Minute, other._3 as Second, other._4 as
        Millisecond, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: Time?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun Time.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_Time(other: Tuple4<Hour, Minute, Second, Millisecond>): Time = Time_Rec(other._1,
      other._2, other._3, other._4)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Time(other: Any): Time {
    if (!is_Time(other)) {
      throw PreconditionFailure("""$other is not a Time""")
    } else {
      return as_Time(other as Tuple4<Hour, Minute, Second, Millisecond>)
    }
  }

  public operator fun Time.component1(): Hour = this.hour

  public operator fun Time.component2(): Minute = this.minute

  public operator fun Time.component3(): Second = this.second

  public operator fun Time.component4(): Millisecond = this.millisecond

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Time> _A.`set`(
    hour: Hour = this.hour,
    minute: Minute = this.minute,
    second: Second = this.second,
    millisecond: Millisecond = this.millisecond,
  ): _A {
    if (this is _Constructable4<*, *, *, *, *>) {
      return (this as _Constructable4<Hour, Minute, Second, Millisecond, _A>).construct(hour,
          minute, second, millisecond)
    } else {
      throw PreconditionFailure("Cannot set on instance of Time created outside Kazuki")
    }
  }

  public fun mk_Time(
    hour: Hour,
    minute: Minute,
    second: Second,
    millisecond: Millisecond,
  ): Time = Time_Rec(hour, minute, second, millisecond)

  @_Record("hour", "minute", "second", "millisecond")
  private data class Time_Rec(
    override val hour: Hour,
    override val minute: Minute,
    override val second: Second,
    override val millisecond: Millisecond,
    private val enforceInvariant: Boolean = true,
  ) : Time, _Tuple4<Hour, Minute, Second, Millisecond, Time> {
    override val _1: Hour = hour

    override val _2: Minute = minute

    override val _3: Second = second

    override val _4: Millisecond = millisecond

    override val functions: TimeFunctions by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.TimeFunctions(this)
    }


    override val properties: TimeProperties by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.TimeProperties(this)
    }


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple4::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("Time", "hour", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.hourNotInRange(hour) }),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Time", "minute", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.minuteNotInRange(minute) }),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Time", "second", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.secondNotInRange(second) }),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Time", "millisecond", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.millisecondNotInRange(millisecond) }))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("Time invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: Hour): Time = Time_Rec(t1,_2,_3,_4)

    override fun construct(t1: Hour, t2: Minute): Time = Time_Rec(t1,t2,_3,_4)

    override fun construct(
      t1: Hour,
      t2: Minute,
      t3: Second,
    ): Time = Time_Rec(t1,t2,t3,_4)

    override fun construct(
      t1: Hour,
      t2: Minute,
      t3: Second,
      t4: Millisecond,
    ): Time = Time_Rec(t1,t2,t3,t4)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Time")
        append("(")
        append("""hour=$hour, """)
        append("""minute=$minute, """)
        append("""second=$second, """)
        append("""millisecond=$millisecond""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2, _3,
        _4).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple4<*, *, *, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2 && _3 == other._3 && _4 == other._4
    }
  }
}
