package com.anaplan.engineering.kazuki.toolkit.iso8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple3
import com.anaplan.engineering.kazuki.core.`internal`._Constructable3
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple3
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object Date_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Date.as_Tuple(): Tuple3<Year, Month, Day> {
    if (this is Tuple3<*, *, *>) {
      return this as Tuple3<Year, Month, Day>
    } else {
      throw PreconditionFailure("Cannot convert instance of Date created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Date(other: Any): Boolean {
    if (other !is _Tuple3<*, *, *, *>) {
      return false
    }
    if (other._1 !is Year) {
      return false
    }
    if (other._2 !is Month) {
      return false
    }
    if (other._3 !is Day) {
      return false
    }
    val candidate = Date_Rec(other._1 as Year, other._2 as Month, other._3 as Day, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: Date?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun Date.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_Date(other: Tuple3<Year, Month, Day>): Date = Date_Rec(other._1, other._2,
      other._3)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Date(other: Any): Date {
    if (other is Date) {
      return other as Date
    } else if (!is_Date(other)) {
      throw PreconditionFailure("""$other is not a Date""")
    } else {
      return as_Date(other as Tuple3<Year, Month, Day>)
    }
  }

  public operator fun Date.component1(): Year = this.year

  public operator fun Date.component2(): Month = this.month

  public operator fun Date.component3(): Day = this.day

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Date> _A.`set`(
    year: Year = this.year,
    month: Month = this.month,
    day: Day = this.day,
  ): _A {
    if (this is _Constructable3<*, *, *, *>) {
      return (this as _Constructable3<Year, Month, Day, _A>).construct(year, month, day)
    } else {
      throw PreconditionFailure("Cannot set on instance of Date created outside Kazuki")
    }
  }

  public fun mk_Date(
    year: Year,
    month: Month,
    day: Day,
  ): Date = Date_Rec(year, month, day)

  @_Record("year", "month", "day")
  private data class Date_Rec(
    override val year: Year,
    override val month: Month,
    override val day: Day,
    private val enforceInvariant: Boolean = true,
  ) : Date, _Tuple3<Year, Month, Day, Date> {
    override val _1: Year = year

    override val _2: Month = month

    override val _3: Day = day

    override val functions: DateFunctions by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DateFunctions(this)
    }


    override val properties: DateProperties by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DateProperties(this)
    }


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple3::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("Date", "primitivesValid", ::primitivesValid),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Date", "isDayValid", ::isDayValid),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Date", "year", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.yearInRange(year) }),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Date", "month", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.monthInRange(month) }),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Date", "day", {
        com.anaplan.engineering.kazuki.toolkit.iso8601.dayInRange(day) }))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("Date invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: Year): Date = Date_Rec(t1,_2,_3)

    override fun construct(t1: Year, t2: Month): Date = Date_Rec(t1,t2,_3)

    override fun construct(
      t1: Year,
      t2: Month,
      t3: Day,
    ): Date = Date_Rec(t1,t2,t3)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Date")
        append("(")
        append("""year=$year, """)
        append("""month=$month, """)
        append("""day=$day""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2, _3).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple3<*, *, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2 && _3 == other._3
    }
  }
}
