package com.anaplan.engineering.kazuki.toolkit.iso8601

import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.reflect.KClass

public object Dtg_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Dtg.as_Tuple(): Tuple2<Date, Time> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Date, Time>
    } else {
      throw PreconditionFailure("Cannot convert instance of Dtg created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Dtg(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Date) {
      return false
    }
    if (other._2 !is Time) {
      return false
    }
    val candidate = Dtg_Rec(other._1 as Date, other._2 as Time, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: Dtg?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun Dtg.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_Dtg(other: Tuple2<Date, Time>): Dtg = Dtg_Rec(other._1, other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Dtg(other: Any): Dtg {
    if (other is Dtg) {
      return other as Dtg
    } else if (!is_Dtg(other)) {
      throw PreconditionFailure("""$other is not a Dtg""")
    } else {
      return as_Dtg(other as Tuple2<Date, Time>)
    }
  }

  public operator fun Dtg.component1(): Date = this.date

  public operator fun Dtg.component2(): Time = this.time

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Dtg> _A.`set`(date: Date = this.date, time: Time = this.time): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Date, Time, _A>).construct(date, time)
    } else {
      throw PreconditionFailure("Cannot set on instance of Dtg created outside Kazuki")
    }
  }

  public fun mk_Dtg(date: Date, time: Time): Dtg = Dtg_Rec(date, time)

  @_Record("date", "time")
  private data class Dtg_Rec(
    override val date: Date,
    override val time: Time,
    private val enforceInvariant: Boolean = true,
  ) : Dtg, _Tuple2<Date, Time, Dtg> {
    override val _1: Date = date

    override val _2: Time = time

    override val functions: DtgFunctions by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DtgFunctions(this)
    }


    override val properties: DtgProperties by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DtgProperties(this)
    }


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    override fun construct(t1: Date): Dtg = Dtg_Rec(t1,_2)

    override fun construct(t1: Date, t2: Time): Dtg = Dtg_Rec(t1,t2)

    internal fun isValid(): Boolean = true

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Dtg")
        append("(")
        append("""date=$date, """)
        append("""time=$time""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
