package com.anaplan.engineering.kazuki.toolkit.iso8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple1
import com.anaplan.engineering.kazuki.core.`internal`._Constructable1
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple1
import com.anaplan.engineering.kazuki.core.nat1
import com.anaplan.engineering.kazuki.toolkit.iso8601.Duration.Companion
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object Duration_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Duration.as_Tuple(): Tuple1<nat1> {
    if (this is Tuple1<*>) {
      return this as Tuple1<nat1>
    } else {
      throw PreconditionFailure("Cannot convert instance of Duration created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Duration(other: Any): Boolean {
    if (other !is _Tuple1<*, *>) {
      return false
    }
    if (other._1 !is nat1) {
      return false
    }
    val candidate = Duration_Rec(other._1 as nat1, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: Duration?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun Duration.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_Duration(other: Tuple1<nat1>): Duration = Duration_Rec(other._1)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Duration(other: Any): Duration {
    if (other is Duration) {
      return other as Duration
    } else if (!is_Duration(other)) {
      throw PreconditionFailure("""$other is not a Duration""")
    } else {
      return as_Duration(other as Tuple1<nat1>)
    }
  }

  public operator fun Duration.component1(): nat1 = this.milliseconds

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Duration> _A.`set`(milliseconds: nat1 = this.milliseconds): _A {
    if (this is _Constructable1<*, *>) {
      return (this as _Constructable1<nat1, _A>).construct(milliseconds)
    } else {
      throw PreconditionFailure("Cannot set on instance of Duration created outside Kazuki")
    }
  }

  public fun mk_Duration(milliseconds: nat1): Duration = Duration_Rec(milliseconds)

  @_Record("milliseconds")
  private data class Duration_Rec(
    override val milliseconds: nat1,
    private val enforceInvariant: Boolean = true,
  ) : Duration, _Tuple1<nat1, Duration> {
    override val _1: nat1 = milliseconds

    override val functions: DurationFunctions by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DurationFunctions(this)
    }


    override val properties: DurationProperties by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.DurationProperties(this)
    }


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple1::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("Duration", "millisNonNegative", ::millisNonNegative))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("Duration invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: nat1): Duration = Duration_Rec(t1)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Duration")
        append("(")
        append("""milliseconds=$milliseconds""")
        append(")")
      }
      return sb.toString()
    }

    override fun pretty(): String {
      val sb = StringBuilder().apply {
        append("(")
        append("""milliseconds=$milliseconds""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple1<*, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1
    }
  }
}
