package com.anaplan.engineering.kazuki.toolkit.iso8601

import com.anaplan.engineering.kazuki.core.InvariantFailure
import com.anaplan.engineering.kazuki.core.PreconditionFailure
import com.anaplan.engineering.kazuki.core.PrettyPrintable
import com.anaplan.engineering.kazuki.core.Tuple2
import com.anaplan.engineering.kazuki.core.`internal`._Constructable2
import com.anaplan.engineering.kazuki.core.`internal`._InvariantClause
import com.anaplan.engineering.kazuki.core.`internal`._Record
import com.anaplan.engineering.kazuki.core.`internal`._Tuple2
import java.lang.StringBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

public object Offset_Module {
  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun Offset.as_Tuple(): Tuple2<Duration, OffsetDirection> {
    if (this is Tuple2<*, *>) {
      return this as Tuple2<Duration, OffsetDirection>
    } else {
      throw PreconditionFailure("Cannot convert instance of Offset created outside Kazuki")
    }
  }

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun is_Offset(other: Any): Boolean {
    if (other !is _Tuple2<*, *, *>) {
      return false
    }
    if (other._1 !is Duration) {
      return false
    }
    if (other._2 !is OffsetDirection) {
      return false
    }
    val candidate = Offset_Rec(other._1 as Duration, other._2 as OffsetDirection, false)
    if (!(other.comparableWith.isInstance(candidate) &&
        candidate.comparableWith.isInstance(other))) {
      return false
    }
    return candidate.isValid()
  }

  public fun _pretty(obj: Offset?): String {
    if (obj is PrettyPrintable) {
      return obj.pretty()
    } else {
      return obj.toString()
    }
  }

  public fun Offset.pretty(): String {
    if (this is PrettyPrintable) {
      return this.pretty()
    } else {
      return this.toString()
    }
  }

  private fun as_Offset(other: Tuple2<Duration, OffsetDirection>): Offset = Offset_Rec(other._1,
      other._2)

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun as_Offset(other: Any): Offset {
    if (other is Offset) {
      return other as Offset
    } else if (!is_Offset(other)) {
      throw PreconditionFailure("""$other is not a Offset""")
    } else {
      return as_Offset(other as Tuple2<Duration, OffsetDirection>)
    }
  }

  public operator fun Offset.component1(): Duration = this.offsetDuration

  public operator fun Offset.component2(): OffsetDirection = this.offsetDirection

  @Suppress(names = arrayOf("UNCHECKED_CAST"))
  public fun <_A : Offset> _A.`set`(offsetDuration: Duration = this.offsetDuration,
      offsetDirection: OffsetDirection = this.offsetDirection): _A {
    if (this is _Constructable2<*, *, *>) {
      return (this as _Constructable2<Duration, OffsetDirection, _A>).construct(offsetDuration,
          offsetDirection)
    } else {
      throw PreconditionFailure("Cannot set on instance of Offset created outside Kazuki")
    }
  }

  public fun mk_Offset(offsetDuration: Duration, offsetDirection: OffsetDirection): Offset =
      Offset_Rec(offsetDuration, offsetDirection)

  @_Record("offsetDuration", "offsetDirection")
  private data class Offset_Rec(
    override val offsetDuration: Duration,
    override val offsetDirection: OffsetDirection,
    private val enforceInvariant: Boolean = true,
  ) : Offset, _Tuple2<Duration, OffsetDirection, Offset> {
    override val _1: Duration = offsetDuration

    override val _2: OffsetDirection = offsetDirection

    override val properties: OffsetProperties by lazy {
      com.anaplan.engineering.kazuki.toolkit.iso8601.OffsetProperties(this)
    }


    override val comparableWith: KClass<*> = com.anaplan.engineering.kazuki.core.Tuple2::class

    private val invariantClauses: List<_InvariantClause> =
        listOf(com.anaplan.engineering.kazuki.core.internal._InvariantClause("Offset", "offsetMoreThanDay", ::offsetMoreThanDay),
        com.anaplan.engineering.kazuki.core.internal._InvariantClause("Offset", "offsetGranularityTooFine", ::offsetGranularityTooFine))

    init {
      if (enforceInvariant) {
        if (invariantClauses.any { !it.holds }) {
          val failedClauses = invariantClauses.filter { !it.holds }.joinToString(" and ") {
              it.clauseName }
          throw InvariantFailure("Offset invariant failed in: " + failedClauses)
        }
      }
    }

    override fun construct(t1: Duration): Offset = Offset_Rec(t1,_2)

    override fun construct(t1: Duration, t2: OffsetDirection): Offset = Offset_Rec(t1,t2)

    internal fun isValid(): Boolean = invariantClauses.all { it.holds }

    override fun toString(): String {
      val sb = StringBuilder().apply {
        append("Offset")
        append("(")
        append("""offsetDuration=$offsetDuration, """)
        append("""offsetDirection=$offsetDirection""")
        append(")")
      }
      return sb.toString()
    }

    override fun pretty(): String {
      val sb = StringBuilder().apply {
        append("(")
        append("""offsetDuration=${com.anaplan.engineering.kazuki.toolkit.iso8601.Duration_Module._pretty(offsetDuration)}, """)
        append("""offsetDirection=$offsetDirection""")
        append(")")
      }
      return sb.toString()
    }

    override fun hashCode(): Int = com.anaplan.engineering.kazuki.core.mk_(_1, _2).hashCode()

    @Suppress(names = arrayOf("UNCHECKED_CAST"))
    override fun equals(other: Any?): Boolean {
      if (this === other) {
        return true
      }
      if (null == other) {
        return false
      }
      if (other !is _Tuple2<*, *, *>) {
        return false
      }
      if (!(other.comparableWith.isInstance(this) && this.comparableWith.isInstance(other))) {
        return false
      }
      return _1 == other._1 && _2 == other._2
    }
  }
}
