/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmanimation.api;

import com.anaplan.engineering.vdmanimation.api.Module;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\u000e\u001a\u00020\u0004H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/anaplan/engineering/vdmanimation/api/SpecificationStructure;", "", "modules", "", "", "Lcom/anaplan/engineering/vdmanimation/api/Module;", "(Ljava/util/Map;)V", "getModules", "()Ljava/util/Map;", "definitionExists", "", "moduleName", "definitionName", "module", "toString", "vdm-animation-api"})
public final class SpecificationStructure {
    @NotNull
    private final Map<String, Module> modules;

    public SpecificationStructure(@NotNull Map<String, Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
    }

    @NotNull
    public final Map<String, Module> getModules() {
        return this.modules;
    }

    @NotNull
    public final Module module(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Module module = this.modules.get(moduleName);
        if (module == null) {
            throw new IllegalArgumentException("No such module " + moduleName);
        }
        return module;
    }

    public final boolean definitionExists(@NotNull String moduleName, @NotNull String definitionName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)definitionName, (String)"definitionName");
        Module module = this.modules.get(moduleName);
        return module != null ? module.definitionExists(definitionName) : false;
    }

    @NotNull
    public String toString() {
        return this.modules.values().toString();
    }
}

