/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmanimation.overture;

import com.anaplan.engineering.vdmanimation.api.AnimationContext;
import com.anaplan.engineering.vdmanimation.api.AnimationResult;
import com.anaplan.engineering.vdmanimation.api.AnimationTarget;
import com.anaplan.engineering.vdmanimation.api.Module;
import com.anaplan.engineering.vdmanimation.api.SpecificationStructure;
import com.anaplan.engineering.vdmanimation.api.VdmAnimator;
import com.anaplan.engineering.vdmanimation.api.VdmDeclarationFailure;
import com.anaplan.engineering.vdmanimation.api.VdmFile;
import com.anaplan.engineering.vdmanimation.api.VdmInvariantFailure;
import com.anaplan.engineering.vdmanimation.api.VdmPostconditionFailure;
import com.anaplan.engineering.vdmanimation.api.VdmPreconditionFailure;
import com.anaplan.engineering.vdmanimation.api.VdmSpecification;
import com.anaplan.engineering.vdmanimation.api.VdmSpecificationException;
import com.anaplan.engineering.vdmanimation.overture.CoverageGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.overture.ast.definitions.ALocalDefinition;
import org.overture.ast.definitions.ATypeDefinition;
import org.overture.ast.definitions.AValueDefinition;
import org.overture.ast.definitions.SFunctionDefinition;
import org.overture.ast.modules.AModuleModules;
import org.overture.ast.patterns.AIdentifierPattern;
import org.overture.ast.patterns.PPattern;
import org.overture.interpreter.VDMSL;
import org.overture.interpreter.runtime.ContextException;
import org.overture.interpreter.runtime.ModuleInterpreter;
import org.overture.interpreter.util.ExitStatus;
import org.overture.interpreter.util.ModuleListInterpreter;
import org.overture.interpreter.values.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/anaplan/engineering/vdmanimation/overture/OvertureAnimator;", "Lcom/anaplan/engineering/vdmanimation/api/VdmAnimator;", "()V", "coverageGenerator", "Lcom/anaplan/engineering/vdmanimation/overture/CoverageGenerator;", "animate", "Lcom/anaplan/engineering/vdmanimation/api/AnimationResult;", "animationTarget", "Lcom/anaplan/engineering/vdmanimation/api/AnimationTarget;", "animationContext", "Lcom/anaplan/engineering/vdmanimation/api/AnimationContext;", "", "interpreter", "Lorg/overture/interpreter/runtime/ModuleInterpreter;", "module", "", "operation", "generateSpecificationFiles", "", "Ljava/io/File;", "specification", "Lcom/anaplan/engineering/vdmanimation/api/VdmSpecification;", "tmpDir", "Ljava/nio/file/Path;", "getStructure", "Lcom/anaplan/engineering/vdmanimation/api/SpecificationStructure;", "interpretSpecification", "context", "parseAndTypeCheck", "Lorg/overture/interpreter/VDMSL;", "Companion", "vdm-animation-overture"})
public final class OvertureAnimator
implements VdmAnimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoverageGenerator coverageGenerator = new CoverageGenerator();
    private static final Logger Log = LoggerFactory.getLogger(OvertureAnimator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AnimationResult animate(@NotNull AnimationTarget animationTarget, @NotNull AnimationContext animationContext) {
        boolean bl;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)animationTarget, (String)"animationTarget");
        Intrinsics.checkNotNullParameter((Object)animationContext, (String)"animationContext");
        Path tmpDir = Files.createTempDirectory("overture-animator-", new FileAttribute[0]);
        try {
            VdmSpecification vdmSpecification = animationTarget.getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            ModuleInterpreter interpreter = this.interpretSpecification(vdmSpecification, animationContext, tmpDir);
            boolean checkResult = this.animate(interpreter, animationTarget.getModule(), animationTarget.getOperation(), animationContext);
            stringArray = new String[]{animationTarget.getModule()};
            stringArray = new AnimationResult(checkResult, this.coverageGenerator.generate(interpreter, stringArray));
        }
        catch (Throwable throwable) {
            boolean bl2;
            Object object = System.getProperty("retainOvertureTempFiles");
            if (object == null) {
                bl2 = false;
            } else {
                String string = object;
                boolean bl3 = false;
                bl2 = Boolean.parseBoolean(string);
            }
            if (!bl2) {
                object = tmpDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tmpDir.toFile()");
                FilesKt.deleteRecursively((File)object);
            }
            throw throwable;
        }
        Object object = System.getProperty("retainOvertureTempFiles");
        if (object == null) {
            bl = false;
        } else {
            String string = object;
            boolean bl4 = false;
            bl = Boolean.parseBoolean(string);
        }
        if (!bl) {
            object = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)object);
        }
        return stringArray;
    }

    private final ModuleInterpreter interpretSpecification(VdmSpecification specification, AnimationContext context, Path tmpDir) {
        List<File> specificationFiles = this.generateSpecificationFiles(specification, tmpDir);
        VDMSL controller = this.parseAndTypeCheck(specificationFiles, context);
        ModuleInterpreter moduleInterpreter = controller.getInterpreter();
        if (moduleInterpreter == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.overture.interpreter.runtime.ModuleInterpreter");
        }
        return moduleInterpreter;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> generateSpecificationFiles(VdmSpecification specification, Path tmpDir) {
        void $this$mapTo$iv$iv;
        Log.info(Intrinsics.stringPlus((String)"Animating in ", (Object)tmpDir));
        Iterable $this$map$iv = specification.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void module;
            VdmFile vdmFile = (VdmFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File moduleFile = tmpDir.resolve(Intrinsics.stringPlus((String)module.getName(), (Object)".vdmsl")).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)moduleFile, (String)"moduleFile");
            FilesKt.writeText$default((File)moduleFile, (String)module.getText(), null, (int)2, null);
            File file = moduleFile;
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    private final boolean animate(ModuleInterpreter interpreter, String module, String operation, AnimationContext animationContext) {
        try {
            interpreter.init(null);
            interpreter.setDefaultName(module);
            Value value = interpreter.execute(Intrinsics.stringPlus((String)operation, (Object)"()"), null);
            return animationContext.getExpectFailure() ? false : value.boolValue(null);
        }
        catch (ContextException e) {
            if (animationContext.getExpectFailure()) {
                return true;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write('\n' + e.getMessage() + '\n');
            e.ctxt.printStackTrace(printWriter, true);
            Log.error(stringWriter.toString());
            int n = e.number;
            switch (n) {
                case 4072: {
                    throw new VdmPostconditionFailure((Exception)((Object)e));
                }
                case 4055: {
                    throw new VdmPreconditionFailure((Exception)((Object)e));
                }
                case 4060: {
                    throw new VdmInvariantFailure((Exception)((Object)e));
                }
                case 4087: {
                    throw new VdmDeclarationFailure((Exception)((Object)e));
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public SpecificationStructure getStructure(@NotNull VdmSpecification specification) {
        boolean bl;
        Object object;
        ModuleListInterpreter moduleListInterpreter;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        Path tmpDir = Files.createTempDirectory("overture-animator-", new FileAttribute[0]);
        try {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            AnimationContext animationContext = new AnimationContext(false, false, 3, null);
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            ModuleInterpreter interpreter = this.interpretSpecification(specification, animationContext, tmpDir);
            moduleListInterpreter = interpreter.modules;
            Intrinsics.checkNotNullExpressionValue((Object)moduleListInterpreter, (String)"interpreter.modules");
            Iterable $this$map$iv = (Iterable)moduleListInterpreter;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void $this$mapTo$iv$iv2;
                Iterable $this$filterIsInstanceTo$iv$iv;
                void $this$map$iv2;
                Object object2;
                Collection collection2;
                Object item$iv$iv22;
                void $this$map$iv3;
                void m;
                AModuleModules aModuleModules = (AModuleModules)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                LinkedList linkedList = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"m.exportdefs");
                Iterable $this$filterIsInstance$iv = linkedList;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection collection3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : iterable) {
                    if (!(element$iv$iv instanceof ATypeDefinition)) continue;
                    collection3.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)collection3;
                boolean $i$f$map22 = false;
                void var15_24 = $this$map$iv3;
                Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv22 : var15_24) {
                    void it;
                    ATypeDefinition aTypeDefinition = (ATypeDefinition)item$iv$iv22;
                    collection2 = collection4;
                    boolean bl3 = false;
                    object2 = it.getName().getName();
                    collection2.add(object2);
                }
                List types = (List)collection4;
                LinkedList $i$f$map22 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"m.exportdefs");
                Iterable $this$filterIsInstance$iv2 = $i$f$map22;
                boolean bl4 = false;
                Iterable iterable2 = $this$filterIsInstance$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean bl5 = false;
                for (Object element$iv$iv : iterable2) {
                    if (!(element$iv$iv instanceof ALocalDefinition)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
                boolean bl6 = false;
                void var16_34 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean bl7 = false;
                item$iv$iv22 = var16_34.iterator();
                while (item$iv$iv22.hasNext()) {
                    void it;
                    Object item$iv$iv3 = item$iv$iv22.next();
                    ALocalDefinition bl3 = (ALocalDefinition)item$iv$iv3;
                    collection2 = destination$iv$iv2;
                    boolean bl8 = false;
                    object2 = it.getValueDefinition();
                    collection2.add(object2);
                }
                List locals = (List)destination$iv$iv2;
                Collection collection5 = locals;
                LinkedList linkedList2 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList2, (String)"m.exportdefs");
                Iterable iterable3 = linkedList2;
                collection2 = collection5;
                boolean bl9 = false;
                destination$iv$iv2 = iterable3;
                Collection collection6 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof AValueDefinition)) continue;
                    collection6.add(element$iv$iv);
                }
                object2 = (List)collection6;
                Iterable iterable4 = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object2));
                boolean bl10 = false;
                $this$filterIsInstanceTo$iv$iv = iterable4;
                Collection collection7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
                    String string2;
                    void it;
                    AValueDefinition bl8 = (AValueDefinition)item$iv$iv4;
                    collection2 = collection7;
                    boolean bl11 = false;
                    if (it.getName() == null) {
                        PPattern pattern = it.getPattern();
                        if (!(pattern instanceof AIdentifierPattern)) throw new VdmSpecificationException("Cannot create VDM spec structure");
                        string2 = ((AIdentifierPattern)pattern).getName().getName();
                    } else {
                        string2 = it.getName().getName();
                    }
                    object2 = string2;
                    collection2.add(object2);
                }
                List values = (List)collection7;
                LinkedList linkedList3 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList3, (String)"m.exportdefs");
                Iterable iterable5 = linkedList3;
                boolean $i$f$filterIsInstance2 = false;
                Iterable iterable6 = iterable5;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : iterable6) {
                    if (!(element$iv$iv instanceof SFunctionDefinition)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Iterable iterable7 = (List)destination$iv$iv3;
                boolean $i$f$map3 = false;
                Iterable iterable8 = iterable7;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable7, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv5 : iterable8) {
                    void it;
                    SFunctionDefinition bl11 = (SFunctionDefinition)item$iv$iv5;
                    collection2 = destination$iv$iv3;
                    boolean bl12 = false;
                    object2 = it.getName().getName();
                    collection2.add(object2);
                }
                List list = (List)destination$iv$iv3;
                String string3 = string = m.getName().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.name.name");
                Pair pair = TuplesKt.to((Object)string3, (Object)new Module(string, types, values, list, null, 16, null));
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            Map map = MapsKt.toMap((Iterable)collection);
            moduleListInterpreter = new SpecificationStructure(map);
        }
        catch (Throwable throwable) {
            boolean bl13;
            Object object3 = System.getProperty("retainOvertureTempFiles");
            if (object3 == null) {
                bl13 = false;
            } else {
                String string = object3;
                boolean bl14 = false;
                bl13 = Boolean.parseBoolean(string);
            }
            if (bl13) throw throwable;
            object3 = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)object3);
            throw throwable;
        }
        Object object4 = System.getProperty("retainOvertureTempFiles");
        if (object4 == null) {
            bl = false;
        } else {
            object = object4;
            boolean bl15 = false;
            bl = Boolean.parseBoolean((String)object);
        }
        if (bl) return moduleListInterpreter;
        object4 = tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"tmpDir.toFile()");
        FilesKt.deleteRecursively((File)object4);
        return moduleListInterpreter;
    }

    private final VDMSL parseAndTypeCheck(List<? extends File> specification, AnimationContext animationContext) {
        VDMSL controller = new VDMSL();
        controller.setQuiet(animationContext.getQuiet());
        controller.setWarnings(!animationContext.getQuiet());
        ExitStatus parseStatus = controller.parse(specification);
        if (parseStatus != ExitStatus.EXIT_OK) {
            throw new VdmSpecificationException("VDM parse failed");
        }
        ExitStatus typeCheckStatus = controller.typeCheck();
        if (typeCheckStatus != ExitStatus.EXIT_OK) {
            throw new VdmSpecificationException("VDM type check failed");
        }
        return controller;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/anaplan/engineering/vdmanimation/overture/OvertureAnimator$Companion;", "", "()V", "Log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "vdm-animation-overture"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return Log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

