/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmanimation.overture;

import com.anaplan.engineering.vdmanimation.api.AnimationContext;
import com.anaplan.engineering.vdmanimation.api.AnimationResult;
import com.anaplan.engineering.vdmanimation.api.AnimationTarget;
import com.anaplan.engineering.vdmanimation.api.Module;
import com.anaplan.engineering.vdmanimation.api.SpecificationStructure;
import com.anaplan.engineering.vdmanimation.api.VdmAnimator;
import com.anaplan.engineering.vdmanimation.api.VdmDeclarationFailure;
import com.anaplan.engineering.vdmanimation.api.VdmFile;
import com.anaplan.engineering.vdmanimation.api.VdmInvariantFailure;
import com.anaplan.engineering.vdmanimation.api.VdmPostconditionFailure;
import com.anaplan.engineering.vdmanimation.api.VdmPreconditionFailure;
import com.anaplan.engineering.vdmanimation.api.VdmSpecification;
import com.anaplan.engineering.vdmanimation.api.VdmSpecificationException;
import com.anaplan.engineering.vdmanimation.overture.CoverageGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.overture.ast.definitions.ALocalDefinition;
import org.overture.ast.definitions.ATypeDefinition;
import org.overture.ast.definitions.AValueDefinition;
import org.overture.ast.definitions.SFunctionDefinition;
import org.overture.ast.modules.AModuleModules;
import org.overture.ast.patterns.AIdentifierPattern;
import org.overture.ast.patterns.PPattern;
import org.overture.interpreter.VDMSL;
import org.overture.interpreter.runtime.ContextException;
import org.overture.interpreter.runtime.ModuleInterpreter;
import org.overture.interpreter.util.ExitStatus;
import org.overture.interpreter.util.ModuleListInterpreter;
import org.overture.interpreter.values.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/anaplan/engineering/vdmanimation/overture/OvertureAnimator;", "Lcom/anaplan/engineering/vdmanimation/api/VdmAnimator;", "()V", "coverageGenerator", "Lcom/anaplan/engineering/vdmanimation/overture/CoverageGenerator;", "animate", "Lcom/anaplan/engineering/vdmanimation/api/AnimationResult;", "animationTarget", "Lcom/anaplan/engineering/vdmanimation/api/AnimationTarget;", "animationContext", "Lcom/anaplan/engineering/vdmanimation/api/AnimationContext;", "", "interpreter", "Lorg/overture/interpreter/runtime/ModuleInterpreter;", "module", "", "operation", "generateSpecificationFiles", "", "Ljava/io/File;", "specification", "Lcom/anaplan/engineering/vdmanimation/api/VdmSpecification;", "tmpDir", "Ljava/nio/file/Path;", "getStructure", "Lcom/anaplan/engineering/vdmanimation/api/SpecificationStructure;", "interpretSpecification", "context", "parseAndTypeCheck", "Lorg/overture/interpreter/VDMSL;", "Companion", "vdm-animation-overture"})
@SourceDebugExtension(value={"SMAP\nOvertureAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OvertureAnimator.kt\ncom/anaplan/engineering/vdmanimation/overture/OvertureAnimator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1549#2:147\n1620#2,3:148\n1549#2:151\n1620#2,2:152\n800#2,11:154\n1549#2:165\n1620#2,3:166\n800#2,11:169\n1549#2:180\n1620#2,3:181\n800#2,11:184\n1549#2:195\n1620#2,3:196\n800#2,11:199\n1549#2:210\n1620#2,3:211\n1622#2:214\n*S KotlinDebug\n*F\n+ 1 OvertureAnimator.kt\ncom/anaplan/engineering/vdmanimation/overture/OvertureAnimator\n*L\n49#1:147\n49#1:148,3\n96#1:151\n96#1:152,2\n97#1:154,11\n97#1:165\n97#1:166,3\n101#1:169,11\n101#1:180\n101#1:181,3\n102#1:184,11\n102#1:195\n102#1:196,3\n114#1:199,11\n114#1:210\n114#1:211,3\n96#1:214\n*E\n"})
public final class OvertureAnimator
implements VdmAnimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoverageGenerator coverageGenerator = new CoverageGenerator();
    private static final Logger Log = LoggerFactory.getLogger(OvertureAnimator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AnimationResult animate(@NotNull AnimationTarget animationTarget, @NotNull AnimationContext animationContext) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)animationTarget, (String)"animationTarget");
        Intrinsics.checkNotNullParameter((Object)animationContext, (String)"animationContext");
        Path tmpDir = Files.createTempDirectory("overture-animator-", new FileAttribute[0]);
        try {
            VdmSpecification vdmSpecification = animationTarget.getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            ModuleInterpreter interpreter = this.interpretSpecification(vdmSpecification, animationContext, tmpDir);
            boolean checkResult = this.animate(interpreter, animationTarget.getModule(), animationTarget.getOperation(), animationContext);
            stringArray = new String[]{animationTarget.getModule()};
            stringArray = new AnimationResult(checkResult, this.coverageGenerator.generate(interpreter, stringArray));
        }
        catch (Throwable throwable) {
            String string = System.getProperty("retainOvertureTempFiles");
            if (!(string != null ? Boolean.parseBoolean(string) : false)) {
                File file = tmpDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
                FilesKt.deleteRecursively((File)file);
            }
            throw throwable;
        }
        String string = System.getProperty("retainOvertureTempFiles");
        if (!(string != null ? Boolean.parseBoolean(string) : false)) {
            File file = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)file);
        }
        return stringArray;
    }

    private final ModuleInterpreter interpretSpecification(VdmSpecification specification, AnimationContext context, Path tmpDir) {
        List<File> specificationFiles = this.generateSpecificationFiles(specification, tmpDir);
        VDMSL controller = this.parseAndTypeCheck(specificationFiles, context);
        ModuleInterpreter moduleInterpreter = controller.getInterpreter();
        Intrinsics.checkNotNull((Object)moduleInterpreter, (String)"null cannot be cast to non-null type org.overture.interpreter.runtime.ModuleInterpreter");
        return moduleInterpreter;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> generateSpecificationFiles(VdmSpecification specification, Path tmpDir) {
        void $this$mapTo$iv$iv;
        Log.info("Animating in " + tmpDir);
        Iterable $this$map$iv = specification.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void module;
            VdmFile vdmFile = (VdmFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File moduleFile = tmpDir.resolve(module.getName() + ".vdmsl").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)moduleFile, (String)"moduleFile");
            FilesKt.writeText$default((File)moduleFile, (String)module.getText(), null, (int)2, null);
            collection.add(moduleFile);
        }
        return (List)destination$iv$iv;
    }

    private final boolean animate(ModuleInterpreter interpreter, String module, String operation, AnimationContext animationContext) {
        try {
            interpreter.init(null);
            interpreter.setDefaultName(module);
            Value value = interpreter.execute(operation + "()", null);
            return animationContext.getExpectFailure() ? false : value.boolValue(null);
        }
        catch (ContextException e) {
            if (animationContext.getExpectFailure()) {
                return true;
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write("\n" + e.getMessage() + "\n");
            e.ctxt.printStackTrace(printWriter, true);
            Log.error(stringWriter.toString());
            switch (e.number) {
                case 4072: {
                    throw new VdmPostconditionFailure((Exception)((Object)e));
                }
                case 4055: {
                    throw new VdmPreconditionFailure((Exception)((Object)e));
                }
                case 4060: {
                    throw new VdmInvariantFailure((Exception)((Object)e));
                }
                case 4087: {
                    throw new VdmDeclarationFailure((Exception)((Object)e));
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public SpecificationStructure getStructure(@NotNull VdmSpecification specification) {
        SpecificationStructure specificationStructure;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        Path tmpDir = Files.createTempDirectory("overture-animator-", new FileAttribute[0]);
        try {
            void $this$mapTo$iv$iv;
            AnimationContext animationContext = new AnimationContext(false, false, 3, null);
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            ModuleInterpreter interpreter = this.interpretSpecification(specification, animationContext, tmpDir);
            ModuleListInterpreter moduleListInterpreter = interpreter.modules;
            Intrinsics.checkNotNullExpressionValue((Object)moduleListInterpreter, (String)"interpreter.modules");
            Iterable $this$map$iv = (Iterable)moduleListInterpreter;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                Iterable $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                void $this$map$iv2;
                Collection collection;
                Object item$iv$iv22;
                void $this$mapTo$iv$iv3;
                void $this$map$iv3;
                void $this$filterIsInstanceTo$iv$iv2;
                void m;
                AModuleModules aModuleModules = (AModuleModules)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                LinkedList linkedList = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"m.exportdefs");
                Iterable $this$filterIsInstance$iv2 = linkedList;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv2;
                Collection collection3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof ATypeDefinition)) continue;
                    collection3.add(element$iv$iv);
                }
                $this$filterIsInstance$iv2 = (List)collection3;
                boolean $i$f$map2 = false;
                $this$filterIsInstanceTo$iv$iv2 = $this$map$iv3;
                Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv22 : $this$mapTo$iv$iv3) {
                    void it;
                    ATypeDefinition aTypeDefinition = (ATypeDefinition)item$iv$iv22;
                    collection = collection4;
                    boolean bl2 = false;
                    collection.add(it.getName().getName());
                }
                List types = (List)collection4;
                LinkedList linkedList2 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList2, (String)"m.exportdefs");
                Iterable $this$filterIsInstance$iv3 = linkedList2;
                boolean $i$f$filterIsInstance2 = false;
                Iterable iterable3 = $this$filterIsInstance$iv3;
                Collection destination$iv$iv2 = new ArrayList();
                boolean bl3 = false;
                for (Object element$iv$iv : iterable3) {
                    if (!(element$iv$iv instanceof ALocalDefinition)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv3 = (List)destination$iv$iv2;
                boolean $i$f$map222 = false;
                void var16_23 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean bl4 = false;
                item$iv$iv22 = var16_23.iterator();
                while (item$iv$iv22.hasNext()) {
                    void it;
                    Object item$iv$iv3 = item$iv$iv22.next();
                    ALocalDefinition bl2 = (ALocalDefinition)item$iv$iv3;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it.getValueDefinition());
                }
                List locals = (List)destination$iv$iv2;
                Collection collection5 = locals;
                LinkedList linkedList3 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList3, (String)"m.exportdefs");
                Iterable $i$f$map222 = linkedList3;
                collection = collection5;
                boolean bl6 = false;
                destination$iv$iv2 = $this$filterIsInstance$iv;
                Collection collection6 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof AValueDefinition)) continue;
                    collection6.add(element$iv$iv);
                }
                Iterable $this$map$iv4 = CollectionsKt.plus((Collection)collection, (Iterable)((List)collection6));
                boolean bl7 = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv4;
                Collection collection7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
                    String string;
                    void it;
                    AValueDefinition bl5 = (AValueDefinition)item$iv$iv4;
                    collection = collection7;
                    boolean bl8 = false;
                    if (it.getName() == null) {
                        PPattern pattern = it.getPattern();
                        if (!(pattern instanceof AIdentifierPattern)) throw new VdmSpecificationException("Cannot create VDM spec structure");
                        string = ((AIdentifierPattern)pattern).getName().getName();
                    } else {
                        string = it.getName().getName();
                    }
                    collection.add(string);
                }
                List values = (List)collection7;
                LinkedList linkedList4 = m.getExportdefs();
                Intrinsics.checkNotNullExpressionValue((Object)linkedList4, (String)"m.exportdefs");
                Iterable iterable4 = linkedList4;
                boolean $i$f$filterIsInstance3 = false;
                Iterable iterable5 = iterable4;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : iterable5) {
                    if (!(element$iv$iv instanceof SFunctionDefinition)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Iterable iterable6 = (List)destination$iv$iv3;
                boolean $i$f$map3 = false;
                Iterable iterable7 = iterable6;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable6, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv5 : iterable7) {
                    void it;
                    SFunctionDefinition bl8 = (SFunctionDefinition)item$iv$iv5;
                    collection = destination$iv$iv3;
                    boolean bl9 = false;
                    collection.add(it.getName().getName());
                }
                List functions = (List)destination$iv$iv3;
                String string = m.getName().getName();
                String string2 = m.getName().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"m.name.name");
                collection2.add(TuplesKt.to((Object)string, (Object)new Module(string2, types, values, functions, null, 16, null)));
            }
            Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            specificationStructure = new SpecificationStructure(map);
        }
        catch (Throwable throwable) {
            String string = System.getProperty("retainOvertureTempFiles");
            if (string != null ? Boolean.parseBoolean(string) : false) throw throwable;
            File file = tmpDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
            FilesKt.deleteRecursively((File)file);
            throw throwable;
        }
        String string = System.getProperty("retainOvertureTempFiles");
        if (string != null ? Boolean.parseBoolean(string) : false) return specificationStructure;
        File file = tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir.toFile()");
        FilesKt.deleteRecursively((File)file);
        return specificationStructure;
    }

    private final VDMSL parseAndTypeCheck(List<? extends File> specification, AnimationContext animationContext) {
        VDMSL controller = new VDMSL();
        controller.setQuiet(animationContext.getQuiet());
        controller.setWarnings(!animationContext.getQuiet());
        ExitStatus parseStatus = controller.parse(specification);
        if (parseStatus != ExitStatus.EXIT_OK) {
            throw new VdmSpecificationException("VDM parse failed");
        }
        ExitStatus typeCheckStatus = controller.typeCheck();
        if (typeCheckStatus != ExitStatus.EXIT_OK) {
            throw new VdmSpecificationException("VDM type check failed");
        }
        return controller;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/anaplan/engineering/vdmanimation/overture/OvertureAnimator$Companion;", "", "()V", "Log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "vdm-animation-overture"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return Log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

