/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmgradleplugin;

import com.anaplan.engineering.vdmgradleplugin.XmlHelper;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/anaplan/engineering/vdmgradleplugin/PomRewriter;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "addDependencies", "", "dependencies", "", "Lcom/anaplan/engineering/vdmgradleplugin/PomRewriter$Dependency;", "addDependenciesNode", "Lorg/w3c/dom/Node;", "document", "Lorg/w3c/dom/Document;", "addDependencyCharacteristic", "name", "", "value", "dependencyNode", "getUniqueNode", "path", "writeDocument", "Dependency", "vdm-gradle-plugin"})
public final class PomRewriter {
    @NotNull
    private final File file;

    public PomRewriter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void writeDocument(Document document) {
        DOMSource domSource = new DOMSource(document);
        StreamResult result = new StreamResult(new FileWriter(this.file));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        transformer.transform(domSource, result);
    }

    private final Node getUniqueNode(String path, Document document) {
        Object object;
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object object2 = xPath.compile(path).evaluate(document, XPathConstants.NODESET);
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.NodeList");
        }
        NodeList dependencies = (NodeList)object2;
        if (dependencies.getLength() == 0) {
            object = null;
        } else {
            if (dependencies.getLength() > 1) {
                throw new IllegalStateException("More than one node unexpectedly matches " + path + " in pom");
            }
            object2 = dependencies.item(0);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Node");
            }
            object = object2;
        }
        return object;
    }

    private final Node addDependenciesNode(Document document) {
        Node node = this.getUniqueNode("/project", document);
        if (node == null) {
            throw new IllegalStateException("No project node in pom file");
        }
        Node projectNode = node;
        Element dependenciesNode = document.createElement("dependencies");
        projectNode.appendChild(dependenciesNode);
        Intrinsics.checkNotNullExpressionValue((Object)dependenciesNode, (String)"dependenciesNode");
        return dependenciesNode;
    }

    private final void addDependencyCharacteristic(String name, String value, Node dependencyNode, Document document) {
        if (value != null) {
            Element element = document.createElement(name);
            Text text = document.createTextNode(value);
            element.appendChild(text);
            dependencyNode.appendChild(element);
        }
    }

    public final void addDependencies(@NotNull List<Dependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Document document = XmlHelper.INSTANCE.readDocument(this.file);
        Node node = this.getUniqueNode("/project/dependencies", document);
        Node dependenciesNode = node == null ? this.addDependenciesNode(document) : node;
        Iterable $this$forEach$iv = dependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency dependency = (Dependency)element$iv;
            boolean bl = false;
            Element dependencyNode = document.createElement("dependency");
            String string = dependency.getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyNode, (String)"dependencyNode");
            this.addDependencyCharacteristic("groupId", string, dependencyNode, document);
            this.addDependencyCharacteristic("artifactId", dependency.getArtifactId(), dependencyNode, document);
            this.addDependencyCharacteristic("version", dependency.getVersion(), dependencyNode, document);
            this.addDependencyCharacteristic("classifier", dependency.getClassifier(), dependencyNode, document);
            this.addDependencyCharacteristic("type", dependency.getType(), dependencyNode, document);
            this.addDependencyCharacteristic("scope", dependency.getScope(), dependencyNode, document);
            dependenciesNode.appendChild(dependencyNode);
        }
        this.writeDocument(document);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JK\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/anaplan/engineering/vdmgradleplugin/PomRewriter$Dependency;", "", "groupId", "", "artifactId", "version", "classifier", "type", "scope", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "getClassifier", "getGroupId", "getScope", "getType", "getVersion", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "vdm-gradle-plugin"})
    public static final class Dependency {
        @NotNull
        private final String groupId;
        @NotNull
        private final String artifactId;
        @NotNull
        private final String version;
        @Nullable
        private final String classifier;
        @Nullable
        private final String type;
        @Nullable
        private final String scope;

        public Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable String type, @Nullable String scope) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
            this.type = type;
            this.scope = scope;
        }

        public /* synthetic */ Dependency(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            this(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getClassifier() {
            return this.classifier;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String component1() {
            return this.groupId;
        }

        @NotNull
        public final String component2() {
            return this.artifactId;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @Nullable
        public final String component4() {
            return this.classifier;
        }

        @Nullable
        public final String component5() {
            return this.type;
        }

        @Nullable
        public final String component6() {
            return this.scope;
        }

        @NotNull
        public final Dependency copy(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable String type, @Nullable String scope) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new Dependency(groupId, artifactId, version, classifier, type, scope);
        }

        public static /* synthetic */ Dependency copy$default(Dependency dependency, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = dependency.groupId;
            }
            if ((n & 2) != 0) {
                string2 = dependency.artifactId;
            }
            if ((n & 4) != 0) {
                string3 = dependency.version;
            }
            if ((n & 8) != 0) {
                string4 = dependency.classifier;
            }
            if ((n & 0x10) != 0) {
                string5 = dependency.type;
            }
            if ((n & 0x20) != 0) {
                string6 = dependency.scope;
            }
            return dependency.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "Dependency(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", classifier=" + this.classifier + ", type=" + this.type + ", scope=" + this.scope + ')';
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = result * 31 + this.artifactId.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + (this.classifier == null ? 0 : this.classifier.hashCode());
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)other;
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)dependency.groupId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifactId, (Object)dependency.artifactId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)dependency.version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.classifier, (Object)dependency.classifier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)dependency.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scope, (Object)dependency.scope);
        }
    }
}

