/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmgradleplugin;

import com.anaplan.engineering.vdmgradleplugin.ManifestCreatorKt;
import com.anaplan.engineering.vdmgradleplugin.VdmGradlePluginKt;
import com.anaplan.engineering.vdmgradleplugin.ZipContents;
import com.anaplan.engineering.vdmgradleplugin.ZipUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0007J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/anaplan/engineering/vdmgradleplugin/VdmPackageTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mdSourceFiles", "Lorg/gradle/api/file/FileCollection;", "getMdSourceFiles", "()Lorg/gradle/api/file/FileCollection;", "packageMdSource", "", "getPackageMdSource", "()Z", "packageTestSource", "getPackageTestSource", "sourceFiles", "getSourceFiles", "testSourceFiles", "getTestSourceFiles", "vdmMdPackageFile", "Ljava/io/File;", "getVdmMdPackageFile", "()Ljava/io/File;", "vdmPackageFile", "getVdmPackageFile", "vdmTestPackageFile", "getVdmTestPackageFile", "createDocSourcePackage", "", "createPackages", "createSourcePackage", "createTestSourcePackage", "vdm-gradle-plugin"})
public class VdmPackageTask
extends DefaultTask {
    @InputFiles
    @NotNull
    public final FileCollection getSourceFiles() {
        Project project = this.getProject();
        Object[] objectArray = new Object[1];
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = VdmGradlePluginKt.getVdmSourceDir(project2);
        project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        objectArray[0] = VdmGradlePluginKt.locateSpecifications(file, VdmGradlePluginKt.getVdmConfig(project2).getDialect());
        ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(locateSpec\u2026oject.vdmConfig.dialect))");
        return (FileCollection)configurableFileCollection;
    }

    @OutputFile
    @NotNull
    public final File getVdmPackageFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return VdmGradlePluginKt.getVdmPackageFile(project);
    }

    @InputFiles
    @NotNull
    public final FileCollection getTestSourceFiles() {
        Project project = this.getProject();
        Object[] objectArray = new Object[1];
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = VdmGradlePluginKt.getVdmTestSourceDir(project2);
        project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        objectArray[0] = VdmGradlePluginKt.locateSpecifications(file, VdmGradlePluginKt.getVdmConfig(project2).getDialect());
        ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(locateSpec\u2026oject.vdmConfig.dialect))");
        return (FileCollection)configurableFileCollection;
    }

    @OutputFile
    @NotNull
    public final File getVdmTestPackageFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return VdmGradlePluginKt.getVdmTestPackageFile(project);
    }

    @InputFiles
    @NotNull
    public final FileCollection getMdSourceFiles() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String[] resourceTypes = VdmGradlePluginKt.getVdmConfig(project).getResourceFileTypes();
        Project project2 = this.getProject();
        Object[] objectArray = new Object[1];
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        File file = VdmGradlePluginKt.getVdmMdDir(project3);
        project3 = new SpreadBuilder(2);
        project3.add((Object)"md");
        project3.addSpread((Object)resourceTypes);
        objectArray[0] = VdmGradlePluginKt.locateFilesWithExtension(file, (String[])project3.toArray((Object[])new String[project3.size()]));
        project = project2.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.files(locateFile\u2026r, \"md\", *resourceTypes))");
        return (FileCollection)project;
    }

    @OutputFile
    @NotNull
    public final File getVdmMdPackageFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return VdmGradlePluginKt.getVdmMdPackageFile(project);
    }

    @Input
    public final boolean getPackageMdSource() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return VdmGradlePluginKt.getVdmConfig(project).getPackaging().getMdSource();
    }

    @Input
    public final boolean getPackageTestSource() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return VdmGradlePluginKt.getVdmConfig(project).getPackaging().getTestSource();
    }

    @TaskAction
    public final void createPackages() {
        this.createSourcePackage();
        this.createTestSourcePackage();
        this.createDocSourcePackage();
    }

    private final void createSourcePackage() {
        File file = this.getVdmPackageFile();
        ZipContents[] zipContentsArray = new ZipContents[2];
        Iterable iterable = (Iterable)this.getSourceFiles();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[0] = new ZipContents(iterable, null, VdmGradlePluginKt.getVdmSourceDir(project), 2, null);
        project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[1] = ManifestCreatorKt.createManifestForZip(project, "main");
        ZipUtilsKt.createZip(file, zipContentsArray);
    }

    private final void createDocSourcePackage() {
        if (!this.getPackageMdSource()) {
            return;
        }
        if (this.getMdSourceFiles().isEmpty()) {
            return;
        }
        File file = this.getVdmMdPackageFile();
        ZipContents[] zipContentsArray = new ZipContents[2];
        Iterable iterable = (Iterable)this.getMdSourceFiles();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[0] = new ZipContents(iterable, null, VdmGradlePluginKt.getVdmMdDir(project), 2, null);
        project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[1] = ManifestCreatorKt.createManifestForZip(project, "md");
        ZipUtilsKt.createZip(file, zipContentsArray);
    }

    private final void createTestSourcePackage() {
        if (!this.getPackageTestSource()) {
            return;
        }
        if (this.getTestSourceFiles().isEmpty()) {
            return;
        }
        File file = this.getVdmTestPackageFile();
        ZipContents[] zipContentsArray = new ZipContents[2];
        Iterable iterable = (Iterable)this.getTestSourceFiles();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[0] = new ZipContents(iterable, null, VdmGradlePluginKt.getVdmTestSourceDir(project), 2, null);
        project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        zipContentsArray[1] = ManifestCreatorKt.createManifestForZip(project, "test");
        ZipUtilsKt.createZip(file, zipContentsArray);
    }
}

